/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.figuramc.figura.lua.LuaNotNil;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec4;
import org.figuramc.figura.mixin.render.TextureAtlasAccessor;
import org.figuramc.figura.utils.LuaUtils;

@LuaWhitelist
@LuaTypeDoc(name="TextureAtlas", value="texture_atlas")
public class TextureAtlasAPI {
    private final TextureAtlas atlas;

    public TextureAtlasAPI(TextureAtlas atlas) {
        this.atlas = atlas;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="texture_atlas.list_sprites")
    public List<String> listSprites() {
        ArrayList<String> list = new ArrayList<String>();
        for (ResourceLocation res : ((TextureAtlasAccessor)this.atlas).getTexturesByName().keySet()) {
            list.add(res.toString());
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"path"})}, value="texture_atlas.get_sprite_uv")
    public FiguraVec4 getSpriteUV(@LuaNotNil String sprite) {
        ResourceLocation spriteLocation = LuaUtils.parsePath(sprite);
        TextureAtlasSprite s = this.atlas.m_118316_(spriteLocation);
        return FiguraVec4.of(s.m_118409_(), s.m_118411_(), s.m_118410_(), s.m_118412_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="texture_atlas.get_width")
    public int getWidth() {
        return ((TextureAtlasAccessor)this.atlas).getWidth();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="texture_atlas.get_height")
    public int getHeight() {
        return ((TextureAtlasAccessor)this.atlas).getHeight();
    }

    public String toString() {
        return "TextureAtlas (" + String.valueOf(this.atlas.m_118330_()) + ")";
    }
}

