/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.ducks.GuiMessageAccessor;
import org.figuramc.figura.lua.LuaNotNil;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.api.entity.EntityAPI;
import org.figuramc.figura.lua.api.world.ItemStackAPI;
import org.figuramc.figura.lua.docs.LuaFieldDoc;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.mixin.LivingEntityAccessor;
import org.figuramc.figura.mixin.gui.ChatComponentAccessor;
import org.figuramc.figura.mixin.gui.ChatScreenAccessor;
import org.figuramc.figura.model.rendering.texture.FiguraTexture;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.LuaUtils;
import org.figuramc.figura.utils.TextUtils;
import org.luaj.vm2.LuaError;

@LuaWhitelist
@LuaTypeDoc(name="HostAPI", value="host")
public class HostAPI {
    private final Avatar owner;
    private final boolean isHost;
    private final Minecraft minecraft;
    @LuaWhitelist
    @LuaFieldDoc(value="host.unlock_cursor")
    public boolean unlockCursor = false;
    public Integer chatColor;

    public HostAPI(Avatar owner) {
        this.owner = owner;
        this.minecraft = Minecraft.m_91087_();
        this.isHost = owner.isHost;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.is_host")
    public boolean isHost() {
        return this.isHost;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.is_cursor_unlocked")
    public boolean isCursorUnlocked() {
        return this.unlockCursor;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"boolean"})}, value="host.set_unlock_cursor")
    public HostAPI setUnlockCursor(boolean bool) {
        this.unlockCursor = bool;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"timesData"}), @LuaMethodOverload(argumentTypes={Integer.class, Integer.class, Integer.class}, argumentNames={"fadeInTime", "stayTime", "fadeOutTime"})}, aliases={"titleTimes"}, value="host.set_title_times")
    public HostAPI setTitleTimes(Object x, Double y, Double z) {
        if (!this.isHost()) {
            return this;
        }
        FiguraVec3 times = LuaUtils.parseVec3("setTitleTimes", x, y, z);
        this.minecraft.f_91065_.m_168684_((int)times.x, (int)times.y, (int)times.z);
        return this;
    }

    @LuaWhitelist
    public HostAPI titleTimes(Object x, Double y, Double z) {
        return this.setTitleTimes(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.clear_title")
    public HostAPI clearTitle() {
        if (this.isHost()) {
            this.minecraft.f_91065_.m_168713_();
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"})}, aliases={"title"}, value="host.set_title")
    public HostAPI setTitle(@LuaNotNil String text) {
        if (this.isHost()) {
            this.minecraft.f_91065_.m_168714_(TextUtils.tryParseJson(text));
        }
        return this;
    }

    @LuaWhitelist
    public HostAPI title(@LuaNotNil String text) {
        return this.setTitle(text);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"})}, aliases={"subtitle"}, value="host.set_subtitle")
    public HostAPI setSubtitle(@LuaNotNil String text) {
        if (this.isHost()) {
            this.minecraft.f_91065_.m_168711_(TextUtils.tryParseJson(text));
        }
        return this;
    }

    @LuaWhitelist
    public HostAPI subtitle(@LuaNotNil String text) {
        return this.setSubtitle(text);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"}), @LuaMethodOverload(argumentTypes={String.class, boolean.class}, argumentNames={"text", "animated"})}, aliases={"actionbar"}, value="host.set_actionbar")
    public HostAPI setActionbar(@LuaNotNil String text, boolean animated) {
        if (this.isHost()) {
            this.minecraft.f_91065_.m_93063_(TextUtils.tryParseJson(text), animated);
        }
        return this;
    }

    @LuaWhitelist
    public HostAPI actionbar(@LuaNotNil String text, boolean animated) {
        return this.setActionbar(text, animated);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"message"})}, value="host.send_chat_message")
    public HostAPI sendChatMessage(@LuaNotNil String message) {
        if (!this.isHost() || !((Boolean)Configs.CHAT_MESSAGES.value).booleanValue()) {
            return this;
        }
        ClientPacketListener connection = this.minecraft.m_91403_();
        if (connection != null) {
            connection.m_246175_(message);
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"command"})}, value="host.send_chat_command")
    public HostAPI sendChatCommand(@LuaNotNil String command) {
        if (!this.isHost() || !((Boolean)Configs.CHAT_MESSAGES.value).booleanValue()) {
            return this;
        }
        ClientPacketListener connection = this.minecraft.m_91403_();
        if (connection != null) {
            connection.m_246623_(command.startsWith("/") ? command.substring(1) : command);
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"message"})}, value="host.append_chat_history")
    public HostAPI appendChatHistory(@LuaNotNil String message) {
        if (this.isHost()) {
            this.minecraft.f_91065_.m_93076_().m_93783_(message);
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Integer.class}, argumentNames={"index"})}, value="host.get_chat_message")
    public Map<String, Object> getChatMessage(int index) {
        if (!this.isHost()) {
            return null;
        }
        List<GuiMessage> messages = ((ChatComponentAccessor)this.minecraft.f_91065_.m_93076_()).getAllMessages();
        if (--index < 0 || index >= messages.size()) {
            return null;
        }
        GuiMessage message = messages.get(index);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("addedTime", message.f_90786_());
        map.put("message", message.f_240363_().getString());
        map.put("json", message.f_240363_());
        map.put("backgroundColor", ((GuiMessageAccessor)message).figura$getColor());
        return map;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Integer.class}, argumentNames={"index"}), @LuaMethodOverload(argumentTypes={Integer.class, String.class}, argumentNames={"index", "newMessage"}), @LuaMethodOverload(argumentTypes={Integer.class, String.class, FiguraVec3.class}, argumentNames={"index", "newMessage", "backgroundColor"})}, value="host.set_chat_message")
    public HostAPI setChatMessage(int index, String newMessage, FiguraVec3 backgroundColor) {
        if (!this.isHost()) {
            return this;
        }
        List<GuiMessage> messages = ((ChatComponentAccessor)this.minecraft.f_91065_.m_93076_()).getAllMessages();
        if (--index < 0 || index >= messages.size()) {
            return this;
        }
        if (newMessage == null) {
            messages.remove(index);
        } else {
            GuiMessage old = messages.get(index);
            GuiMessage neww = new GuiMessage(this.minecraft.f_91065_.m_93079_(), TextUtils.tryParseJson(newMessage), null, GuiMessageTag.m_240466_((String)old.f_240363_().getString()));
            messages.set(index, neww);
            ((GuiMessageAccessor)neww).figura$setColor(backgroundColor != null ? ColorUtils.rgbToInt(backgroundColor) : ((GuiMessageAccessor)old).figura$getColor());
        }
        this.minecraft.f_91065_.m_93076_().m_93769_();
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"offhand"})}, value="host.swing_arm")
    public HostAPI swingArm(boolean offhand) {
        if (this.isHost() && this.minecraft.f_91074_ != null) {
            this.minecraft.f_91074_.m_6674_(offhand ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"slot"}), @LuaMethodOverload(argumentTypes={Integer.class}, argumentNames={"slot"})}, value="host.get_slot")
    public ItemStackAPI getSlot(@LuaNotNil Object slot) {
        if (!this.isHost()) {
            return null;
        }
        Entity e = this.owner.luaRuntime.getUser();
        if (e == null || !e.m_6084_()) {
            return ItemStackAPI.verify(ItemStack.f_41583_);
        }
        SlotAccess slotAccess = e.m_141942_(LuaUtils.parseSlot(slot, null));
        return ItemStackAPI.verify(slotAccess.m_142196_());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"slot"}), @LuaMethodOverload(argumentTypes={Integer.class}, argumentNames={"slot"}), @LuaMethodOverload(argumentTypes={String.class, String.class}, argumentNames={"slot", "item"}), @LuaMethodOverload(argumentTypes={Integer.class, ItemStackAPI.class}, argumentNames={"slot", "item"})}, value="host.set_slot")
    public HostAPI setSlot(@LuaNotNil Object slot, Object item) {
        if (!this.isHost() || slot == null && item == null || this.minecraft.f_91072_ == null || this.minecraft.f_91074_ == null || !this.minecraft.f_91072_.m_105295_().m_46408_()) {
            return this;
        }
        Inventory inventory = this.minecraft.f_91074_.m_150109_();
        int index = LuaUtils.parseSlot(slot, inventory);
        ItemStack stack = LuaUtils.parseItemStack("setSlot", item);
        inventory.m_6836_(index, stack);
        this.minecraft.f_91072_.m_105241_(stack, index + 36);
        return this;
    }

    @LuaWhitelist
    public HostAPI setBadge(int index, boolean value, boolean pride) {
        if (!this.isHost()) {
            return this;
        }
        if (!FiguraMod.debugModeEnabled()) {
            throw new LuaError("Congrats, you found this debug easter egg!");
        }
        Pair<BitSet, BitSet> badges = AvatarManager.getBadges(this.owner.owner);
        if (badges == null) {
            return this;
        }
        BitSet set = pride ? (BitSet)badges.getFirst() : (BitSet)badges.getSecond();
        set.set(index, value);
        return this;
    }

    @LuaWhitelist
    public HostAPI badge(int index, boolean value, boolean pride) {
        return this.setBadge(index, value, pride);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_chat_color")
    public Integer getChatColor() {
        return this.isHost() ? this.chatColor : null;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"color"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"r", "g", "b"})}, aliases={"chatColor"}, value="host.set_chat_color")
    public HostAPI setChatColor(Object x, Double y, Double z) {
        if (this.isHost()) {
            this.chatColor = x == null ? null : Integer.valueOf(ColorUtils.rgbToInt(LuaUtils.parseVec3("setChatColor", x, y, z)));
        }
        return this;
    }

    @LuaWhitelist
    public HostAPI chatColor(Object x, Double y, Double z) {
        return this.setChatColor(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_chat_text")
    public String getChatText() {
        Screen screen;
        if (this.isHost() && (screen = this.minecraft.f_91080_) instanceof ChatScreen) {
            ChatScreen chat = (ChatScreen)screen;
            return ((ChatScreenAccessor)chat).getInput().m_94155_();
        }
        return null;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"})}, aliases={"chatText"}, value="host.set_chat_text")
    public HostAPI setChatText(@LuaNotNil String text) {
        Screen screen;
        if (this.isHost() && ((Boolean)Configs.CHAT_MESSAGES.value).booleanValue() && (screen = this.minecraft.f_91080_) instanceof ChatScreen) {
            ChatScreen chat = (ChatScreen)screen;
            ((ChatScreenAccessor)chat).getInput().m_94144_(text);
        }
        return this;
    }

    @LuaWhitelist
    public HostAPI chatText(@LuaNotNil String text) {
        return this.setChatText(text);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_screen")
    public String getScreen() {
        if (!this.isHost() || this.minecraft.f_91080_ == null) {
            return null;
        }
        return this.minecraft.f_91080_.getClass().getName();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_screen_slot_count")
    public Integer getScreenSlotCount() {
        Screen screen;
        if (this.isHost() && (screen = this.minecraft.f_91080_) instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            return screen2.m_6262_().f_38839_.size();
        }
        return null;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"slot"}), @LuaMethodOverload(argumentTypes={Integer.class}, argumentNames={"slot"})}, value="host.get_screen_slot")
    public ItemStackAPI getScreenSlot(@LuaNotNil Object slot) {
        Screen screen;
        if (!this.isHost() || !((screen = this.minecraft.f_91080_) instanceof AbstractContainerScreen)) {
            return null;
        }
        AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
        NonNullList slots = screen2.m_6262_().f_38839_;
        int index = LuaUtils.parseSlot(slot, null);
        if (index < 0 || index >= slots.size()) {
            return null;
        }
        return ItemStackAPI.verify(((Slot)slots.get(index)).m_7993_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.is_chat_open")
    public boolean isChatOpen() {
        return this.isHost() && this.minecraft.f_91080_ instanceof ChatScreen;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.is_container_open")
    public boolean isContainerOpen() {
        return this.isHost() && this.minecraft.f_91080_ instanceof AbstractContainerScreen;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"name"})}, value="host.screenshot")
    public FiguraTexture screenshot(@LuaNotNil String name) {
        if (!this.isHost()) {
            return null;
        }
        NativeImage img = Screenshot.m_92279_((RenderTarget)this.minecraft.m_91385_());
        return this.owner.luaRuntime.texture.register(name, img, true);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.is_avatar_uploaded")
    public boolean isAvatarUploaded() {
        return this.isHost() && AvatarManager.localUploaded;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_status_effects")
    public List<Map<String, Object>> getStatusEffects() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        LocalPlayer player = this.minecraft.f_91074_;
        if (!this.isHost() || player == null) {
            return list;
        }
        for (MobEffectInstance effect : player.m_21220_()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", effect.m_19544_().m_19481_());
            map.put("amplifier", effect.m_19564_());
            map.put("duration", effect.m_19557_());
            map.put("visible", effect.m_19572_());
            list.add(map);
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_clipboard")
    public String getClipboard() {
        return this.isHost() ? this.minecraft.f_91068_.m_90876_() : null;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"})}, aliases={"clipboard"}, value="host.set_clipboard")
    public HostAPI setClipboard(@LuaNotNil String text) {
        if (this.isHost()) {
            this.minecraft.f_91068_.m_90911_(text);
        }
        return this;
    }

    @LuaWhitelist
    public HostAPI clipboard(@LuaNotNil String text) {
        return this.setClipboard(text);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_attack_charge")
    public float getAttackCharge() {
        LocalPlayer player = this.minecraft.f_91074_;
        if (this.isHost() && player != null) {
            return player.m_36403_(0.0f);
        }
        return 0.0f;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.is_jumping")
    public boolean isJumping() {
        LocalPlayer player = this.minecraft.f_91074_;
        if (this.isHost() && player != null) {
            return ((LivingEntityAccessor)player).isJumping();
        }
        return false;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.is_flying")
    public boolean isFlying() {
        LocalPlayer player = this.minecraft.f_91074_;
        if (this.isHost() && player != null) {
            return player.m_150110_().f_35935_;
        }
        return false;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_reach_distance")
    public double getReachDistance() {
        return this.minecraft.f_91072_ == null ? 0.0 : (double)this.minecraft.f_91072_.m_105286_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_air")
    public int getAir() {
        LocalPlayer player = this.minecraft.f_91074_;
        if (this.isHost() && player != null) {
            return player.m_20146_();
        }
        return 0;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_pick_block")
    public Object[] getPickBlock() {
        return this.isHost() ? LuaUtils.parseBlockHitResult(this.minecraft.f_91077_) : null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.get_pick_entity")
    public EntityAPI<?> getPickEntity() {
        return this.isHost() && this.minecraft.f_91076_ != null ? EntityAPI.wrap(this.minecraft.f_91076_) : null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="host.is_chat_verified")
    public boolean isChatVerified() {
        if (!this.isHost()) {
            return false;
        }
        ClientPacketListener connection = this.minecraft.m_91403_();
        PlayerInfo playerInfo = connection != null ? connection.m_104949_(this.owner.owner) : null;
        return playerInfo != null && playerInfo.m_247101_();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"string"})}, value="host.write_to_log")
    public void writeToLog(@LuaNotNil String string) {
        if (!this.isHost()) {
            return;
        }
        FiguraMod.LOGGER.info("[FIGURA/LUA] -- " + string);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"string"})}, value="host.warn_to_log")
    public void warnToLog(@LuaNotNil String string) {
        if (!this.isHost()) {
            return;
        }
        FiguraMod.LOGGER.warn("[FIGURA/LUA] -- " + string);
    }

    public Object __index(String arg) {
        if ("unlockCursor".equals(arg)) {
            return this.unlockCursor;
        }
        return null;
    }

    @LuaWhitelist
    public void __newindex(@LuaNotNil String key, Object value) {
        if (!"unlockCursor".equals(key)) {
            throw new LuaError("Cannot assign value on key \"" + key + "\"");
        }
        this.unlockCursor = (Boolean)value;
    }

    public String toString() {
        return "HostAPI";
    }
}

