/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.lua.LuaNotNil;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.ReadOnlyLuaTable;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.matrix.FiguraMatrix;
import org.figuramc.figura.math.vector.FiguraVector;
import org.figuramc.figura.utils.IOUtils;
import org.figuramc.figura.utils.MathUtils;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="ConfigAPI", value="config")
public class ConfigAPI {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final Avatar owner;
    private final boolean isHost;
    private LuaTable luaTable;
    private String name;
    private boolean loaded = false;

    public ConfigAPI(Avatar owner) {
        this.owner = owner;
        this.isHost = owner.isHost;
        this.name = owner.name;
    }

    public static Path getConfigDataDir() {
        return IOUtils.getOrCreateDir(FiguraMod.getFiguraDirectory(), "config");
    }

    public static void clearAllData() {
        IOUtils.deleteFile(ConfigAPI.getConfigDataDir());
    }

    private Path getPath() {
        try {
            Path dir = ConfigAPI.getConfigDataDir().toAbsolutePath();
            Path path = dir.resolve(Paths.get(this.name + ".json", new String[0])).toAbsolutePath();
            if (dir.compareTo(path.getParent()) != 0) {
                throw new Exception();
            }
            return path;
        }
        catch (Exception ignored) {
            throw new LuaError("Failed to parse file name \"" + this.name + "\"");
        }
    }

    private void write() {
        Path path = this.getPath();
        JsonObject root = new JsonObject();
        for (LuaValue key : this.luaTable.keys()) {
            root.add(key.toString(), ConfigAPI.writeArg(this.luaTable.get(key), new JsonObject()));
        }
        try (OutputStream fs = Files.newOutputStream(path, new OpenOption[0]);){
            fs.write(GSON.toJson((JsonElement)root).getBytes());
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("", (Throwable)e);
            throw new LuaError("Failed to save avatar data file");
        }
    }

    private static JsonElement writeArg(LuaValue val, JsonObject obj) {
        if (val.isboolean()) {
            obj.addProperty("type", Type.BOOL.name());
            obj.addProperty("data", Boolean.valueOf(val.checkboolean()));
        } else if (val instanceof LuaString) {
            LuaString str = (LuaString)val;
            ConfigAPI.writeString(str, obj);
        } else if (val.isint()) {
            obj.addProperty("type", Type.INT.name());
            obj.addProperty("data", (Number)val.checkinteger().v);
        } else if (val.isnumber()) {
            obj.addProperty("type", Type.DOUBLE.name());
            obj.addProperty("data", (Number)val.checkdouble());
        } else if (val.istable()) {
            ConfigAPI.writeTable(val.checktable(), obj);
        } else if (val.isuserdata(FiguraVector.class)) {
            ConfigAPI.writeVec((FiguraVector)val.checkuserdata(), obj);
        } else if (val.isuserdata(FiguraMatrix.class)) {
            ConfigAPI.writeMat((FiguraMatrix)val.checkuserdata(), obj);
        } else {
            return JsonNull.INSTANCE;
        }
        return obj;
    }

    private static void writeString(LuaString string, JsonObject obj) {
        int len = string.length();
        byte[] copyTarget = new byte[len];
        string.copyInto(0, copyTarget, 0, len);
        String b64 = Base64.getEncoder().encodeToString(copyTarget);
        obj.addProperty("type", Type.STRING.name());
        obj.addProperty("data", b64);
    }

    private static void writeTable(LuaTable table, JsonObject obj) {
        JsonArray tbl = new JsonArray();
        for (LuaValue key : table.keys()) {
            JsonElement val = ConfigAPI.writeArg(table.get(key), new JsonObject());
            if (val == JsonNull.INSTANCE) continue;
            JsonObject children = new JsonObject();
            children.add("key", ConfigAPI.writeArg(key, new JsonObject()));
            children.add("value", val);
            tbl.add((JsonElement)children);
        }
        obj.addProperty("type", Type.TABLE.name());
        obj.add("data", (JsonElement)tbl);
    }

    private static void writeVec(FiguraVector<?, ?> vector, JsonObject obj) {
        JsonArray vec = new JsonArray();
        for (int i = 0; i < vector.size(); ++i) {
            vec.add((Number)vector.index(i));
        }
        obj.addProperty("type", Type.VECTOR.name());
        obj.add("data", (JsonElement)vec);
    }

    private static void writeMat(FiguraMatrix<?, ?> matrix, JsonObject obj) {
        JsonArray mat = new JsonArray();
        for (int i = 0; i < matrix.cols(); ++i) {
            JsonObject vec = new JsonObject();
            ConfigAPI.writeVec(matrix.getColumn(i + 1), vec);
            mat.add((JsonElement)vec);
        }
        obj.addProperty("type", Type.MATRIX.name());
        obj.add("data", (JsonElement)mat);
    }

    private void init() {
        if (this.loaded) {
            return;
        }
        this.luaTable = new LuaTable();
        Path path = this.getPath();
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonElement element = JsonParser.parseReader((Reader)reader);
            if (element.isJsonNull()) {
                return;
            }
            JsonObject root = element.getAsJsonObject();
            for (String key : root.keySet()) {
                this.luaTable.set(key, ConfigAPI.readArg(root.get(key), this.owner));
            }
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("", (Throwable)e);
            throw new LuaError("Failed to load avatar data file");
        }
        this.loaded = true;
    }

    private static LuaValue readArg(JsonElement json, Avatar owner) {
        JsonObject obj = json.getAsJsonObject();
        Type type = Type.valueOf(obj.get("type").getAsString());
        JsonElement data = obj.get("data");
        return switch (type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> LuaBoolean.valueOf((boolean)data.getAsBoolean());
            case 1 -> LuaInteger.valueOf((int)data.getAsInt());
            case 2 -> LuaDouble.valueOf((double)data.getAsDouble());
            case 3 -> LuaString.valueOf((byte[])Base64.getDecoder().decode(data.getAsString()));
            case 4 -> ConfigAPI.readTable(data.getAsJsonArray(), owner);
            case 5 -> owner.luaRuntime.typeManager.javaToLua(ConfigAPI.readVec(data.getAsJsonArray())).arg1();
            case 6 -> owner.luaRuntime.typeManager.javaToLua(ConfigAPI.readMat(data.getAsJsonArray())).arg1();
        };
    }

    private static LuaValue readTable(JsonArray arr, Avatar owner) {
        LuaTable table = new LuaTable();
        for (int i = 0; i < arr.size(); ++i) {
            JsonObject entry = arr.get(i).getAsJsonObject();
            LuaValue key = ConfigAPI.readArg(entry.get("key"), owner);
            LuaValue val = ConfigAPI.readArg(entry.get("value"), owner);
            table.set(key, val);
        }
        return table;
    }

    private static FiguraVector<?, ?> readVec(JsonArray arr) {
        double[] array = new double[arr.size()];
        for (int i = 0; i < arr.size(); ++i) {
            array[i] = arr.get(i).getAsDouble();
        }
        return MathUtils.sizedVector(array);
    }

    private static FiguraMatrix<?, ?> readMat(JsonArray arr) {
        FiguraVector[] vectors = new FiguraVector[arr.size()];
        for (int i = 0; i < arr.size(); ++i) {
            JsonObject vec = arr.get(i).getAsJsonObject();
            vectors[i] = ConfigAPI.readVec(vec.get("data").getAsJsonArray());
        }
        return MathUtils.sizedMat(vectors);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="config.get_name")
    public String getName() {
        return this.name;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"name"})}, aliases={"name"}, value="config.set_name")
    public ConfigAPI setName(@LuaNotNil String name) {
        if (!this.isHost) {
            return this;
        }
        this.name = name;
        this.loaded = false;
        return this;
    }

    @LuaWhitelist
    public ConfigAPI name(@LuaNotNil String name) {
        return this.setName(name);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class, LuaValue.class}, argumentNames={"key", "value"})}, value="config.save")
    public ConfigAPI save(@LuaNotNil String key, LuaValue val) {
        if (!this.isHost) {
            return this;
        }
        this.init();
        val = val != null && (val.isboolean() || val.isstring() || val.isnumber() || val.istable() || val.isuserdata(FiguraVector.class) || val.isuserdata(FiguraMatrix.class)) ? val : LuaValue.NIL;
        this.luaTable.set(key, val);
        this.write();
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=LuaTable.class), @LuaMethodOverload(argumentTypes={String.class}, argumentNames={"key"}, returnType=Object.class)}, value="config.load")
    public Object load(String key) {
        if (!this.isHost) {
            return null;
        }
        this.init();
        return key != null ? this.luaTable.get(key) : new ReadOnlyLuaTable((LuaValue)this.luaTable);
    }

    public String toString() {
        return "ConfigAPI";
    }

    private static enum Type {
        BOOL,
        INT,
        DOUBLE,
        STRING,
        TABLE,
        VECTOR,
        MATRIX;

    }
}

