/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua;

import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

public class NbtToLua {
    private static final HashMap<Class<?>, Function<Tag, LuaValue>> CONVERTERS = new HashMap<Class<?>, Function<Tag, LuaValue>>(){
        {
            this.put(ByteTag.class, tag -> LuaValue.valueOf((int)((ByteTag)tag).m_7063_()));
            this.put(ShortTag.class, tag -> LuaValue.valueOf((int)((ShortTag)tag).m_7053_()));
            this.put(IntTag.class, tag -> LuaValue.valueOf((int)((IntTag)tag).m_7047_()));
            this.put(LongTag.class, tag -> LuaValue.valueOf((double)((LongTag)tag).m_7046_()));
            this.put(FloatTag.class, tag -> LuaValue.valueOf((double)((FloatTag)tag).m_7057_()));
            this.put(DoubleTag.class, tag -> LuaValue.valueOf((double)((DoubleTag)tag).m_7061_()));
            this.put(CompoundTag.class, tag -> {
                LuaTable table = new LuaTable();
                CompoundTag compound = (CompoundTag)tag;
                for (String key : compound.m_128431_()) {
                    table.set(key, NbtToLua.convert(compound.m_128423_(key)));
                }
                return table;
            });
            this.put(ByteArrayTag.class, tag -> NbtToLua.fromCollection((CollectionTag)tag));
            this.put(IntArrayTag.class, tag -> NbtToLua.fromCollection((CollectionTag)tag));
            this.put(LongArrayTag.class, tag -> NbtToLua.fromCollection((CollectionTag)tag));
            this.put(ListTag.class, tag -> NbtToLua.fromCollection((CollectionTag)tag));
        }
    };

    private static LuaValue fromCollection(CollectionTag<?> tag) {
        LuaTable table = new LuaTable();
        int i = 1;
        for (Tag children : tag) {
            table.set(i, NbtToLua.convert(children));
            ++i;
        }
        return table;
    }

    public static LuaValue convert(Tag tag) {
        if (tag == null) {
            return null;
        }
        Class clazz = tag.getClass();
        Function<Tag, LuaValue> builder = CONVERTERS.get(clazz);
        if (builder == null) {
            return LuaValue.valueOf((String)tag.m_7916_());
        }
        return builder.apply(tag);
    }
}

