/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.EntityType;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.lua.FiguraLuaRuntime;
import org.figuramc.figura.lua.LuaTypeManager;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.TextUtils;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.VarArgFunction;

public class FiguraLuaPrinter {
    public static DecimalFormat df;
    private static final Function<FiguraLuaRuntime, LuaValue> PRINT_FUNCTION;
    private static final Function<FiguraLuaRuntime, LuaValue> PRINT_JSON_FUNCTION;
    private static final Function<FiguraLuaRuntime, LuaValue> PRINT_TABLE_FUNCTION;
    private static final LinkedList<Component> chatQueue;
    private static final int MAX_CHARS_QUEUED = 10000000;
    private static int charsQueued;
    private static final int MAX_CHARS_PER_TICK = 10000;

    public static void updateDecimalFormatting() {
        int config = (Integer)Configs.LOG_NUMBER_LENGTH.value;
        df = new DecimalFormat("0" + (String)(config > 0 ? "." + "#".repeat(config) : ""));
        df.setRoundingMode(RoundingMode.DOWN);
    }

    public static void loadPrintFunctions(FiguraLuaRuntime runtime) {
        LuaValue print = PRINT_FUNCTION.apply(runtime);
        runtime.setGlobal("print", print);
        runtime.setGlobal("log", print);
        LuaValue printJson = PRINT_JSON_FUNCTION.apply(runtime);
        runtime.setGlobal("printJson", printJson);
        runtime.setGlobal("logJson", printJson);
        LuaValue printTable = PRINT_TABLE_FUNCTION.apply(runtime);
        runtime.setGlobal("printTable", printTable);
        runtime.setGlobal("logTable", printTable);
    }

    public static void sendLuaMessage(Object message, String owner) {
        MutableComponent mutableComponent;
        MutableComponent mutableComponent2 = Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"[lua] ").m_130948_(ColorUtils.Colors.LUA_LOG.style)).m_7220_((Component)Component.m_237113_((String)owner)).m_7220_((Component)Component.m_237113_((String)" : ").m_130948_(ColorUtils.Colors.LUA_LOG.style));
        if (message instanceof Component) {
            Component c = (Component)message;
            mutableComponent = c;
        } else {
            mutableComponent = Component.m_237113_((String)message.toString());
        }
        MutableComponent component = mutableComponent2.m_7220_((Component)mutableComponent).m_7220_((Component)Component.m_237113_((String)"\n"));
        if ((Integer)Configs.LOG_LOCATION.value == 0) {
            FiguraLuaPrinter.sendLuaChatMessage((Component)component);
        } else {
            FiguraMod.LOGGER.info(component.getString());
        }
    }

    public static void sendLuaError(LuaError error, Avatar owner) {
        Object message = error.toString().replace("org.luaj.vm2.LuaError: ", "").replace("\n\t[Java]: in ?", "").replace("'<eos>' expected", "Expected end of script");
        if (owner.minify) {
            message = (String)message + "\nscript:\n\tscript heavily minified! - cannot look for line numbers!";
        } else {
            try {
                String left;
                int sub;
                String name;
                String src;
                String[] split = ((String)message).split(":", 2);
                if (split.length > 1 && owner.luaRuntime != null && (src = owner.luaRuntime.scripts.get(name = (sub = split[0].indexOf(left = "[string \"")) == -1 ? split[0] : split[0].substring(sub + left.length(), split[0].indexOf("\"]")))) != null) {
                    int line = Integer.parseInt(split[1].split("\\D", 2)[0]);
                    Object str = src.split("\n")[line - 1].trim();
                    if (((String)str).length() > 96) {
                        str = ((String)str).substring(0, 96) + " [...]";
                    }
                    message = (String)message + "\nscript:\n\t" + (String)str;
                }
            }
            catch (Exception split) {
                // empty catch block
            }
        }
        MutableComponent component = Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"[error] ").m_130948_(ColorUtils.Colors.LUA_ERROR.style)).m_7220_((Component)Component.m_237113_((String)owner.entityName)).m_7220_((Component)Component.m_237113_((String)(" : " + (String)message)).m_130948_(ColorUtils.Colors.LUA_ERROR.style)).m_7220_((Component)Component.m_237113_((String)"\n"));
        owner.errorText = TextUtils.replaceTabs((FormattedText)Component.m_237113_((String)message).m_130948_(ColorUtils.Colors.LUA_ERROR.style));
        if (owner.entityType == EntityType.f_20532_ && !((Boolean)Configs.LOG_OTHERS.value).booleanValue() && !FiguraMod.isLocal(owner.owner) || owner.permissions.getCategory() == Permissions.Category.BLOCKED) {
            return;
        }
        chatQueue.offer((Component)component);
        FiguraMod.LOGGER.error("", (Throwable)error);
    }

    public static void sendPingMessage(Avatar owner, String ping, int size, LuaValue[] args) {
        int config = (Integer)Configs.LOG_PINGS.value;
        if (config == 0 || config == 1 && !owner.isHost) {
            return;
        }
        MutableComponent text = Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"[ping] ").m_130948_(ColorUtils.Colors.LUA_PING.style)).m_7220_((Component)Component.m_237113_((String)owner.entityName)).m_7220_((Component)Component.m_237113_((String)" : ").m_130948_(ColorUtils.Colors.LUA_PING.style)).m_130946_(ping).m_7220_((Component)Component.m_237113_((String)" :: ").m_130948_(ColorUtils.Colors.LUA_PING.style)).m_130946_(size + " bytes").m_7220_((Component)Component.m_237113_((String)" :: ").m_130948_(ColorUtils.Colors.LUA_PING.style));
        for (LuaValue arg : args) {
            text.m_7220_((Component)FiguraLuaPrinter.getPrintText(owner.luaRuntime.typeManager, arg, true, false)).m_130946_("\t");
        }
        text.m_7220_((Component)Component.m_237113_((String)"\n"));
        if ((Integer)Configs.LOG_LOCATION.value == 0) {
            FiguraLuaPrinter.sendLuaChatMessage((Component)text);
        } else {
            FiguraMod.LOGGER.info(text.getString());
        }
    }

    private static Component tableToText(LuaTypeManager typeManager, LuaValue value, int depth, int indent, boolean hasTooltip) {
        if (value.isuserdata()) {
            return FiguraLuaPrinter.userdataToText(typeManager, value, depth, indent, hasTooltip);
        }
        if (!value.istable() || depth <= 0) {
            return FiguraLuaPrinter.getPrintText(typeManager, value, hasTooltip, true);
        }
        MutableComponent text = Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"table:").m_130948_(FiguraLuaPrinter.getTypeColor(value))).m_7220_((Component)Component.m_237113_((String)" {\n").m_130940_(ChatFormatting.GRAY));
        String spacing = "\t".repeat(indent - 1);
        LuaTable table = value.checktable();
        for (LuaValue key : table.keys()) {
            text.m_7220_((Component)FiguraLuaPrinter.getTableEntry(typeManager, spacing, key, table.get(key), hasTooltip, depth, indent));
        }
        text.m_130946_(spacing).m_7220_((Component)Component.m_237113_((String)"}").m_130940_(ChatFormatting.GRAY));
        return text;
    }

    private static Component userdataToText(LuaTypeManager typeManager, LuaValue value, int depth, int indent, boolean hasTooltip) {
        if (!value.isuserdata() || depth <= 0) {
            return FiguraLuaPrinter.getPrintText(typeManager, value, hasTooltip, true);
        }
        MutableComponent text = Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"userdata:").m_130948_(FiguraLuaPrinter.getTypeColor(value))).m_7220_((Component)Component.m_237113_((String)" {\n").m_130940_(ChatFormatting.GRAY));
        String spacing = "\t".repeat(indent - 1);
        Object data = value.checkuserdata();
        Class<?> clazz = data.getClass();
        if (clazz.isAnnotationPresent(LuaWhitelist.class)) {
            HashSet<String> fields = new HashSet<String>();
            for (Field field : clazz.getFields()) {
                String name = field.getName();
                if (!field.isAnnotationPresent(LuaWhitelist.class) || fields.contains(name)) continue;
                try {
                    Object obj = field.get(data);
                    text.m_7220_((Component)FiguraLuaPrinter.getTableEntry(typeManager, spacing, (LuaValue)LuaValue.valueOf((String)name), typeManager.javaToLua(obj).arg1(), hasTooltip, depth, indent));
                    fields.add(name);
                }
                catch (Exception e) {
                    FiguraMod.LOGGER.error("", (Throwable)e);
                }
            }
            HashSet<String> methods = new HashSet<String>();
            for (Method method : clazz.getMethods()) {
                String name = method.getName();
                if (!method.isAnnotationPresent(LuaWhitelist.class) || name.startsWith("__") || methods.contains(name)) continue;
                text.m_7220_((Component)FiguraLuaPrinter.getTableEntry(typeManager, spacing, (LuaValue)LuaValue.valueOf((String)name), (LuaValue)typeManager.getWrapper(method), hasTooltip, depth, indent));
                methods.add(name);
            }
        }
        text.m_130946_(spacing).m_7220_((Component)Component.m_237113_((String)"}").m_130940_(ChatFormatting.GRAY));
        return text;
    }

    private static MutableComponent getTableEntry(LuaTypeManager typeManager, String spacing, LuaValue key, LuaValue value, boolean hasTooltip, int depth, int indent) {
        MutableComponent text = Component.m_237119_().m_130946_(spacing).m_130946_("\t");
        text.m_7220_((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)FiguraLuaPrinter.getPrintText(typeManager, key, hasTooltip, true)).m_7220_((Component)Component.m_237113_((String)"] = ").m_130940_(ChatFormatting.GRAY));
        if (value.istable() || value.isuserdata()) {
            text.m_7220_(FiguraLuaPrinter.tableToText(typeManager, value, depth - 1, indent + 1, hasTooltip));
        } else {
            text.m_7220_((Component)FiguraLuaPrinter.getPrintText(typeManager, value, hasTooltip, true));
        }
        text.m_130946_("\n");
        return text;
    }

    private static MutableComponent getPrintText(LuaTypeManager typeManager, LuaValue value, boolean hasTooltip, boolean quoteStrings) {
        Object ret;
        if (!(value instanceof LuaString) && value.isnumber()) {
            Double d = value.checkdouble();
            ret = d == Math.rint(d) ? value.tojstring() : df.format(d);
        } else {
            ret = value.tojstring();
            if (value.isstring() && quoteStrings) {
                ret = "\"" + (String)ret + "\"";
            }
        }
        MutableComponent text = Component.m_237113_((String)ret).m_130948_(FiguraLuaPrinter.getTypeColor(value));
        if (hasTooltip && (value.istable() || value.isuserdata())) {
            Component table = TextUtils.replaceTabs((FormattedText)FiguraLuaPrinter.tableToText(typeManager, value, 1, 1, false));
            text.m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)table)));
        }
        return text;
    }

    private static Style getTypeColor(LuaValue value) {
        if (value.istable()) {
            return ColorUtils.Colors.AWESOME_BLUE.style;
        }
        if (!(value instanceof LuaString) && value.isnumber()) {
            return ColorUtils.Colors.FIGURA_BLUE.style;
        }
        if (value.isnil()) {
            return ColorUtils.Colors.LUA_ERROR.style;
        }
        if (value.isboolean()) {
            return ColorUtils.Colors.LUA_PING.style;
        }
        if (value.isfunction()) {
            return Style.f_131099_.m_131140_(ChatFormatting.GREEN);
        }
        if (value.isuserdata()) {
            return Style.f_131099_.m_131140_(ChatFormatting.YELLOW);
        }
        if (value.isthread()) {
            return Style.f_131099_.m_131140_(ChatFormatting.GOLD);
        }
        return Style.f_131099_.m_131140_(ChatFormatting.WHITE);
    }

    private static void sendLuaChatMessage(Component message) throws LuaError {
        if ((charsQueued += message.getString().length()) > 10000000) {
            chatQueue.clear();
            charsQueued = 0;
            throw new LuaError("Chat overflow: printing too much!");
        }
        chatQueue.offer(message);
    }

    public static void clearPrintQueue() {
        chatQueue.clear();
    }

    public static void printChatFromQueue() {
        Component text;
        if (chatQueue.isEmpty()) {
            return;
        }
        MutableComponent toPrint = Component.m_237119_();
        int i = 10000;
        while (i > 0 && (text = chatQueue.poll()) != null) {
            int len = text.getString().length();
            if (len <= i) {
                i -= len;
                toPrint.m_7220_(text);
                continue;
            }
            chatQueue.offerFirst(TextUtils.substring((FormattedText)text, i, len));
            chatQueue.offerFirst(TextUtils.substring((FormattedText)text, 0, i));
        }
        String print = toPrint.getString();
        if (!print.isEmpty()) {
            charsQueued -= print.length();
            FiguraMod.sendChatMessage((Component)(print.endsWith("\n") ? TextUtils.substring((FormattedText)toPrint, 0, print.length() - 1) : toPrint));
        }
    }

    static {
        FiguraLuaPrinter.updateDecimalFormatting();
        PRINT_FUNCTION = runtime -> new VarArgFunction((FiguraLuaRuntime)runtime){
            final /* synthetic */ FiguraLuaRuntime val$runtime;
            {
                this.val$runtime = figuraLuaRuntime;
            }

            public Varargs invoke(Varargs args) {
                if (!((Boolean)Configs.LOG_OTHERS.value).booleanValue() && !FiguraMod.isLocal(this.val$runtime.owner.owner)) {
                    return NIL;
                }
                MutableComponent text = Component.m_237119_();
                for (int i = 0; i < args.narg(); ++i) {
                    text.m_7220_((Component)FiguraLuaPrinter.getPrintText(this.val$runtime.typeManager, args.arg(i + 1), true, false)).m_130946_("\t");
                }
                FiguraLuaPrinter.sendLuaMessage(text, this.val$runtime.owner.entityName);
                return LuaValue.valueOf((String)text.getString());
            }

            public String tojstring() {
                return "function: print";
            }
        };
        PRINT_JSON_FUNCTION = runtime -> new VarArgFunction((FiguraLuaRuntime)runtime){
            final /* synthetic */ FiguraLuaRuntime val$runtime;
            {
                this.val$runtime = figuraLuaRuntime;
            }

            public Varargs invoke(Varargs args) {
                boolean local = FiguraMod.isLocal(this.val$runtime.owner.owner);
                if (!((Boolean)Configs.LOG_OTHERS.value).booleanValue() && !local) {
                    return NIL;
                }
                TextUtils.allowScriptEvents = true;
                MutableComponent text = Component.m_237119_();
                for (int i = 0; i < args.narg(); ++i) {
                    text.m_7220_(TextUtils.tryParseJson(args.arg(i + 1).tojstring()));
                }
                TextUtils.allowScriptEvents = false;
                if (!local) {
                    FiguraLuaPrinter.sendLuaChatMessage(TextUtils.removeClickableObjects((FormattedText)text));
                } else {
                    FiguraLuaPrinter.sendLuaChatMessage((Component)text);
                }
                return LuaValue.valueOf((String)text.getString());
            }

            public String tojstring() {
                return "function: printJson";
            }
        };
        PRINT_TABLE_FUNCTION = runtime -> new VarArgFunction((FiguraLuaRuntime)runtime){
            final /* synthetic */ FiguraLuaRuntime val$runtime;
            {
                this.val$runtime = figuraLuaRuntime;
            }

            public Varargs invoke(Varargs args) {
                if (!((Boolean)Configs.LOG_OTHERS.value).booleanValue() && !FiguraMod.isLocal(this.val$runtime.owner.owner)) {
                    return NIL;
                }
                boolean silent = false;
                MutableComponent text = Component.m_237119_();
                if (args.narg() > 0) {
                    int depth = args.arg(2).isnumber() ? args.arg(2).checkint() : 1;
                    text.m_7220_(FiguraLuaPrinter.tableToText(this.val$runtime.typeManager, args.arg(1), depth, 1, true));
                    boolean bl = silent = args.arg(3).isboolean() && args.arg(3).checkboolean();
                }
                if (!silent) {
                    FiguraLuaPrinter.sendLuaMessage(text, this.val$runtime.owner.entityName);
                }
                return LuaValue.valueOf((String)text.getString());
            }

            public String tojstring() {
                return "function: printTable";
            }
        };
        chatQueue = new LinkedList();
        charsQueued = 0;
    }
}

