/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.lists;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.gui.widgets.FiguraWidget;
import org.figuramc.figura.gui.widgets.SliderWidget;
import org.figuramc.figura.gui.widgets.SwitchButton;
import org.figuramc.figura.gui.widgets.TextField;
import org.figuramc.figura.gui.widgets.lists.AbstractList;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.PermissionPack;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.ui.UIHelper;

public class PermissionsList
extends AbstractList {
    public boolean precise = false;
    private final Map<Component, List<GuiEventListener>> permissions = new LinkedHashMap<Component, List<GuiEventListener>>();

    public PermissionsList(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        boolean titles;
        int x = this.m_252754_();
        int y = this.m_252907_();
        int width = this.m_5711_();
        int height = this.m_93694_();
        UIHelper.blitSliced(gui, x, y, width, height, UIHelper.OUTLINE_FILL);
        this.enableScissors(gui);
        Font font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(font);
        int lineHeight = 9;
        int entryHeight = 27 + lineHeight;
        int titleHeight = 16 + lineHeight;
        int size = 0;
        for (List<GuiEventListener> value : this.permissions.values()) {
            size += value.size();
        }
        int totalHeight = size * entryHeight;
        boolean bl = titles = this.permissions.size() > 1;
        if (titles) {
            totalHeight += this.permissions.size() * titleHeight;
        }
        this.scrollBar.m_253211_(y + 4);
        this.scrollBar.setVisible(totalHeight > height);
        this.scrollBar.setScrollRatio(entryHeight, totalHeight - height);
        int xOffset = this.scrollBar.isVisible() ? 8 : 15;
        int yOffset = this.scrollBar.isVisible() ? (int)(-Mth.m_14139_((double)this.scrollBar.getScrollProgress(), (double)-16.0, (double)(totalHeight - height))) : 16;
        for (Map.Entry<Component, List<GuiEventListener>> entry : this.permissions.entrySet()) {
            if (titles) {
                gui.m_280653_(font, entry.getKey(), x + (width - xOffset) / 2, y + yOffset, 0xFFFFFF);
                yOffset += titleHeight;
            }
            for (GuiEventListener widget : entry.getValue()) {
                ((FiguraWidget)widget).m_252865_(x + xOffset);
                ((FiguraWidget)widget).m_253211_(y + yOffset);
                yOffset += entryHeight;
            }
        }
        super.m_88315_(gui, mouseX, mouseY, delta);
        gui.m_280618_();
    }

    public void updateList(PermissionPack container) {
        for (List<GuiEventListener> list : this.permissions.values()) {
            list.forEach(this.children::remove);
        }
        this.permissions.clear();
        this.permissions.put((Component)FiguraText.of(), this.generateWidgets(container, Permissions.DEFAULT, "figura"));
        for (Map.Entry entry : PermissionManager.CUSTOM_PERMISSIONS.entrySet()) {
            this.permissions.put((Component)Component.m_237115_((String)((String)entry.getKey())), this.generateWidgets(container, (Collection)entry.getValue(), (String)entry.getKey()));
        }
    }

    private List<GuiEventListener> generateWidgets(PermissionPack container, Collection<Permissions> coll, String id) {
        ArrayList<GuiEventListener> list = new ArrayList<GuiEventListener>();
        int x = this.m_252754_();
        int y = this.m_5711_();
        int width = this.m_5711_();
        for (Permissions permissions : coll) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            int lineHeight = 9;
            String text = id + ".permissions.value." + permissions.name.toLowerCase(Locale.US);
            FiguraWidget widget = !permissions.isToggle ? (!this.precise ? new PermissionSlider(x + 8, y, width - 30, 11 + lineHeight, container, permissions, this, id, text) : new PermissionField(x + 8, y, width - 30, 11 + lineHeight, container, permissions, this, id, text)) : new PermissionSwitch(x + 8, y, width - 30, 20 + lineHeight, container, permissions, this, id, text);
            list.add((GuiEventListener)widget);
            this.children.add(widget);
        }
        return list;
    }

    private static class PermissionSlider
    extends SliderWidget {
        private static final Component INFINITY = FiguraText.of("permissions.infinity");
        private final PermissionPack container;
        private final Permissions permissions;
        private final PermissionsList parent;
        private final String text;
        private Component value;
        private boolean changed;

        public PermissionSlider(int x, int y, int width, int height, PermissionPack container, Permissions permissions, PermissionsList parent, String id, String text) {
            super(x, y, width, height, Mth.m_14008_((double)((double)container.get(permissions) / ((double)permissions.max.intValue() + 1.0)), (double)0.0, (double)1.0), permissions.max / permissions.stepSize + 1, permissions.showSteps());
            this.container = container;
            this.permissions = permissions;
            this.parent = parent;
            this.text = text;
            this.value = container.get(permissions) == Integer.MAX_VALUE ? INFINITY : Component.m_237113_((String)String.valueOf(container.get(permissions)));
            this.changed = container.isChanged(permissions);
            this.setAction(slider -> {
                int value = this.showSteps ? ((SliderWidget)slider).getIntValue() * permissions.stepSize : (int)(((double)permissions.max.intValue() + 1.0) * slider.getScrollProgress());
                boolean infinity = permissions.checkInfinity(value);
                container.insert(permissions, infinity ? Integer.MAX_VALUE : value, id);
                this.changed = container.isChanged(permissions);
                this.value = infinity ? INFINITY : Component.m_237113_((String)String.valueOf(value));
            });
        }

        @Override
        public void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            PoseStack pose = gui.m_280168_();
            Font font = Minecraft.m_91087_().f_91062_;
            pose.m_85836_();
            Objects.requireNonNull(font);
            pose.m_252880_(0.0f, 9.0f, 0.0f);
            super.m_87963_(gui, mouseX, mouseY, delta);
            pose.m_85849_();
            MutableComponent name = Component.m_237115_((String)this.text);
            if (this.changed) {
                name = Component.m_237113_((String)"*").m_6270_(FiguraMod.getAccentColor()).m_7220_((Component)name).m_130946_("*");
            }
            int valueX = this.m_252754_() + this.m_5711_() - font.m_92852_((FormattedText)this.value) - 1;
            int x = this.m_252754_() + 1;
            int y = this.m_252907_() + 1;
            int width = valueX - this.m_252754_() - 2;
            UIHelper.renderScrollingText(gui, (Component)name, x, y, width, 0xFFFFFF);
            gui.m_280430_(font, (Component)this.value.m_6881_().m_6270_(FiguraMod.getAccentColor()), valueX, this.m_252907_() + 1, 0xFFFFFF);
            if (this.parent.isInsideScissors(mouseX, mouseY)) {
                Objects.requireNonNull(font);
                if (UIHelper.isMouseOver(x, y, width, 9, mouseX, mouseY)) {
                    UIHelper.setTooltip((Component)Component.m_237115_((String)(this.text + ".tooltip")));
                }
            }
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (!(this.m_142518_() && this.m_198029_() && this.m_5953_(mouseX, mouseY))) {
                return false;
            }
            if (button == 1) {
                this.container.reset(this.permissions);
                this.parent.updateList(this.container);
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        @Override
        public boolean m_5953_(double mouseX, double mouseY) {
            return this.parent.isInsideScissors(mouseX, mouseY) && super.m_5953_(mouseX, mouseY);
        }
    }

    private static class PermissionField
    extends TextField {
        private static final Predicate<String> validator = s -> {
            try {
                Integer i = Integer.parseInt(s);
                return i >= 0;
            }
            catch (Exception ignored) {
                return false;
            }
        };
        private final PermissionPack container;
        private final Permissions permissions;
        private final PermissionsList parent;
        private final String text;
        private Component value;
        private boolean changed;

        public PermissionField(int x, int y, int width, int height, PermissionPack container, Permissions permissions, PermissionsList parent, String id, String text) {
            super(x, y, width, height, null, null);
            this.container = container;
            this.permissions = permissions;
            this.parent = parent;
            this.text = text;
            String val = String.valueOf(container.get(permissions));
            this.value = Component.m_237113_((String)val);
            this.changed = container.isChanged(permissions);
            this.getField().m_94144_(val);
            this.getField().m_94151_(txt -> {
                if (!validator.test((String)txt)) {
                    return;
                }
                int value = Integer.parseInt(txt);
                container.insert(permissions, value, id);
                this.changed = container.isChanged(permissions);
                this.value = Component.m_237113_((String)String.valueOf(value));
            });
        }

        @Override
        public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            Font font = Minecraft.m_91087_().f_91062_;
            int color = 0xFFFFFF;
            String text = this.getField().m_94155_();
            if (!validator.test(text)) {
                color = 0xFF5555;
            } else if (this.changed) {
                TextColor textColor = FiguraMod.getAccentColor().m_131135_();
                color = textColor == null ? ColorUtils.Colors.AWESOME_BLUE.hex : textColor.m_131265_();
            }
            this.setColor(color);
            this.setBorderColour(-16777216 + color);
            super.m_88315_(gui, mouseX, mouseY, delta);
            MutableComponent name = Component.m_237115_((String)this.text);
            if (this.changed) {
                name = Component.m_237113_((String)"*").m_6270_(FiguraMod.getAccentColor()).m_7220_((Component)name).m_130946_("*");
            }
            int valueX = this.m_252754_() + this.m_5711_() - font.m_92852_((FormattedText)this.value) - 1;
            int x = this.m_252754_() + 1;
            int n = this.m_252907_() + 1;
            Objects.requireNonNull(font);
            int y = n - 9;
            int width = valueX - this.m_252754_() - 2;
            UIHelper.renderScrollingText(gui, (Component)name, x, y, width, 0xFFFFFF);
            MutableComponent mutableComponent = this.value.m_6881_().m_6270_(FiguraMod.getAccentColor());
            int n2 = this.m_252907_() + 1;
            Objects.requireNonNull(font);
            gui.m_280430_(font, (Component)mutableComponent, valueX, n2 - 9, 0xFFFFFF);
            if (this.parent.isInsideScissors(mouseX, mouseY)) {
                Objects.requireNonNull(font);
                if (UIHelper.isMouseOver(x, y, width, 9, mouseX, mouseY)) {
                    UIHelper.setTooltip((Component)Component.m_237115_((String)(this.text + ".tooltip")));
                }
            }
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (!this.isEnabled() || !this.m_5953_(mouseX, mouseY)) {
                return false;
            }
            if (button == 1) {
                this.container.reset(this.permissions);
                this.parent.updateList(this.container);
                this.getField().m_7435_(Minecraft.m_91087_().m_91106_());
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        @Override
        public boolean m_5953_(double mouseX, double mouseY) {
            return this.parent.isInsideScissors(mouseX, mouseY) && super.m_5953_(mouseX, mouseY);
        }
    }

    private static class PermissionSwitch
    extends SwitchButton {
        private final PermissionPack container;
        private final Permissions permissions;
        private final PermissionsList parent;
        private final String id;
        private final String text;
        private Component value;
        private boolean changed;

        public PermissionSwitch(int x, int y, int width, int height, PermissionPack container, Permissions permissions, PermissionsList parent, String id, String text) {
            super(x, y, width, height, (Component)Component.m_237115_((String)text), permissions.asBoolean(container.get(permissions)));
            this.container = container;
            this.permissions = permissions;
            this.parent = parent;
            this.id = id;
            this.text = text;
            this.changed = container.isChanged(permissions);
            this.value = FiguraText.of("permissions." + (this.toggled ? "enabled" : "disabled"));
        }

        @Override
        public void m_5691_() {
            boolean value = !this.isToggled();
            this.container.insert(this.permissions, value ? 1 : 0, this.id);
            this.changed = this.container.isChanged(this.permissions);
            this.value = FiguraText.of("permissions." + (value ? "enabled" : "disabled"));
            super.m_5691_();
        }

        @Override
        public void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            super.m_87963_(gui, mouseX, mouseY, delta);
            if (this.parent.isInsideScissors(mouseX, mouseY)) {
                int n = this.m_252754_() + 1;
                int n2 = this.m_252907_() + 1;
                int n3 = this.m_5711_() - 2;
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                if (UIHelper.isMouseOver(n, n2, n3, 9, mouseX, mouseY)) {
                    UIHelper.setTooltip((Component)Component.m_237115_((String)(this.text + ".tooltip")));
                }
            }
        }

        @Override
        protected void renderDefaultTexture(GuiGraphics gui, float delta) {
            PoseStack pose = gui.m_280168_();
            Font font = Minecraft.m_91087_().f_91062_;
            pose.m_85836_();
            Objects.requireNonNull(font);
            pose.m_252880_(0.0f, 9.0f, 0.0f);
            super.renderDefaultTexture(gui, delta);
            pose.m_85849_();
        }

        @Override
        protected void renderText(GuiGraphics gui, float delta) {
            Font font = Minecraft.m_91087_().f_91062_;
            MutableComponent name = this.m_6035_().m_6881_();
            if (this.changed) {
                name = Component.m_237113_((String)"*").m_6270_(FiguraMod.getAccentColor()).m_7220_((Component)name).m_130946_("*");
            }
            int valueX = this.m_252754_() + this.m_5711_() - font.m_92852_((FormattedText)this.value) - 1;
            int n = this.m_252907_();
            Objects.requireNonNull(font);
            int n2 = n + 9 + 11;
            Objects.requireNonNull(font);
            int valueY = n2 - 9 / 2;
            UIHelper.renderScrollingText(gui, (Component)name, this.m_252754_() + 1, this.m_252907_() + 1, this.m_5711_() - 2, 0xFFFFFF);
            gui.m_280430_(font, (Component)this.value.m_6881_().m_6270_(FiguraMod.getAccentColor()), valueX, valueY, 0xFFFFFF);
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (!(this.m_142518_() && this.m_198029_() && this.m_5953_(mouseX, mouseY))) {
                return false;
            }
            if (button == 1) {
                this.container.reset(this.permissions);
                this.parent.updateList(this.container);
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        @Override
        public boolean m_5953_(double mouseX, double mouseY) {
            return this.parent.isInsideScissors(mouseX, mouseY) && super.m_5953_(mouseX, mouseY);
        }
    }
}

