/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.lists;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.figuramc.figura.config.ConfigType;
import org.figuramc.figura.gui.widgets.AbstractContainerElement;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.IconButton;
import org.figuramc.figura.gui.widgets.ScrollBarWidget;
import org.figuramc.figura.gui.widgets.TextField;
import org.figuramc.figura.gui.widgets.lists.AbstractList;
import org.figuramc.figura.lua.api.net.NetworkingAPI;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.ui.UIHelper;

public class NetworkFilterList
extends AbstractList {
    private static final int LIST_ELEMENT_Y_GAP = 4;
    private final ConfigType.NetworkFilterConfig config;
    private final List<NetworkFilterEntry> entries = new ArrayList<NetworkFilterEntry>();
    private final Button addEntryButton;
    private final TextField searchTextField;
    private int scroll;
    private int listElementsHeightDifference;

    public NetworkFilterList(int x, int y, int width, int height, ConfigType.NetworkFilterConfig config) {
        super(x, y, width, height);
        this.scrollBar.setVisible(true);
        this.scrollBar.setHeight(height - 56);
        this.scrollBar.m_253211_(y + 28);
        this.scrollBar.setAction(this::onScroll);
        this.config = config;
        this.addEntryButton = new Button(x + 4, y + height - 24, width - 8, 20, (Component)FiguraText.of("gui.network_filter.list.add_filter_entry"), null, this::onEntryAddClick);
        this.children.add(this.addEntryButton);
        for (NetworkingAPI.Filter filter : config.getFilters()) {
            NetworkFilterEntry entry = new NetworkFilterEntry(this, x, y, width - 8 - this.scrollBar.m_5711_(), 20, filter);
            this.entries.add(entry);
            this.children.add(entry);
        }
        this.searchTextField = new TextField(x + 4, y + 4, width - 8, 20, TextField.HintType.SEARCH, this::onSearch);
        this.children.add(this.searchTextField);
        this.repositionContents();
        this.updateContentsHeightDiff();
        this.updateScrollBar();
    }

    private void onSearch(String s) {
        if (s.isBlank() || s.isEmpty()) {
            this.entries.forEach(e -> e.setVisible(true));
        } else {
            this.entries.forEach(e -> e.setVisible(e.getSourceFilter().getSource().contains(s)));
        }
        this.repositionContents();
        this.updateContentsHeightDiff();
        this.updateScrollBar();
    }

    private void onScroll(ScrollBarWidget scrollBarWidget) {
        this.scroll = (int)(scrollBarWidget.getScrollProgress() * (double)this.listElementsHeightDifference);
        this.repositionContents();
    }

    private void onDelete(NetworkFilterEntry networkFilterEntry) {
        this.entries.remove(networkFilterEntry);
        this.children.remove(networkFilterEntry);
        this.config.getFilters().remove(networkFilterEntry.getSourceFilter());
        this.repositionContents();
        this.updateContentsHeightDiff();
        this.updateScrollBar();
    }

    private void onEntryAddClick(net.minecraft.client.gui.components.Button button) {
        NetworkFilterEntry entry = new NetworkFilterEntry(this, this.m_252754_() + 4, this.entries.size() * 24, this.m_5711_() - 22, 20);
        this.entries.add(entry);
        this.children.add(entry);
        this.config.getFilters().add(entry.getSourceFilter());
        this.repositionContents();
        this.updateContentsHeightDiff();
        this.updateScrollBar();
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        int x = this.m_252754_();
        int y = this.m_252907_();
        int width = this.m_5711_();
        int height = this.m_93694_();
        UIHelper.blitSliced(gui, x, y, width, height, UIHelper.OUTLINE_FILL);
        super.m_88315_(gui, mouseX, mouseY, delta);
        this.updateScissors(4, 28, -18, -56);
        this.enableScissors(gui);
        for (NetworkFilterEntry entry : this.contents()) {
            if (!entry.isVisible()) continue;
            entry.m_88315_(gui, mouseX, mouseY, delta);
        }
        gui.m_280618_();
    }

    @Override
    public void m_93674_(int width) {
        super.m_93674_(width);
        this.repositionChildren();
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        this.repositionChildren();
        this.updateContentsHeightDiff();
        this.updateScrollBar();
    }

    @Override
    public void m_252865_(int x) {
        super.m_252865_(x);
        this.repositionChildren();
    }

    @Override
    public void m_253211_(int y) {
        super.m_253211_(y);
        this.repositionChildren();
    }

    private void updateScrollBar() {
        if (!this.entries.isEmpty() && this.listElementsHeightDifference > 0) {
            this.scrollBar.setVisible(true);
            this.scrollBar.setScrollProgress(Math.min(1.0, (double)this.scroll / (double)this.listElementsHeightDifference));
            this.scrollBar.setScrollRatio(20.0, this.listElementsHeightDifference);
        } else {
            this.scrollBar.setVisible(false);
        }
    }

    private void repositionChildren() {
        int x = this.m_252754_();
        int y = this.m_252907_();
        int width = this.m_5711_();
        int height = this.m_93694_();
        this.scrollBar.m_252865_(x + width - 14);
        this.scrollBar.m_253211_(y + 28);
        this.scrollBar.setHeight(height - 56);
        this.addEntryButton.m_252865_(x + 4);
        this.addEntryButton.m_253211_(y + height - 24);
        this.addEntryButton.m_93674_(width - 8);
        this.searchTextField.m_252865_(x + 4);
        this.searchTextField.m_253211_(y + 4);
        this.searchTextField.m_93674_(width - 8);
        this.repositionContents();
    }

    private void updateContentsHeightDiff() {
        int listElementsTotalHeight = 0;
        for (NetworkFilterEntry entry : this.entries) {
            if (!entry.isVisible()) continue;
            listElementsTotalHeight += 24;
        }
        if (listElementsTotalHeight > 0) {
            listElementsTotalHeight -= 4;
        }
        this.listElementsHeightDifference = Math.max(0, listElementsTotalHeight - (this.m_93694_() - 60));
    }

    private void repositionContents() {
        int x = this.m_252754_();
        int y = this.m_252907_();
        int width = this.m_5711_();
        int yOffset = 28 - this.scroll;
        for (NetworkFilterEntry entry : this.contents()) {
            if (!entry.isVisible()) continue;
            entry.m_252865_(x + 4);
            entry.m_253211_(y + yOffset);
            entry.m_93674_(width - 22);
            yOffset += 24;
        }
    }

    public List<NetworkFilterEntry> contents() {
        return this.entries;
    }

    public static class NetworkFilterEntry
    extends AbstractContainerElement {
        private static final ResourceLocation deleteButtonLocation = new ResourceLocation("figura", "textures/gui/delete.png");
        private final NetworkingAPI.Filter sourceFilter;
        private final IconButton deleteButton;
        private final TextField filterTextField;
        private final NetworkFilterList parent;

        public NetworkFilterEntry(NetworkFilterList parent, int x, int y, int width, int height) {
            this(parent, x, y, width, height, new NetworkingAPI.Filter("example.com"));
        }

        public NetworkFilterEntry(NetworkFilterList parent, int x, int y, int width, int height, NetworkingAPI.Filter sourceFilter) {
            super(x, y, width, height);
            this.parent = parent;
            this.sourceFilter = sourceFilter;
            this.filterTextField = new TextField(x, y, width - 118, 20, TextField.HintType.IP, this::onSourceChange);
            this.children.add(this.filterTextField);
            this.deleteButton = new IconButton(x + width - 20, y, 20, 20, 0, 0, 24, deleteButtonLocation, 72, 24, (Component)FiguraText.of("gui.network_filter.list.delete"), null, this::onDelete);
            this.children.add(this.deleteButton);
            this.filterTextField.getField().m_94144_(sourceFilter.getSource());
        }

        private void onDelete(net.minecraft.client.gui.components.Button button) {
            this.parent.onDelete(this);
        }

        @Override
        public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            super.m_88315_(gui, mouseX, mouseY, delta);
        }

        @Override
        public int m_93694_() {
            return 20;
        }

        private void onSourceChange(String s) {
            this.sourceFilter.setSource(s);
        }

        private void repositionChildren() {
            int x = this.m_252754_();
            int y = this.m_252907_();
            int width = this.m_5711_();
            this.filterTextField.m_252865_(x);
            this.filterTextField.m_253211_(y);
            this.filterTextField.m_93674_(width - 118);
            this.deleteButton.m_252865_(x + width - 20);
            this.deleteButton.m_253211_(y);
        }

        @Override
        public void m_252865_(int x) {
            super.m_252865_(x);
            this.repositionChildren();
        }

        @Override
        public void m_253211_(int y) {
            super.m_253211_(y);
            this.repositionChildren();
        }

        @Override
        public void m_93674_(int width) {
            super.m_93674_(width);
            this.repositionChildren();
        }

        @Override
        public void setHeight(int height) {
            super.setHeight(height);
            this.repositionChildren();
        }

        public NetworkingAPI.Filter getSourceFilter() {
            return this.sourceFilter;
        }
    }
}

