/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.avatar;

import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.local.LocalAvatarFetcher;
import org.figuramc.figura.gui.FiguraToast;
import org.figuramc.figura.gui.widgets.AbstractContainerElement;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.ContextMenu;
import org.figuramc.figura.gui.widgets.avatar.AvatarFolderWidget;
import org.figuramc.figura.gui.widgets.avatar.AvatarWidget;
import org.figuramc.figura.gui.widgets.lists.AvatarList;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.ui.UIHelper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAvatarWidget
extends AbstractContainerElement
implements Comparable<AbstractAvatarWidget> {
    protected static final int SPACING = 6;
    protected static final Component FAVOURITE = Component.m_237113_((String)"\u2605").m_130948_(Style.f_131099_.m_131150_(UIHelper.UI_FONT));
    protected static final Component ADD_FAVOURITE = FiguraText.of("gui.context.favorite.add");
    protected static final Component REMOVE_FAVOURITE = FiguraText.of("gui.context.favorite.remove");
    protected final AvatarList parent;
    protected final int depth;
    protected final ContextMenu context;
    protected LocalAvatarFetcher.AvatarPath avatar;
    protected Button button;
    protected String filter = "";
    protected boolean favourite;

    public AbstractAvatarWidget(int depth, int width, int height, LocalAvatarFetcher.AvatarPath avatar, AvatarList parent) {
        super(0, 0, width, height);
        this.parent = parent;
        this.avatar = avatar;
        this.depth = depth;
        this.context = new ContextMenu((GuiEventListener)this);
        this.favourite = avatar.isFavourite();
        this.context.addAction(this.favourite ? REMOVE_FAVOURITE : ADD_FAVOURITE, null, button -> {
            this.favourite = !this.favourite;
            avatar.setFavourite(this.favourite);
            button.m_93666_(this.favourite ? REMOVE_FAVOURITE : ADD_FAVOURITE);
            this.context.updateDimensions();
        });
        this.context.addAction((Component)FiguraText.of("gui.context.open_folder"), null, button -> {
            try {
                Util.m_137581_().m_137648_(avatar.getFSPath().toUri());
            }
            catch (Exception e) {
                FiguraMod.debug("failed to open avatar folder: ", e.getMessage());
                Util.m_137581_().m_137648_(LocalAvatarFetcher.getLocalAvatarDirectory().toUri());
            }
        });
        this.context.addAction((Component)FiguraText.of("gui.context.copy_path"), null, button -> {
            Minecraft.m_91087_().f_91068_.m_90911_(avatar.getFSPath().toString());
            FiguraToast.sendToast(FiguraText.of("toast.clipboard"));
        });
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible() || !this.button.isVisible()) {
            return;
        }
        super.m_88315_(gui, mouseX, mouseY, delta);
        if (this.favourite) {
            Font font = Minecraft.m_91087_().f_91062_;
            int width = font.m_92852_((FormattedText)FAVOURITE);
            int x = this.m_252754_() + this.m_5711_() - width;
            int y = this.m_252907_() + 2;
            gui.m_280614_(font, FAVOURITE, x, y, 0xFFFFFF, false);
            if (mouseX >= x && mouseX < x + width && mouseY >= y) {
                Objects.requireNonNull(font);
                if (mouseY < y + 9) {
                    UIHelper.setTooltip((Component)FiguraText.of("gui.favorited").m_130946_(" ").m_7220_(FAVOURITE));
                }
            }
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 1) {
            this.context.m_252865_((int)mouseX);
            this.context.m_253211_((int)mouseY);
            this.context.setVisible(true);
            UIHelper.setContext(this.context);
            return true;
        }
        if (UIHelper.getContext() == this.context) {
            this.context.setVisible(false);
        }
        return false;
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        return this.parent.isInsideScissors(mouseX, mouseY) && super.m_5953_(mouseX, mouseY);
    }

    public void update(LocalAvatarFetcher.AvatarPath path, String filter) {
        this.avatar = path;
        this.filter = filter.toLowerCase(Locale.US);
    }

    public Component getName() {
        return Component.m_237113_((String)this.avatar.getName());
    }

    @Override
    public void m_252865_(int x) {
        super.m_252865_(x);
        this.button.m_252865_(x);
    }

    @Override
    public void m_253211_(int y) {
        super.m_253211_(y);
        this.button.m_253211_(y);
    }

    public boolean filtered() {
        return this.getName().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US));
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible && this.filtered());
    }

    @Override
    public int compareTo(@NotNull AbstractAvatarWidget other) {
        if (this.favourite && !other.favourite) {
            return -1;
        }
        if (other.favourite && !this.favourite) {
            return 1;
        }
        if (this instanceof AvatarFolderWidget && other instanceof AvatarWidget) {
            return -1;
        }
        if (this instanceof AvatarWidget && other instanceof AvatarFolderWidget) {
            return 1;
        }
        return this.getName().getString().toLowerCase(Locale.US).compareTo(other.getName().getString().toLowerCase(Locale.US));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof AbstractAvatarWidget)) return false;
        AbstractAvatarWidget other = (AbstractAvatarWidget)obj;
        if (other.avatar == null) return false;
        if (this.avatar == null) return false;
        if (!this.avatar.getPath().equals(other.avatar.getPath())) return false;
        return true;
    }

    public boolean isOf(Path path) {
        return this.avatar != null && this.avatar.getTheActualPathForThis().equals(path);
    }
}

