/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.gui.widgets.AbstractContainerElement;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.ContextMenu;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.ui.UIHelper;

public class EnumButton
extends AbstractContainerElement {
    private final Button button;
    private int value;
    private final ContextMenu contextMenu;
    private final Consumer<Integer> onSelect;
    private final ArrayList<Component> names = new ArrayList();

    public EnumButton(int x, int y, int width, int height, String translationString, int defaultValue, int length, Consumer<Integer> onSelect) {
        super(x, y, width, height);
        int i;
        this.value = defaultValue;
        ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
        for (i = 0; i < length; ++i) {
            this.names.add((Component)FiguraText.of("%s.%s".formatted(translationString, i)));
            tooltips.add(FiguraText.of("%s.%s.tooltip".formatted(translationString, i)));
        }
        this.button = new Button(x, y, width, height, this.names.get(this.value % length), (Component)tooltips.get(this.value % length), this::onClick);
        this.children.add(this.button);
        this.contextMenu = new ContextMenu();
        this.contextMenu.m_252865_(this.button.m_252754_());
        this.contextMenu.m_253211_(this.button.m_252907_() + this.button.m_93694_());
        this.onSelect = onSelect;
        i = 0;
        while (i < length) {
            Component c = this.names.get(i);
            Component t = (Component)tooltips.get(i);
            int finalI = i++;
            this.contextMenu.addAction(c, t, b -> {
                this.button.m_93666_(c);
                this.button.setTooltip(t);
                onSelect.accept(finalI);
                this.updateContextText();
                this.value = finalI;
            });
        }
    }

    @Override
    public void m_252865_(int x) {
        super.m_252865_(x);
        this.button.m_252865_(x);
        this.contextMenu.m_252865_(this.button.m_252754_());
    }

    @Override
    public void m_253211_(int y) {
        super.m_253211_(y);
        this.button.m_253211_(y);
        this.contextMenu.m_253211_(this.button.m_252907_() + this.button.m_93694_());
    }

    @Override
    public void m_93674_(int width) {
        super.m_93674_(width);
        this.button.m_93674_(width);
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        this.button.setHeight(height);
        this.contextMenu.m_253211_(this.button.m_252907_() + this.button.m_93694_());
    }

    private void updateContextText() {
        List<? extends AbstractWidget> entries = this.contextMenu.getEntries();
        for (int i = 0; i < this.names.size(); ++i) {
            Component text = this.names.get(i);
            if (i == this.value % this.names.size()) {
                text = Component.m_237119_().m_6270_(FiguraMod.getAccentColor()).m_130940_(ChatFormatting.UNDERLINE).m_7220_(text);
            }
            entries.get(i).m_93666_(text);
        }
    }

    private void onClick(net.minecraft.client.gui.components.Button button) {
        this.contextMenu.setVisible(!this.contextMenu.isVisible());
        if (this.contextMenu.isVisible()) {
            UIHelper.setContext(this.contextMenu);
        }
    }
}

