/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.screens;

import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.gui.screens.AbstractPanelScreen;
import org.figuramc.figura.gui.screens.DocsScreen;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.IconButton;
import org.figuramc.figura.gui.widgets.Label;
import org.figuramc.figura.gui.widgets.ParticleWidget;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class HelpScreen
extends AbstractPanelScreen {
    public static final ResourceLocation ICONS = new FiguraIdentifier("textures/gui/help_icons.png");
    public static final String LUA_VERSION = "5.2 - Figura";
    private IconButton kofi;

    public HelpScreen(Screen parentScreen) {
        super(parentScreen, (Component)FiguraText.of("gui.panels.title.help"));
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        Objects.requireNonNull(this.f_96541_.f_91062_);
        int lineHeight = 9;
        int middle = this.f_96543_ / 2;
        int labelWidth = Math.min(this.f_96543_ - 8, 420);
        int y = 28;
        Style color = FiguraMod.getAccentColor();
        this.m_142416_(new Title((Object)FiguraText.of("gui.help.docs").m_130948_(color), middle, y, labelWidth));
        IconButton docs = new IconButton(middle - 60, y += lineHeight + 4, 120, 24, 20, 0, 20, ICONS, 60, 40, (Component)FiguraText.of("gui.help.ingame_docs"), null, button -> this.f_96541_.m_91152_((Screen)new DocsScreen(this)));
        this.m_142416_((GuiEventListener)docs);
        docs.setActive(false);
        this.m_142416_((GuiEventListener)new IconButton(middle - 60, y += 28, 120, 24, 0, 0, 20, ICONS, 60, 40, (Component)FiguraText.of("gui.help.lua_manual"), null, bx -> UIHelper.openURL(FiguraMod.Links.LuaManual.url).run()));
        this.m_142416_((GuiEventListener)new IconButton(middle - 60, y += 28, 120, 24, 40, 0, 20, ICONS, 60, 40, (Component)FiguraText.of("gui.help.external_wiki"), null, bx -> UIHelper.openURL(FiguraMod.Links.Wiki.url).run()));
        this.m_142416_(new Title((Object)FiguraText.of("gui.help.links").m_130948_(color), middle, y += 28, labelWidth));
        this.m_142416_((GuiEventListener)new IconButton(middle - 124, y += lineHeight + 4, 80, 24, 0, 20, 20, ICONS, 60, 40, (Component)Component.m_237113_((String)"Discord"), null, bx -> UIHelper.openURL(FiguraMod.Links.Discord.url).run()));
        this.m_142416_((GuiEventListener)new IconButton(middle - 40, y, 80, 24, 20, 20, 20, ICONS, 60, 40, (Component)Component.m_237113_((String)"GitHub"), null, bx -> UIHelper.openURL(FiguraMod.Links.Github.url).run()){

            @Override
            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (((Boolean)Configs.EASTER_EGGS.value).booleanValue() && this.m_198029_() && this.m_5953_(mouseX, mouseY) && button == 1) {
                    int dim = this.getTextureSize();
                    int x = (int)(Math.random() * (double)dim) + this.m_252754_() + 2;
                    int y = (int)(Math.random() * (double)dim) + this.m_252907_() + 2;
                    HelpScreen.this.m_169394_(new ParticleWidget(x, y, (ParticleType<?>)ParticleTypes.f_123750_));
                    boolean purr = Math.random() < 0.95;
                    HelpScreen.this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)(purr ? SoundEvents.f_11792_ : SoundEvents.f_11785_), (float)1.0f));
                    return false;
                }
                return super.m_6375_(mouseX, mouseY, button);
            }
        });
        this.kofi = new IconButton(middle + 44, y, 80, 24, 40, 20, 20, ICONS, 60, 40, (Component)Component.m_237113_((String)"Ko-fi"), null, b -> UIHelper.openURL(FiguraMod.Links.Kofi.url).run());
        this.m_142416_((GuiEventListener)this.kofi);
        this.m_142416_(new Title((Object)FiguraText.of("gui.help.about").m_130948_(color), middle, y += 28, labelWidth));
        this.m_142416_(new Label((Object)FiguraText.of("gui.help.lua_version", Component.m_237113_((String)LUA_VERSION).m_130948_(color)), middle, y += lineHeight + 4, TextUtils.Alignment.CENTER));
        this.m_142416_(new Label((Object)FiguraText.of("gui.help.figura_version", Component.m_237113_((String)FiguraMod.VERSION.toString()).m_130948_(color)), middle, y += lineHeight + 4, TextUtils.Alignment.CENTER));
        this.m_142416_((GuiEventListener)new Button(middle - 60, this.f_96544_ - 24, 120, 20, (Component)FiguraText.of("gui.done"), null, bx -> this.m_7379_()));
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (FiguraMod.ticks % 5 == 0 && this.kofi.m_198029_()) {
            int x = (int)(Math.random() * (double)this.kofi.m_5711_()) + this.kofi.m_252754_();
            int y = (int)(Math.random() * (double)this.kofi.m_93694_()) + this.kofi.m_252907_();
            this.m_169394_(new ParticleWidget(x, y, (ParticleType<?>)ParticleTypes.f_123748_));
        }
    }

    private static class Title
    extends Label {
        private final int width;

        public Title(Object text, int x, int y, int width) {
            super(text, x, y, TextUtils.Alignment.CENTER);
            this.width = width;
        }

        @Override
        public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            int x = this.getRawX();
            int y = this.getRawY();
            int y0 = y + this.m_93694_() / 2;
            int y1 = y0 + 1;
            int x0 = x - this.width / 2;
            int x1 = x - this.m_5711_() / 2 - 4;
            gui.m_280509_(x0, y0, x1, y1, -1);
            x0 = x + this.m_5711_() / 2 + 4;
            x1 = x + this.width / 2;
            gui.m_280509_(x0, y0, x1, y1, -1);
            super.m_88315_(gui, mouseX, mouseY, delta);
        }
    }
}

