/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.gui.screens.GameScreen;
import org.figuramc.figura.gui.widgets.ContextMenu;
import org.figuramc.figura.gui.widgets.FiguraRemovable;
import org.figuramc.figura.gui.widgets.FiguraTickable;
import org.figuramc.figura.gui.widgets.PanelSelectorWidget;
import org.figuramc.figura.lua.api.ClientAPI;
import org.figuramc.figura.mixin.gui.ScreenAccessor;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.ui.UIHelper;

public abstract class AbstractPanelScreen
extends Screen {
    public static final List<ResourceLocation> BACKGROUNDS = List.of(new FiguraIdentifier("textures/gui/background/background_0.png"), new FiguraIdentifier("textures/gui/background/background_1.png"), new FiguraIdentifier("textures/gui/background/background_2.png"));
    protected final Screen parentScreen;
    public PanelSelectorWidget panels;
    public ContextMenu contextMenu;
    public Component tooltip;
    private static final String EGG = "\u0109\u0109\u0108\u0108\u0107\u0106\u0107\u0106BA\u0101";
    private String egg = "\u0109\u0109\u0108\u0108\u0107\u0106\u0107\u0106BA\u0101";

    protected AbstractPanelScreen(Screen parentScreen, Component title) {
        super(title);
        this.parentScreen = parentScreen;
    }

    public Class<? extends Screen> getSelectedPanel() {
        return ((Object)((Object)this)).getClass();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.panels = new PanelSelectorWidget(this.parentScreen, 0, 0, this.f_96543_, this.getSelectedPanel());
        this.m_142416_((GuiEventListener)this.panels);
        this.contextMenu = null;
        this.tooltip = null;
    }

    public void m_86600_() {
        for (Renderable renderable : this.renderables()) {
            if (!(renderable instanceof FiguraTickable)) continue;
            FiguraTickable tickable = (FiguraTickable)renderable;
            tickable.tick();
        }
        this.renderables().removeIf(r -> {
            FiguraRemovable removable;
            return r instanceof FiguraRemovable && (removable = (FiguraRemovable)r).isRemoved();
        });
        super.m_86600_();
    }

    public List<Renderable> renderables() {
        return ((ScreenAccessor)((Object)this)).getRenderables();
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        this.renderBackground(gui, delta);
        super.m_88315_(gui, mouseX, mouseY, delta);
        this.renderOverlays(gui, mouseX, mouseY, delta);
    }

    public void renderBackground(GuiGraphics gui, float delta) {
        float speed = ((Float)Configs.BACKGROUND_SCROLL_SPEED.tempValue).floatValue() * 0.125f;
        for (ResourceLocation background : BACKGROUNDS) {
            UIHelper.renderAnimatedBackground(gui, background, 0.0f, 0.0f, this.f_96543_, this.f_96544_, 64.0f, 64.0f, speed, delta);
            speed = (float)((double)speed / 0.5);
        }
    }

    public void renderOverlays(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (((Boolean)Configs.GUI_FPS.value).booleanValue()) {
            gui.m_280488_(Minecraft.m_91087_().f_91062_, ClientAPI.getFPS() + " fps", 1, 1, 0xFFFFFF);
        }
        if (this.contextMenu != null && this.contextMenu.isVisible()) {
            PoseStack pose = gui.m_280168_();
            pose.m_85836_();
            pose.m_252880_(0.0f, 0.0f, 500.0f);
            this.contextMenu.m_88315_(gui, mouseX, mouseY, delta);
            pose.m_85849_();
        }
        if (this.tooltip != null) {
            UIHelper.renderTooltip(gui, this.tooltip, mouseX, mouseY, true);
        }
        this.tooltip = null;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.contextMenuClick(mouseX, mouseY, button)) {
            return true;
        }
        GuiEventListener widget = null;
        for (GuiEventListener children : List.copyOf(this.m_6702_())) {
            boolean clicked = children.m_6375_(mouseX, mouseY, button);
            children.m_93692_(clicked);
            if (!clicked) continue;
            widget = children;
        }
        if (this.m_7222_() != widget) {
            this.m_7522_(widget);
        }
        if (widget != null) {
            if (button == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        return false;
    }

    public boolean contextMenuClick(double mouseX, double mouseY, int button) {
        if (this.contextMenu != null && this.contextMenu.isVisible()) {
            boolean clicked = this.contextMenu.m_6375_(mouseX, mouseY, button);
            if (!clicked && this.contextMenu.parent != null && this.contextMenu.parent.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            this.contextMenu.setVisible(false);
            return clicked;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.m_7222_() != null && this.m_7222_().m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        boolean bool;
        boolean bl = bool = this.m_7222_() != null && this.m_7222_().m_6348_(mouseX, mouseY, button);
        if (bool) {
            this.m_7522_(null);
        }
        this.m_7897_(false);
        return bool;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.contextMenu != null) {
            this.contextMenu.setVisible(false);
        }
        boolean ret = false;
        for (GuiEventListener child : this.m_6702_()) {
            if (!child.m_5953_(mouseX, mouseY)) continue;
            ret = ret || child.m_6050_(mouseX, mouseY, amount);
        }
        return ret;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.egg = this.egg + (char)keyCode;
        this.egg = this.egg.substring(1);
        if (EGG.equals(this.egg)) {
            Minecraft.m_91087_().m_91152_((Screen)new GameScreen(this));
            return true;
        }
        if (this.m_6702_().contains(this.panels) && this.panels.cycleTab(keyCode)) {
            return true;
        }
        if (keyCode == 256 && this.contextMenu != null && this.contextMenu.isVisible()) {
            this.contextMenu.setVisible(false);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

