/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.entries.forge;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.entries.annotations.FiguraAPIPlugin;
import org.figuramc.figura.entries.annotations.FiguraEventPlugin;
import org.figuramc.figura.entries.annotations.FiguraPermissionsPlugin;
import org.figuramc.figura.entries.annotations.FiguraScreenPlugin;
import org.figuramc.figura.entries.annotations.FiguraVanillaPartPlugin;
import org.objectweb.asm.Type;

public class EntryPointManagerImpl {
    public static final Map<String, Class<?>> nameToAnnotationClass = new HashMap();

    public static <T> Set<T> load(String name, Class<T> clazz) {
        HashSet<T> ret = new HashSet<T>();
        Class<?> annotationClass = nameToAnnotationClass.get(name);
        if (annotationClass != null) {
            Type annotationType = Type.getType(annotationClass);
            List modFileScanDataList = ModList.get().getAllScanData();
            LinkedHashSet<String> pluginClassNames = new LinkedHashSet<String>();
            for (ModFileScanData scanData : modFileScanDataList) {
                Set annotations = scanData.getAnnotations();
                for (ModFileScanData.AnnotationData a : annotations) {
                    if (!Objects.equals(a.annotationType(), annotationType)) continue;
                    String memberName = a.memberName();
                    pluginClassNames.add(memberName);
                }
            }
            for (String className : pluginClassNames) {
                try {
                    Class<?> asmClass = Class.forName(className);
                    Class<T> asmInstanceClass = asmClass.asSubclass(clazz);
                    Constructor<T> constructor = asmInstanceClass.getDeclaredConstructor(new Class[0]);
                    T instance = constructor.newInstance(new Object[0]);
                    ret.add(instance);
                }
                catch (LinkageError | ReflectiveOperationException e) {
                    FiguraMod.LOGGER.error("Failed to load entrypoint: {}", (Object)className, (Object)e);
                }
            }
        }
        return ret;
    }

    static {
        nameToAnnotationClass.put("figura_api", FiguraAPIPlugin.class);
        nameToAnnotationClass.put("figura_permissions", FiguraPermissionsPlugin.class);
        nameToAnnotationClass.put("figura_screen", FiguraScreenPlugin.class);
        nameToAnnotationClass.put("figura_vanilla_part", FiguraVanillaPartPlugin.class);
        nameToAnnotationClass.put("figura_event", FiguraEventPlugin.class);
    }
}

