/*
 * Decompiled with CFR 0.152.
 */
package c0_0ry.ferdinandsflowers.block;

import c0_0ry.ferdinandsflowers.block.BambooBlack;
import c0_0ry.ferdinandsflowers.block.BambooGolden;
import c0_0ry.ferdinandsflowers.block.ModBlocks;
import c0_0ry.ferdinandsflowers.registry.tag.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBambooBlock
extends BambooStalkBlock {
    public AbstractBambooBlock(BlockBehaviour.Properties properties) {
        super(properties.m_280606_().m_60977_().m_60966_().m_60978_(1.0f).m_60918_(SoundType.f_56754_).m_60955_().m_60988_().m_222979_(BlockBehaviour.OffsetType.XZ).m_278183_().m_278166_(PushReaction.DESTROY).m_60924_((blockstate, blockgetter, blockpos) -> false));
    }

    private Block getBambooType() {
        if (this instanceof BambooBlack) {
            return (Block)ModBlocks.BAMBOO_BLACK.get();
        }
        if (this instanceof BambooGolden) {
            return (Block)ModBlocks.BAMBOO_GOLDEN.get();
        }
        return (Block)ModBlocks.BAMBOO_GROOVE.get();
    }

    private Block getBambooSapling() {
        if (this instanceof BambooBlack) {
            return (Block)ModBlocks.BAMBOO_SAPLING_BLACK.get();
        }
        if (this instanceof BambooGolden) {
            return (Block)ModBlocks.BAMBOO_SAPLING_GOLDEN.get();
        }
        return (Block)ModBlocks.BAMBOO_SAPLING_GROOVE.get();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        if (!fluidState.m_76178_()) {
            return null;
        }
        BlockState blockState = ctx.m_43725_().m_8055_(ctx.m_8083_().m_7495_());
        if (blockState.m_204336_(ModBlockTags.BAMBOO_PLANTABLE_ON)) {
            if (blockState.m_60713_(this.getBambooSapling())) {
                return (BlockState)this.m_49966_().m_61124_((Property)f_260603_, (Comparable)Integer.valueOf(0));
            }
            if (blockState.m_60713_(this.getBambooType())) {
                int i = (Integer)blockState.m_61143_((Property)f_260603_) > 0 ? 1 : 0;
                return (BlockState)this.m_49966_().m_61124_((Property)f_260603_, (Comparable)Integer.valueOf(i));
            }
            BlockState blockState2 = ctx.m_43725_().m_8055_(ctx.m_8083_().m_7494_());
            if (blockState2.m_60713_(this.getBambooType())) {
                return (BlockState)this.m_49966_().m_61124_((Property)f_260603_, (Comparable)((Integer)blockState2.m_61143_((Property)f_260603_)));
            }
            return this.getBambooSapling().m_49966_();
        }
        return null;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_204336_(ModBlockTags.BAMBOO_PLANTABLE_ON);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        if (direction == Direction.UP && neighborState.m_60713_(this.getBambooType()) && (Integer)neighborState.m_61143_((Property)f_260603_) > (Integer)state.m_61143_((Property)f_260603_)) {
            world.m_7731_(pos, (BlockState)state.m_61122_((Property)f_260603_), 2);
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void updateLeaves(BlockState state, Level level, BlockPos pos, RandomSource random, int height) {
        BlockState blockState = level.m_8055_(pos.m_7495_());
        BlockPos blockPos = pos.m_6625_(2);
        BlockState blockState2 = level.m_8055_(blockPos);
        BambooLeaves bambooLeaves = BambooLeaves.NONE;
        if (height >= 1) {
            if (!blockState.m_60713_(this.getBambooType()) || blockState.m_61143_((Property)f_260716_) == BambooLeaves.NONE) {
                bambooLeaves = BambooLeaves.SMALL;
            } else if (blockState.m_60713_(this.getBambooType()) && blockState.m_61143_((Property)f_260716_) != BambooLeaves.NONE) {
                bambooLeaves = BambooLeaves.LARGE;
                if (blockState2.m_60713_(this.getBambooType())) {
                    level.m_7731_(pos.m_7495_(), (BlockState)blockState.m_61124_((Property)f_260716_, (Comparable)BambooLeaves.SMALL), 3);
                    level.m_7731_(blockPos, (BlockState)blockState2.m_61124_((Property)f_260716_, (Comparable)BambooLeaves.NONE), 3);
                }
            }
        }
        int i = (Integer)state.m_61143_((Property)f_260603_) == 1 || blockState2.m_60713_(this.getBambooType()) ? 1 : 0;
        int j = height >= 11 && random.m_188501_() < 0.25f || height == 15 ? 1 : 0;
        level.m_7731_(pos.m_7494_(), (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_260603_, (Comparable)Integer.valueOf(i))).m_61124_((Property)f_260716_, (Comparable)bambooLeaves)).m_61124_((Property)f_260694_, (Comparable)Integer.valueOf(j)), 3);
    }

    protected int countBambooAbove(ServerLevel world, BlockPos pos) {
        int i;
        for (i = 0; i < 16 && world.m_8055_(pos.m_6630_(i + 1)).m_60713_(this.getBambooType()); ++i) {
        }
        return i;
    }

    protected int countBambooBelow(ServerLevel world, BlockPos pos) {
        int i;
        for (i = 0; i < 16 && world.m_8055_(pos.m_6625_(i + 1)).m_60713_(this.getBambooType()); ++i) {
        }
        return i;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int i = this.countBambooAbove(world, pos);
        int j = this.countBambooBelow(world, pos);
        int k = i + j + 1;
        int l = 1 + random.m_188503_(2);
        for (int m = 0; m < l; ++m) {
            BlockPos blockPos = pos.m_6630_(i);
            BlockState blockState = world.m_8055_(blockPos);
            if (k >= 16 || (Integer)blockState.m_61143_((Property)f_260694_) == 1 || !world.m_46859_(blockPos.m_7494_())) {
                return;
            }
            this.updateLeaves(blockState, (Level)world, blockPos, random, k);
            ++i;
            ++k;
        }
    }
}

