/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.block.furniture;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.WallLightBlock;
import xyz.apex.forge.fantasyfurniture.AllBlocks;
import xyz.apex.forge.fantasyfurniture.AllParticleTypes;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.IDyeable;
import xyz.apex.forge.fantasyfurniture.core.HitBoxes;

public class FurnitureWallLightBlock
extends WallLightBlock {
    public FurnitureWallLightBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void registerProperties(Consumer<Property<?>> consumer) {
        super.registerProperties(consumer);
        consumer.accept((Property<?>)FACING_4_WAY);
        consumer.accept((Property<?>)WATERLOGGED);
    }

    protected void spawnLightParticles(Level level, BlockPos pos, BlockState blockState, double pX, double pY, double pZ, RandomSource rng) {
        if (AllBlocks.NORDIC_WALL_LIGHT.isIn(blockState)) {
            super.spawnLightParticles(level, pos, blockState, pX, pY, pZ, rng);
        } else if (AllBlocks.VENTHYR_WALL_LIGHT.isIn(blockState)) {
            double x = pX;
            double y = pY + 0.35;
            double z = pZ;
            double xOffset = 0.0;
            double zOffset = 0.0;
            if (FurnitureWallLightBlock.supportsFacing((BlockState)blockState)) {
                Direction facing = FurnitureWallLightBlock.getFacing((BlockState)blockState).m_122424_();
                Direction face = facing.m_122427_();
                xOffset = 0.15 * (double)face.m_122429_();
                zOffset = 0.15 * (double)face.m_122431_();
                x += 0.25 * (double)facing.m_122429_();
                z += 0.25 * (double)facing.m_122431_();
            }
            this.onLightParticle(level, pos, blockState, x + xOffset, y, z + zOffset, rng);
            this.onLightParticle(level, pos, blockState, x - xOffset, y, z - zOffset, rng);
        } else if (AllBlocks.BONE_SKELETON_WALL_LIGHT.isIn(blockState) || AllBlocks.BONE_WITHER_WALL_LIGHT.isIn(blockState)) {
            super.spawnLightParticles(level, pos, blockState, pX, pY + 0.05, pZ, rng);
        } else if (AllBlocks.ROYAL_WALL_LIGHT.isIn(blockState)) {
            double x = pX;
            double y = pY + 0.25;
            double z = pZ;
            double xOffset = 0.0;
            double zOffset = 0.0;
            if (FurnitureWallLightBlock.supportsFacing((BlockState)blockState)) {
                Direction facing = FurnitureWallLightBlock.getFacing((BlockState)blockState).m_122424_();
                Direction face = facing.m_122427_();
                xOffset = 0.15 * (double)face.m_122429_();
                zOffset = 0.15 * (double)face.m_122431_();
                x += 0.3 * (double)facing.m_122429_();
                z += 0.3 * (double)facing.m_122431_();
            }
            this.onLightParticle(level, pos, blockState, x + xOffset, y, z + zOffset, rng);
            this.onLightParticle(level, pos, blockState, x - xOffset, y, z - zOffset, rng);
        } else if (AllBlocks.NECROLORD_WALL_LIGHT.isIn(blockState)) {
            super.spawnLightParticles(level, pos, blockState, pX, pY + 0.1, pZ, rng);
        }
    }

    protected void onLightParticle(Level level, BlockPos pos, BlockState blockState, double pX, double pY, double pZ, RandomSource rng) {
        SimpleParticleType flame = ParticleTypes.f_123744_;
        if (AllBlocks.BONE_WITHER_WALL_LIGHT.isIn(blockState)) {
            flame = ParticleTypes.f_123745_;
        } else if (AllBlocks.NECROLORD_WALL_LIGHT.isIn(blockState)) {
            flame = (SimpleParticleType)AllParticleTypes.NECROLORD_FLAME.get();
        }
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, pX, pY, pZ, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)flame, pX, pY, pZ, 0.0, 0.0, 0.0);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (AllBlocks.NORDIC_WALL_LIGHT.isIn(blockState)) {
            return HitBoxes.NORDIC.wallLight(this, blockState);
        }
        if (AllBlocks.DUNMER_WALL_LIGHT.isIn(blockState)) {
            return HitBoxes.DUNMER.wallLight(this, blockState);
        }
        if (AllBlocks.VENTHYR_WALL_LIGHT.isIn(blockState)) {
            return HitBoxes.VENTHYR.wallLight(this, blockState);
        }
        if (AllBlocks.BONE_SKELETON_WALL_LIGHT.isIn(blockState) || AllBlocks.BONE_WITHER_WALL_LIGHT.isIn(blockState)) {
            return HitBoxes.BONE.wallLight(this, blockState);
        }
        if (AllBlocks.ROYAL_WALL_LIGHT.isIn(blockState)) {
            return HitBoxes.ROYAL.wallLight(this, blockState);
        }
        if (AllBlocks.NECROLORD_WALL_LIGHT.isIn(blockState)) {
            return HitBoxes.NECROLORD.wallLight(this, blockState);
        }
        return super.m_5940_(blockState, level, pos, ctx);
    }

    public static class Dyeable
    extends FurnitureWallLightBlock
    implements IDyeable {
        public Dyeable(BlockBehaviour.Properties properties) {
            super(properties);
            this.m_49959_(IDyeable.registerDefaultBlockState(this.m_49966_()));
        }

        public MapColor getMapColor(BlockState blockState, BlockGetter level, BlockPos pos, MapColor defaultColor) {
            MapColor color = super.getMapColor(blockState, level, pos, defaultColor);
            return IDyeable.getDyedMapColor(blockState, level, pos, color);
        }

        @Override
        protected void registerProperties(Consumer<Property<?>> consumer) {
            super.registerProperties(consumer);
            IDyeable.registerProperties(consumer);
        }

        @Nullable
        protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
            placementBlockState = super.modifyPlacementState(placementBlockState, ctx);
            return IDyeable.getStateForPlacement(ctx, placementBlockState);
        }

        public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
            InteractionResult interactionResult = IDyeable.use(blockState, level, pos, player, hand);
            if (interactionResult.m_19077_()) {
                return interactionResult;
            }
            return super.m_6227_(blockState, level, pos, player, hand, result);
        }

        public ItemStack getCloneItemStack(BlockState blockState, HitResult target, BlockGetter level, BlockPos pos, Player player) {
            ItemStack stack = super.getCloneItemStack(blockState, target, level, pos, player);
            return IDyeable.getCloneItemStack(blockState, level, pos, stack);
        }

        public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
            super.m_5871_(stack, level, tooltip, flag);
            IDyeable.appendHoverText(this, tooltip);
        }
    }
}

