/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.block.entity;

import me.paulf.fairylights.server.block.LightBlock;
import me.paulf.fairylights.server.block.entity.FLBlockEntities;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.StandardLightBehavior;
import me.paulf.fairylights.server.item.LightVariant;
import me.paulf.fairylights.server.item.SimpleLightVariant;
import me.paulf.fairylights.server.sound.FLSounds;
import me.paulf.fairylights.util.matrix.MatrixStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class LightBlockEntity
extends BlockEntity {
    private Light<?> light = new Light<StandardLightBehavior>(0, Vec3.f_82478_, 0.0f, 0.0f, ItemStack.f_41583_, SimpleLightVariant.FAIRY_LIGHT, 0.0f);
    private boolean on = true;

    public LightBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.LIGHT.get(), pos, state);
    }

    public Light<?> getLight() {
        return this.light;
    }

    public void setItemStack(ItemStack stack) {
        this.light = new Light(0, Vec3.f_82478_, 0.0f, 0.0f, stack, (LightVariant)LightVariant.get((ICapabilityProvider)stack).orElse(SimpleLightVariant.FAIRY_LIGHT), 0.0f);
        this.m_6596_();
    }

    private void setOn(boolean on) {
        this.on = on;
        this.light.power(on, true);
        this.m_6596_();
    }

    public void interact(Level world, BlockPos pos, BlockState state, Player player, InteractionHand hand, BlockHitResult hit) {
        float pitch;
        SoundEvent lightSnd;
        this.setOn(!this.on);
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)LightBlock.LIT, (Comparable)Boolean.valueOf(this.on)));
        if (this.on) {
            lightSnd = (SoundEvent)FLSounds.FEATURE_LIGHT_TURNON.get();
            pitch = 0.6f;
        } else {
            lightSnd = (SoundEvent)FLSounds.FEATURE_LIGHT_TURNOFF.get();
            pitch = 0.5f;
        }
        this.f_58857_.m_5594_(null, pos, lightSnd, SoundSource.BLOCKS, 1.0f, pitch);
    }

    public void animateTick() {
        BlockState state = this.m_58900_();
        AttachFace face = (AttachFace)state.m_61143_((Property)LightBlock.f_53179_);
        float rotation = ((Direction)state.m_61143_((Property)LightBlock.f_54117_)).m_122435_();
        MatrixStack matrix = new MatrixStack();
        matrix.translate(0.5f, 0.5f, 0.5f);
        matrix.rotate((float)Math.toRadians(180.0f - rotation), 0.0f, 1.0f, 0.0f);
        if (this.light.getVariant().isOrientable()) {
            if (face == AttachFace.WALL) {
                matrix.rotate(1.5707964f, 1.0f, 0.0f, 0.0f);
            } else if (face == AttachFace.FLOOR) {
                matrix.rotate((float)(-Math.PI), 1.0f, 0.0f, 0.0f);
            }
            matrix.translate(0.0f, 0.5f, 0.0f);
        } else if (face == AttachFace.CEILING) {
            matrix.translate(0.0f, 0.25f, 0.0f);
        } else if (face == AttachFace.WALL) {
            matrix.translate(0.0f, 0.1875f, 0.125f);
        } else {
            matrix.translate(0.0f, -((float)this.light.getVariant().getBounds().f_82289_) - 0.5f, 0.0f);
        }
        this.light.getBehavior().animateTick(this.f_58857_, Vec3.m_82528_((Vec3i)this.f_58858_).m_82549_(matrix.transform(Vec3.f_82478_)), this.light);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("item", (Tag)this.light.getItem().m_41739_(new CompoundTag()));
        compound.m_128379_("on", this.on);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.setItemStack(ItemStack.m_41712_((CompoundTag)compound.m_128469_("item")));
        this.setOn(compound.m_128471_("on"));
    }
}

