/*
 * Decompiled with CFR 0.152.
 */
package net.punisintendeds.extrapanic.mixin;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.punisintendeds.extrapanic.Config;
import net.punisintendeds.extrapanic.Keybinds;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.UserData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AvatarManager.class})
public class FiguraMixin {
    @Shadow(remap=false)
    public static boolean panic;
    @Shadow(remap=false)
    @Final
    private static Map<UUID, UserData> LOADED_USERS;
    @Shadow(remap=false)
    @Final
    private static Map<Entity, Avatar> LOADED_CEM;
    @Unique
    private static Minecraft client;

    @Inject(at={@At(value="HEAD")}, method={"tickLoadedAvatars"}, cancellable=true, remap=false)
    private static void tickLoadedAvatars(CallbackInfo ci) {
        Player entity;
        if (panic) {
            return;
        }
        if (!Keybinds.panic) {
            return;
        }
        if (FiguraMixin.client.f_91074_ == null) {
            ci.cancel();
            return;
        }
        if (FiguraMixin.client.f_91073_ == null) {
            ci.cancel();
            return;
        }
        for (UserData user : LOADED_USERS.values()) {
            Avatar avatar = user.getMainAvatar();
            if (avatar == null || (entity = FiguraMixin.client.f_91073_.m_46003_(avatar.owner)) == null || entity.m_20270_((Entity)FiguraMixin.client.f_91074_) > (float)Config.distance) continue;
            FiguraMod.pushProfiler((Avatar)avatar);
            avatar.tick();
            FiguraMod.popProfiler();
        }
        if (LOADED_CEM.isEmpty()) {
            return;
        }
        HashSet<Entity> toBeRemoved = new HashSet<Entity>();
        for (Entity entity2 : LOADED_CEM.keySet()) {
            if (!entity2.m_213877_()) continue;
            toBeRemoved.add(entity2);
        }
        for (Entity entity2 : toBeRemoved) {
            LOADED_CEM.remove(entity2);
        }
        for (Avatar avatar : LOADED_CEM.values()) {
            if (avatar == null || (entity = FiguraMixin.client.f_91073_.m_46003_(avatar.owner)) == null || entity.m_20270_((Entity)FiguraMixin.client.f_91074_) > (float)Config.distance) continue;
            FiguraMod.pushProfiler((Avatar)avatar);
            avatar.tick();
            FiguraMod.popProfiler();
        }
        ci.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"executeAll"}, cancellable=true, remap=false)
    private static void executeAll(String src, Consumer<Avatar> consumer, CallbackInfo ci) {
        if (panic) {
            return;
        }
        if (!Keybinds.panic) {
            return;
        }
        if (FiguraMixin.client.f_91074_ == null) {
            ci.cancel();
            return;
        }
        if (FiguraMixin.client.f_91073_ == null) {
            ci.cancel();
            return;
        }
        FiguraMod.pushProfiler((String)"figura");
        FiguraMod.pushProfiler((String)src);
        for (UserData user : LOADED_USERS.values()) {
            Player entity;
            Avatar avatar = user.getMainAvatar();
            if (avatar == null || (entity = FiguraMixin.client.f_91073_.m_46003_(avatar.owner)) == null || entity.m_20270_((Entity)FiguraMixin.client.f_91074_) > (float)Config.distance) continue;
            FiguraMod.pushProfiler((Avatar)avatar);
            consumer.accept(avatar);
            FiguraMod.popProfiler();
        }
        for (Avatar avatar : LOADED_CEM.values()) {
            Player entity;
            if (avatar == null || (entity = FiguraMixin.client.f_91073_.m_46003_(avatar.owner)) == null || entity.m_20270_((Entity)FiguraMixin.client.f_91074_) > (float)Config.distance) continue;
            FiguraMod.pushProfiler((Avatar)avatar);
            consumer.accept(avatar);
            FiguraMod.popProfiler();
        }
        FiguraMod.popProfiler((int)2);
        ci.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"getAvatarForPlayer"}, cancellable=true, remap=false)
    private static void getAvatarForPlayer(UUID player, CallbackInfoReturnable<Avatar> cir) {
        if (!Keybinds.panic) {
            return;
        }
        if (FiguraMixin.client.f_91074_ == null) {
            cir.setReturnValue(null);
            return;
        }
        if (FiguraMixin.client.f_91073_ == null) {
            cir.setReturnValue(null);
            return;
        }
        if (FiguraMixin.client.f_91073_.m_46003_(player) == null) {
            cir.setReturnValue(null);
            return;
        }
        if (Objects.requireNonNull(FiguraMixin.client.f_91073_.m_46003_(player)).m_20270_((Entity)FiguraMixin.client.f_91074_) > (float)Config.distance) {
            cir.setReturnValue(null);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getAvatarForEntity"}, cancellable=true, remap=false)
    private static void getAvatarForEntity(Entity entity, CallbackInfoReturnable<Avatar> cir) {
        if (!Keybinds.panic) {
            return;
        }
        if (FiguraMixin.client.f_91074_ == null) {
            cir.setReturnValue(null);
            return;
        }
        if (entity == null) {
            cir.setReturnValue(null);
            return;
        }
        if (entity.m_20270_((Entity)FiguraMixin.client.f_91074_) > (float)Config.distance) {
            cir.setReturnValue(null);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getAvatar"}, cancellable=true, remap=false)
    private static void getAvatar(Entity entity, CallbackInfoReturnable<Avatar> cir) {
        if (!Keybinds.panic) {
            return;
        }
        if (FiguraMixin.client.f_91074_ == null) {
            cir.setReturnValue(null);
            return;
        }
        if (entity == null) {
            cir.setReturnValue(null);
            return;
        }
        if (entity.m_20270_((Entity)FiguraMixin.client.f_91074_) > (float)Config.distance) {
            cir.setReturnValue(null);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getLoadedAvatar"}, cancellable=true, remap=false)
    private static void getLoadedAvatar(UUID owner, CallbackInfoReturnable<Avatar> cir) {
        if (!Keybinds.panic) {
            return;
        }
        if (FiguraMixin.client.f_91074_ == null || FiguraMixin.client.f_91073_ == null) {
            cir.setReturnValue(null);
            return;
        }
        Player entity = FiguraMixin.client.f_91073_.m_46003_(owner);
        if (entity == null) {
            cir.setReturnValue(null);
            return;
        }
        if (entity.m_20270_((Entity)FiguraMixin.client.f_91074_) > (float)Config.distance) {
            cir.setReturnValue(null);
        }
    }

    static {
        client = Minecraft.m_91087_();
    }
}

