/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.gui.widgets;

import io.github.kosmx.emotes.arch.executor.types.TextImpl;
import io.github.kosmx.emotes.arch.gui.screen.IDrawableImpl;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.screen.widget.IEmoteListWidgetHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class AbstractEmoteListWidget<E extends AbstractEmoteEntry<E>>
extends ObjectSelectionList<E>
implements IEmoteListWidgetHelper<GuiGraphics, GuiEventListener>,
IDrawableImpl {
    protected List<E> emotes = new ArrayList();
    private final Screen screen;

    @Override
    public IEmoteListWidgetHelper.IEmoteEntry getSelectedEntry() {
        return (IEmoteListWidgetHelper.IEmoteEntry)this.m_93511_();
    }

    public AbstractEmoteListWidget(Minecraft minecraftClient, int i, int j, int k, int l, int m, Screen screen) {
        super(minecraftClient, i, j, k, l, m);
        this.f_93394_ = false;
        this.screen = screen;
    }

    public int m_5759_() {
        return this.f_93388_ - 5;
    }

    protected abstract E newEmoteEntry(Minecraft var1, EmoteHolder var2);

    @Override
    public void emotesSetLeftPos(int left) {
        this.m_93507_(left);
    }

    @Override
    public void setEmotes(Iterable<EmoteHolder> list, boolean showInvalid) {
        this.emotes = new ArrayList();
        for (EmoteHolder emoteHolder : list) {
            this.emotes.add(this.newEmoteEntry(Minecraft.m_91087_(), emoteHolder));
        }
        if (showInvalid) {
            for (EmoteHolder emoteHolder : this.getEmptyEmotes()) {
                this.emotes.add(this.newEmoteEntry(Minecraft.m_91087_(), emoteHolder));
            }
        }
        this.emotes.sort(Comparator.comparing(o -> o.emote.name.getString().toLowerCase()));
        this.filter(() -> "");
    }

    @Override
    public void filter(Supplier<String> string) {
        this.m_93516_();
        for (AbstractEmoteEntry emote : this.emotes) {
            if (!emote.emote.name.getString().toLowerCase().contains(string.get()) && !emote.emote.description.getString().toLowerCase().contains(string.get()) && !emote.emote.author.getString().toLowerCase().equals(string.get())) continue;
            this.m_7085_((AbstractSelectionList.Entry)emote);
        }
        this.m_93410_(0.0);
    }

    @Override
    public void renderThis(GuiGraphics matrices, int mouseX, int mouseY, float tickDelta) {
        this.m_88315_(matrices, mouseX, mouseY, tickDelta);
    }

    protected int m_5756_() {
        return this.f_93392_ - 6;
    }

    public boolean m_93696_() {
        return this.screen.m_7222_() == this;
    }

    @Override
    public AbstractEmoteListWidget<E> get() {
        return this;
    }

    public static abstract class AbstractEmoteEntry<T extends AbstractEmoteEntry<T>>
    extends ObjectSelectionList.Entry<T>
    implements IEmoteListWidgetHelper.IEmoteEntry<GuiGraphics>,
    IDrawableImpl {
        protected final Minecraft client;
        public final EmoteHolder emote;

        public AbstractEmoteEntry(Minecraft client, EmoteHolder emote) {
            this.client = client;
            this.emote = emote;
        }

        public void m_6311_(GuiGraphics matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.renderThis(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
        }

        @Override
        public EmoteHolder getEmote() {
            return this.emote;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.onPressed();
                return true;
            }
            return false;
        }

        public Component m_142172_() {
            return ((TextImpl)this.emote.name).get();
        }

        protected abstract void onPressed();
    }
}

