/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.platform;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import nl.enjarai.doabarrelroll.DoABarrelRollForge;
import nl.enjarai.doabarrelroll.ModPermissions;
import nl.enjarai.doabarrelroll.platform.services.PlatformHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForgePlatformHelper
implements PlatformHelper {
    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public Logger getLogger() {
        return LoggerFactory.getLogger((String)"do_a_barrel_roll");
    }

    @Override
    public boolean checkPermission(ServerGamePacketListenerImpl source, String permission, int defaultPermissionLevel) {
        return ModPermissions.resolve(source.m_142253_(), permission, defaultPermissionLevel);
    }

    @Override
    public void registerNetworkChannels(ResourceLocation ... channels) {
        for (ResourceLocation channel : channels) {
            SimpleChannel frogeChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)channel, () -> "", s -> true, s -> true);
            DoABarrelRollForge.NETWORK_CHANNELS.put(channel, frogeChannel);
            frogeChannel.registerMessage(0, FriendlyByteBuf.class, (bufSource, bufDest) -> bufDest.writeBytes((ByteBuf)bufSource), buf -> {
                buf.retain();
                return buf;
            }, (buf, contextSupplier) -> {
                NetworkEvent.Context ctx = (NetworkEvent.Context)contextSupplier.get();
                ctx.enqueueWork(() -> {
                    if (ctx.getDirection().getReceptionSide().isServer()) {
                        DoABarrelRollForge.SERVER_LISTENERS.get(channel).forEach(listener -> listener.accept(Objects.requireNonNull(ctx.getSender()).f_8906_, (FriendlyByteBuf)buf, replyBuf -> frogeChannel.sendTo(replyBuf, ctx.getSender().f_8906_.f_9742_, ctx.getDirection().reply())));
                    } else {
                        DoABarrelRollForge.CLIENT_LISTENERS.get(channel).forEach(listener -> listener.accept((FriendlyByteBuf)buf, arg_0 -> ((SimpleChannel)frogeChannel).sendToServer(arg_0)));
                    }
                });
                ctx.setPacketHandled(true);
            });
        }
    }

    @Override
    public void notMyProblem(Screen ConfigScreen, Runnable callback) {
    }

    @Override
    public boolean checkModLoaded(String modId) {
        return LoadingModList.get().getMods().stream().anyMatch(mod -> mod.getModId().equals(modId));
    }

    @Override
    public boolean isModVersionAtLeast(String modId, String version) {
        return true;
    }
}

