/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.time;

import fox.org.mc.backyardlib.config.ModConfiguration;
import java.time.LocalTime;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="backyardlib")
public class TimeSyncHandler {
    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
            if (!ModConfiguration.SPEC.isLoaded() || !((Boolean)ModConfiguration.ENABLE_TIME_SYNC.get()).booleanValue()) {
                return;
            }
            Level level = event.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                LocalTime now = LocalTime.now();
                double currentRealTime = (double)now.getHour() + (double)now.getMinute() / 60.0;
                double rStart = (Double)ModConfiguration.REAL_START.get();
                double rEnd = (Double)ModConfiguration.REAL_END.get();
                double warmUpStart = rStart - 0.5;
                ((GameRules.BooleanValue)serverLevel.m_46469_().m_46170_(GameRules.f_46140_)).m_46246_(false, serverLevel.m_7654_());
                if (currentRealTime >= warmUpStart && currentRealTime < rStart) {
                    double progress = (currentRealTime - warmUpStart) / 0.5;
                    long targetTime = (long)(23000.0 + progress * 1000.0);
                    if (targetTime >= 24000L) {
                        targetTime -= 24000L;
                    }
                    serverLevel.m_8615_(targetTime);
                } else if (currentRealTime >= rStart && currentRealTime <= rEnd) {
                    double progress = (currentRealTime - rStart) / (rEnd - rStart);
                    long targetTime = (long)(progress * 14000.0);
                    serverLevel.m_8615_(targetTime);
                }
            }
        }
    }
}

