/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.thirst;

import fox.org.mc.backyardlib.config.ModConfiguration;
import fox.org.mc.backyardlib.network.BackyardNetwork;
import fox.org.mc.backyardlib.network.player.ThirstSyncPacket;
import fox.org.mc.backyardlib.thirst.ThirstCapabilityProvider;
import fox.org.mc.backyardlib.thirst.ThirstData;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="backyardlib")
public class ThirstEventHandler {
    private static final Random random = new Random();

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(ThirstCapabilityProvider.PLAYER_THIRST).isPresent()) {
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"player_thirst"), (ICapabilityProvider)new ThirstCapabilityProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        event.getOriginal().getCapability(ThirstCapabilityProvider.PLAYER_THIRST).ifPresent(oldStore -> event.getEntity().getCapability(ThirstCapabilityProvider.PLAYER_THIRST).ifPresent(newStore -> newStore.copyFrom((ThirstData)oldStore)));
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().f_46443_) {
            if (!((Boolean)ModConfiguration.ENABLE_THIRST.get()).booleanValue()) {
                return;
            }
            ServerPlayer player = (ServerPlayer)event.player;
            if (player.m_7500_() || player.m_5833_()) {
                return;
            }
            player.getCapability(ThirstCapabilityProvider.PLAYER_THIRST).ifPresent(thirst -> {
                boolean isJumping;
                if (thirst.getThirst() <= 0.0f) {
                    return;
                }
                float chance = 0.0f;
                boolean isMoving = player.m_20184_().m_165925_() > 1.0E-4;
                boolean bl = isJumping = !player.m_20096_() && !player.m_6069_() && !player.m_20159_();
                chance = isMoving ? (player.m_20142_() ? 0.015f : 0.002f) : 5.0E-4f;
                if (isJumping) {
                    chance += 0.01f;
                }
                if (player.m_9236_().m_6042_().f_63857_() || player.m_20077_()) {
                    chance *= 2.0f;
                }
                if (random.nextFloat() < chance) {
                    thirst.subtractThirst(1.0f);
                    BackyardNetwork.sendToPlayer(new ThirstSyncPacket(thirst.getThirst()), player);
                }
                if (player.f_19797_ % 40 == 0) {
                    BackyardNetwork.sendToPlayer(new ThirstSyncPacket(thirst.getThirst()), player);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        if (!((Boolean)ModConfiguration.ENABLE_THIRST.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCapability(ThirstCapabilityProvider.PLAYER_THIRST).ifPresent(thirst -> {
                if (thirst.getThirst() <= 0.0f && event.getAmount() <= 1.0f) {
                    event.setCanceled(true);
                }
            });
        }
    }
}

