/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.thirst;

import fox.org.mc.backyardlib.config.ModConfiguration;
import net.minecraft.nbt.CompoundTag;

public class ThirstData {
    private float thirst = ((Integer)ModConfiguration.MAX_THIRST.get()).intValue();
    private float hydration = 5.0f;

    public float getThirst() {
        return this.thirst;
    }

    public void setThirst(float thirst) {
        this.thirst = Math.max(0.0f, Math.min(thirst, (float)((Integer)ModConfiguration.MAX_THIRST.get()).intValue()));
    }

    public void addThirst(float amount) {
        this.setThirst(this.thirst + amount);
    }

    public void subtractThirst(float amount) {
        if (this.hydration > 0.0f) {
            float reduce = Math.min(this.hydration, amount);
            this.hydration -= reduce;
            amount -= reduce;
        }
        if (amount > 0.0f) {
            this.setThirst(this.thirst - amount);
        }
    }

    public void drink(float amount, float hydrationAmount) {
        this.addThirst(amount);
        this.hydration = Math.min(20.0f, this.hydration + hydrationAmount);
    }

    public void copyFrom(ThirstData source) {
        this.thirst = source.thirst;
        this.hydration = source.hydration;
    }

    public void saveNBT(CompoundTag nbt) {
        nbt.m_128350_("Thirst", this.thirst);
        nbt.m_128350_("Hydration", this.hydration);
    }

    public void loadNBT(CompoundTag nbt) {
        if (nbt.m_128441_("Thirst")) {
            this.thirst = nbt.m_128457_("Thirst");
        }
        if (nbt.m_128441_("Hydration")) {
            this.hydration = nbt.m_128457_("Hydration");
        }
    }
}

