/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.server;

import fox.org.mc.backyardlib.config.ModConfiguration;
import fox.org.mc.backyardlib.item.ModItems;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="backyardlib")
public class InventoryLockHandler {
    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!((Boolean)ModConfiguration.LOCK_INVENTORY.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (!player.m_9236_().f_46443_ && !player.m_7500_()) {
            InventoryLockHandler.enforceLock(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        boolean bypass;
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        Player player = event.player;
        boolean isLockEnabled = (Boolean)ModConfiguration.LOCK_INVENTORY.get();
        boolean bl = bypass = player.m_7500_() || player.m_5833_();
        if (isLockEnabled && !bypass) {
            InventoryLockHandler.enforceLock(player);
        } else {
            InventoryLockHandler.clearLocks(player);
        }
    }

    private static void enforceLock(Player player) {
        if (ModItems.SLOT_LOCK == null || !ModItems.SLOT_LOCK.isPresent()) {
            return;
        }
        ItemStack lockItem = new ItemStack((ItemLike)ModItems.SLOT_LOCK.get());
        boolean changed = false;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack current = player.m_150109_().m_8020_(i);
            if (i >= 9 && i <= 35) {
                if (current.m_41720_() == ModItems.SLOT_LOCK.get()) continue;
                if (!current.m_41619_()) {
                    player.m_36176_(current.m_41777_(), true);
                }
                player.m_150109_().m_6836_(i, lockItem.m_41777_());
                changed = true;
                continue;
            }
            if (current.m_41720_() != ModItems.SLOT_LOCK.get()) continue;
            player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            changed = true;
        }
        ItemStack carried = player.f_36096_.m_142621_();
        if (!carried.m_41619_() && carried.m_41720_() == ModItems.SLOT_LOCK.get()) {
            player.f_36096_.m_142503_(ItemStack.f_41583_);
            changed = true;
        }
        if (changed) {
            player.m_150109_().m_6596_();
            player.f_36096_.m_38946_();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_36095_.m_150429_();
            }
        }
    }

    private static void clearLocks(Player player) {
        boolean changed = false;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            if (player.m_150109_().m_8020_(i).m_41720_() != ModItems.SLOT_LOCK.get()) continue;
            player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            changed = true;
        }
        if (player.f_36096_.m_142621_().m_41720_() == ModItems.SLOT_LOCK.get()) {
            player.f_36096_.m_142503_(ItemStack.f_41583_);
            changed = true;
        }
        if (changed) {
            player.m_150109_().m_6596_();
            player.f_36096_.m_38946_();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_36095_.m_150429_();
            }
        }
    }

    @SubscribeEvent
    public static void onTossItem(ItemTossEvent event) {
        if (event.getEntity().m_32055_().m_41720_() == ModItems.SLOT_LOCK.get()) {
            event.setCanceled(true);
            event.getEntity().m_146870_();
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (event.getEntity() instanceof Player) {
            event.getDrops().removeIf(item -> item.m_32055_().m_41720_() == ModItems.SLOT_LOCK.get());
        }
    }

    @Mod.EventBusSubscriber(modid="backyardlib", value={Dist.CLIENT})
    public static class ClientHandler {
        @SubscribeEvent
        public static void onRenderTooltip(RenderTooltipEvent.Pre event) {
            if (event.getItemStack().m_41720_() == ModItems.SLOT_LOCK.get()) {
                event.setCanceled(true);
            }
        }
    }
}

