/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.school;

import fox.org.mc.backyardlib.school.ScheduleData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class ScheduleManager
extends SavedData {
    private static final String DATA_NAME = "backyard_schedules";
    private final Map<String, ScheduleData> schedules = new HashMap<String, ScheduleData>();

    public static ScheduleManager get(Level level) {
        if (level.f_46443_) {
            throw new RuntimeException("Client side cannot access ScheduleManager");
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return (ScheduleManager)serverLevel.m_7654_().m_129783_().m_8895_().m_164861_(ScheduleManager::load, ScheduleManager::new, DATA_NAME);
    }

    public ScheduleData getSchedule(String roomId) {
        return this.schedules.computeIfAbsent(roomId, k -> new ScheduleData());
    }

    public void updateSchedule(String roomId, ScheduleData newData) {
        this.schedules.put(roomId, newData);
        this.m_77762_();
    }

    public void deleteSchedule(String roomId) {
        if (this.schedules.containsKey(roomId)) {
            this.schedules.remove(roomId);
            this.m_77762_();
        }
    }

    public Set<String> getAllRoomIds() {
        return this.schedules.keySet();
    }

    public static ScheduleManager load(CompoundTag nbt) {
        ScheduleManager data = new ScheduleManager();
        if (nbt.m_128441_("Schedules")) {
            CompoundTag schedulesTag = nbt.m_128469_("Schedules");
            for (String roomId : schedulesTag.m_128431_()) {
                ScheduleData schedule = new ScheduleData();
                schedule.load(schedulesTag.m_128469_(roomId));
                data.schedules.put(roomId, schedule);
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        CompoundTag schedulesTag = new CompoundTag();
        for (Map.Entry<String, ScheduleData> entry : this.schedules.entrySet()) {
            CompoundTag roomTag = new CompoundTag();
            entry.getValue().save(roomTag);
            schedulesTag.m_128365_(entry.getKey(), (Tag)roomTag);
        }
        nbt.m_128365_("Schedules", (Tag)schedulesTag);
        return nbt;
    }
}

