/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.school;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class ScheduleData {
    private final List<Entry[]> days = new ArrayList<Entry[]>();
    public int activeDayIndex = 0;

    public ScheduleData() {
        this.addNewDay();
    }

    public void addNewDay() {
        Entry[] newDay = new Entry[9];
        for (int i = 0; i < 9; ++i) {
            newDay[i] = new Entry();
        }
        this.days.add(newDay);
    }

    public int getTotalDays() {
        return this.days.size();
    }

    public Entry getEntry(int dayIndex, int period) {
        if (dayIndex < 0 || dayIndex >= this.days.size()) {
            return new Entry();
        }
        return this.days.get(dayIndex)[period];
    }

    public void setEntry(int dayIndex, int period, String time, String subj, String teacher, String ign, String note) {
        if (dayIndex >= 0 && dayIndex < this.days.size()) {
            Entry e = new Entry();
            e.time = time;
            e.subject = subj;
            e.teacher = teacher;
            e.teacherIgn = ign;
            e.note = note;
            this.days.get((int)dayIndex)[period] = e;
        }
    }

    public CompoundTag save(CompoundTag tag) {
        tag.m_128405_("ActiveDay", this.activeDayIndex);
        ListTag dayListTag = new ListTag();
        for (Entry[] day : this.days) {
            ListTag periods = new ListTag();
            for (int p = 0; p < 9; ++p) {
                periods.add((Object)day[p].toNbt());
            }
            dayListTag.add((Object)periods);
        }
        tag.m_128365_("ScheduleTable", (Tag)dayListTag);
        return tag;
    }

    public void load(CompoundTag tag) {
        if (tag.m_128441_("ActiveDay")) {
            this.activeDayIndex = tag.m_128451_("ActiveDay");
        }
        if (tag.m_128441_("ScheduleTable")) {
            this.days.clear();
            ListTag dayListTag = tag.m_128437_("ScheduleTable", 9);
            for (int d = 0; d < dayListTag.size(); ++d) {
                ListTag periods = dayListTag.m_128744_(d);
                Entry[] dayEntries = new Entry[9];
                for (int p = 0; p < 9 && p < periods.size(); ++p) {
                    dayEntries[p] = Entry.fromNbt(periods.m_128728_(p));
                }
                this.days.add(dayEntries);
            }
        }
        if (this.days.isEmpty()) {
            this.addNewDay();
        }
    }

    public static class Entry {
        public String time = "08:00";
        public String subject = "";
        public String teacher = "";
        public String teacherIgn = "";
        public String note = "";

        public Entry() {
        }

        public Entry(String t, String s, String tc, String ign, String n) {
            this.time = t;
            this.subject = s;
            this.teacher = tc;
            this.teacherIgn = ign;
            this.note = n;
        }

        public CompoundTag toNbt() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("t", this.time);
            tag.m_128359_("s", this.subject);
            tag.m_128359_("c", this.teacher);
            tag.m_128359_("ign", this.teacherIgn);
            tag.m_128359_("n", this.note);
            return tag;
        }

        public static Entry fromNbt(CompoundTag tag) {
            Entry e = new Entry();
            e.time = tag.m_128461_("t");
            e.subject = tag.m_128461_("s");
            e.teacher = tag.m_128461_("c");
            e.teacherIgn = tag.m_128461_("ign");
            e.note = tag.m_128461_("n");
            return e;
        }
    }
}

