/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.network.school;

import fox.org.mc.backyardlib.item.ModItems;
import fox.org.mc.backyardlib.network.BackyardNetwork;
import fox.org.mc.backyardlib.school.ScheduleData;
import fox.org.mc.backyardlib.school.ScheduleManager;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class PacketSaveSchedule {
    private final String roomId;
    private final ScheduleData scheduleData;

    public PacketSaveSchedule(String roomId, ScheduleData data) {
        this.roomId = roomId;
        this.scheduleData = data;
    }

    public static void encode(PacketSaveSchedule msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.roomId);
        CompoundTag nbt = new CompoundTag();
        msg.scheduleData.save(nbt);
        buf.m_130079_(nbt);
    }

    public static PacketSaveSchedule decode(FriendlyByteBuf buf) {
        String roomId = buf.m_130277_();
        CompoundTag nbt = buf.m_130260_();
        ScheduleData data = new ScheduleData();
        if (nbt != null) {
            data.load(nbt);
        }
        return new PacketSaveSchedule(roomId, data);
    }

    public static void handle(PacketSaveSchedule msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && player.m_20310_(2)) {
                ScheduleManager manager = ScheduleManager.get(player.m_9236_());
                manager.updateSchedule(msg.roomId, msg.scheduleData);
                ItemStack paper = new ItemStack((ItemLike)ModItems.STUDENT_SCHEDULE_PAPER.get());
                paper.m_41784_().m_128359_("RoomID", msg.roomId);
                paper.m_41714_((Component)Component.m_237113_((String)("\u00a7e\u0e15\u0e32\u0e23\u0e32\u0e07\u0e40\u0e23\u0e35\u0e22\u0e19\u0e2b\u0e49\u0e2d\u0e07: \u00a7f" + msg.roomId)));
                if (!player.m_150109_().m_36054_(paper)) {
                    player.m_36176_(paper, false);
                }
                player.m_213846_((Component)Component.m_237113_((String)("\u0e1a\u0e31\u0e19\u0e17\u0e36\u0e01\u0e15\u0e32\u0e23\u0e32\u0e07\u0e40\u0e23\u0e35\u0e22\u0e19\u0e2b\u0e49\u0e2d\u0e07 " + msg.roomId + " \u0e2a\u0e33\u0e40\u0e23\u0e47\u0e08")).m_130940_(ChatFormatting.GREEN));
                BackyardNetwork.sendToast(player, "\u0e1a\u0e31\u0e19\u0e17\u0e36\u0e01\u0e2a\u0e33\u0e40\u0e23\u0e47\u0e08", "\u0e23\u0e31\u0e1a\u0e44\u0e2d\u0e40\u0e17\u0e47\u0e21\u0e15\u0e32\u0e23\u0e32\u0e07\u0e40\u0e23\u0e35\u0e22\u0e19\u0e41\u0e25\u0e49\u0e27");
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

