/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.network.school;

import fox.org.mc.backyardlib.school.ScheduleData;
import fox.org.mc.backyardlib.teams.SafePacketHandler;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketOpenSchedule {
    private final String roomId;
    private final boolean isAdmin;
    private final ScheduleData data;

    public PacketOpenSchedule(String roomId, boolean isAdmin, ScheduleData data) {
        this.roomId = roomId;
        this.isAdmin = isAdmin;
        this.data = data;
    }

    public static void encode(PacketOpenSchedule msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.roomId);
        buf.writeBoolean(msg.isAdmin);
        CompoundTag nbt = new CompoundTag();
        msg.data.save(nbt);
        buf.m_130079_(nbt);
    }

    public static PacketOpenSchedule decode(FriendlyByteBuf buf) {
        String r = buf.m_130277_();
        boolean a = buf.readBoolean();
        CompoundTag nbt = buf.m_130260_();
        ScheduleData d = new ScheduleData();
        if (nbt != null) {
            d.load(nbt);
        }
        return new PacketOpenSchedule(r, a, d);
    }

    public static void handle(PacketOpenSchedule msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SafePacketHandler.openSchedule(msg.roomId, msg.isAdmin, msg.data)));
        ctx.get().setPacketHandled(true);
    }
}

