/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.network.school;

import fox.org.mc.backyardlib.teams.SafePacketHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketOpenRoomList {
    private final List<String> rooms;

    public PacketOpenRoomList(List<String> rooms) {
        this.rooms = rooms;
    }

    public static void encode(PacketOpenRoomList msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.rooms.size());
        for (String s : msg.rooms) {
            buf.m_130070_(s);
        }
    }

    public static PacketOpenRoomList decode(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            list.add(buf.m_130277_());
        }
        return new PacketOpenRoomList(list);
    }

    public static void handle(PacketOpenRoomList msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SafePacketHandler.handleRoomListUpdate(msg.rooms)));
        ctx.get().setPacketHandled(true);
    }
}

