/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.network.school;

import fox.org.mc.backyardlib.network.BackyardNetwork;
import fox.org.mc.backyardlib.network.school.PacketOpenRoomList;
import fox.org.mc.backyardlib.school.ScheduleManager;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class PacketDeleteRoom {
    private final String roomId;

    public PacketDeleteRoom(String roomId) {
        this.roomId = roomId;
    }

    public PacketDeleteRoom(FriendlyByteBuf buf) {
        this.roomId = buf.m_130277_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.roomId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player != null && player.m_20310_(2)) {
                ScheduleManager manager = ScheduleManager.get(player.m_9236_());
                manager.deleteSchedule(this.roomId);
                ArrayList<String> updatedRooms = new ArrayList<String>(manager.getAllRoomIds());
                BackyardNetwork.sendToPlayer(new PacketOpenRoomList(updatedRooms), player);
                BackyardNetwork.sendToast(player, "\u0e23\u0e30\u0e1a\u0e1a", "\u0e25\u0e1a\u0e2b\u0e49\u0e2d\u0e07 " + this.roomId + " \u0e2a\u0e33\u0e40\u0e23\u0e47\u0e08");
            }
        });
        return true;
    }
}

