/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.network.player;

import fox.org.mc.backyardlib.thirst.ClientThirstData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ThirstSyncPacket {
    private final float thirst;

    public ThirstSyncPacket(float thirst) {
        this.thirst = thirst;
    }

    public ThirstSyncPacket(FriendlyByteBuf buf) {
        this.thirst = buf.readFloat();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.thirst);
    }

    public static void handle(ThirstSyncPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientThirstData.set(msg.thirst)));
        ctx.get().setPacketHandled(true);
    }
}

