/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.network.player;

import fox.org.mc.backyardlib.config.ModConfiguration;
import fox.org.mc.backyardlib.item.ModItems;
import fox.org.mc.backyardlib.network.BackyardNetwork;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PlayerPacket {
    private final double playerScale;

    public PlayerPacket(double playerScale) {
        this.playerScale = playerScale;
    }

    public PlayerPacket(FriendlyByteBuf buf) {
        this.playerScale = buf.readDouble();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeDouble(this.playerScale);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                boolean isScaleChanged;
                double currentScaleConfig = (Double)ModConfiguration.PLAYER_SCALE.get();
                boolean bl = isScaleChanged = Math.abs(this.playerScale - currentScaleConfig) > 0.001;
                if (isScaleChanged) {
                    boolean isOp = player.m_20310_(2);
                    boolean hasConsumedItem = false;
                    if (isOp) {
                        hasConsumedItem = true;
                    } else {
                        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                            ItemStack stack = player.m_150109_().m_8020_(i);
                            if (stack.m_41720_() != ModItems.HEIGHT_CHANGER.get()) continue;
                            stack.m_41774_(1);
                            hasConsumedItem = true;
                            break;
                        }
                    }
                    if (hasConsumedItem) {
                        ModConfiguration.PLAYER_SCALE.set((Object)this.playerScale);
                        ModConfiguration.SPEC.save();
                        BackyardNetwork.sendToast(player, "\u0e2a\u0e33\u0e40\u0e23\u0e47\u0e08", "\u0e40\u0e1b\u0e25\u0e35\u0e48\u0e22\u0e19\u0e2a\u0e48\u0e27\u0e19\u0e2a\u0e39\u0e07\u0e40\u0e1b\u0e47\u0e19 " + String.format("%.2f", this.playerScale));
                        BackyardNetwork.sendToAll(this);
                    } else {
                        BackyardNetwork.sendToast(player, "\u0e1c\u0e34\u0e14\u0e1e\u0e25\u0e32\u0e14", "\u0e04\u0e38\u0e13\u0e44\u0e21\u0e48\u0e21\u0e35\u0e1a\u0e31\u0e15\u0e23\u0e40\u0e1b\u0e25\u0e35\u0e48\u0e22\u0e19\u0e2a\u0e48\u0e27\u0e19\u0e2a\u0e39\u0e07!");
                        player.m_5661_((Component)Component.m_237113_((String)"\u00a7c[!] \u0e15\u0e49\u0e2d\u0e07\u0e01\u0e32\u0e23\u0e44\u0e2d\u0e40\u0e17\u0e21\u0e1a\u0e31\u0e15\u0e23\u0e40\u0e1b\u0e25\u0e35\u0e48\u0e22\u0e19\u0e2a\u0e48\u0e27\u0e19\u0e2a\u0e39\u0e07\u0e40\u0e1e\u0e37\u0e48\u0e2d\u0e14\u0e33\u0e40\u0e19\u0e34\u0e19\u0e01\u0e32\u0e23"), false);
                        BackyardNetwork.sendToPlayer(new PlayerPacket(currentScaleConfig), player);
                    }
                }
            } else {
                ModConfiguration.PLAYER_SCALE.set((Object)this.playerScale);
            }
        });
        context.setPacketHandled(true);
        return true;
    }
}

