/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.network.admin;

import fox.org.mc.backyardlib.config.ModConfiguration;
import fox.org.mc.backyardlib.network.BackyardNetwork;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class AdminPacket {
    private final boolean adminMode;
    private final boolean lockInventory;
    private final boolean enableTime;
    private final double realStart;
    private final double realEnd;
    private final boolean isWhitelistMode;
    private final List<String> spawnList;
    private final List<String> bannedItems;
    private final boolean enableThirst;

    public AdminPacket(boolean adminMode, boolean lockInventory, boolean enableTime, double rS, double rE, boolean isWhitelist, List<String> spawnList, List<String> bannedItems, boolean enableThirst) {
        this.adminMode = adminMode;
        this.lockInventory = lockInventory;
        this.enableTime = enableTime;
        this.realStart = rS;
        this.realEnd = rE;
        this.isWhitelistMode = isWhitelist;
        this.spawnList = spawnList;
        this.bannedItems = bannedItems;
        this.enableThirst = enableThirst;
    }

    public AdminPacket(FriendlyByteBuf buf) {
        this.adminMode = buf.readBoolean();
        this.lockInventory = buf.readBoolean();
        this.enableTime = buf.readBoolean();
        this.realStart = buf.readDouble();
        this.realEnd = buf.readDouble();
        this.isWhitelistMode = buf.readBoolean();
        this.spawnList = (List)buf.m_236838_(ArrayList::new, FriendlyByteBuf::m_130277_);
        this.bannedItems = (List)buf.m_236838_(ArrayList::new, FriendlyByteBuf::m_130277_);
        this.enableThirst = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.adminMode);
        buf.writeBoolean(this.lockInventory);
        buf.writeBoolean(this.enableTime);
        buf.writeDouble(this.realStart);
        buf.writeDouble(this.realEnd);
        buf.writeBoolean(this.isWhitelistMode);
        buf.m_236828_(this.spawnList, FriendlyByteBuf::m_130070_);
        buf.m_236828_(this.bannedItems, FriendlyByteBuf::m_130070_);
        buf.writeBoolean(this.enableThirst);
    }

    public static void handle(AdminPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                if (player.m_20310_(2)) {
                    ModConfiguration.ADMIN_MODE.set((Object)msg.adminMode);
                    ModConfiguration.LOCK_INVENTORY.set((Object)msg.lockInventory);
                    ModConfiguration.ENABLE_TIME_SYNC.set((Object)msg.enableTime);
                    ModConfiguration.REAL_START.set((Object)msg.realStart);
                    ModConfiguration.REAL_END.set((Object)msg.realEnd);
                    ModConfiguration.IS_WHITELIST_MODE.set((Object)msg.isWhitelistMode);
                    ModConfiguration.SPAWN_LIST.set(new ArrayList<String>(msg.spawnList));
                    ModConfiguration.BANNED_ITEMS.set(new ArrayList<String>(msg.bannedItems));
                    ModConfiguration.ENABLE_THIRST.set((Object)msg.enableThirst);
                    ModConfiguration.SPEC.save();
                    if (msg.adminMode) {
                        player.m_6842_(true);
                        player.m_20340_(false);
                    } else {
                        player.m_6842_(false);
                        player.m_20340_(true);
                    }
                    BackyardNetwork.sendToAll(msg);
                }
            } else {
                ModConfiguration.ADMIN_MODE.set((Object)msg.adminMode);
                ModConfiguration.LOCK_INVENTORY.set((Object)msg.lockInventory);
                ModConfiguration.ENABLE_TIME_SYNC.set((Object)msg.enableTime);
                ModConfiguration.REAL_START.set((Object)msg.realStart);
                ModConfiguration.REAL_END.set((Object)msg.realEnd);
                ModConfiguration.IS_WHITELIST_MODE.set((Object)msg.isWhitelistMode);
                ModConfiguration.SPAWN_LIST.set(new ArrayList<String>(msg.spawnList));
                ModConfiguration.BANNED_ITEMS.set(new ArrayList<String>(msg.bannedItems));
                ModConfiguration.ENABLE_THIRST.set((Object)msg.enableThirst);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

