/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.network;

import fox.org.mc.backyardlib.network.admin.AdminOpenInvPacket;
import fox.org.mc.backyardlib.network.admin.AdminPacket;
import fox.org.mc.backyardlib.network.admin.GlobalSpawnPacket;
import fox.org.mc.backyardlib.network.player.PlayerPacket;
import fox.org.mc.backyardlib.network.player.ScalePacket;
import fox.org.mc.backyardlib.network.player.ThirstSyncPacket;
import fox.org.mc.backyardlib.network.player.ToastPacket;
import fox.org.mc.backyardlib.network.school.PacketCreateRoom;
import fox.org.mc.backyardlib.network.school.PacketDeleteRoom;
import fox.org.mc.backyardlib.network.school.PacketGiveScheduleItem;
import fox.org.mc.backyardlib.network.school.PacketOpenRoomList;
import fox.org.mc.backyardlib.network.school.PacketOpenSchedule;
import fox.org.mc.backyardlib.network.school.PacketOpenScheduleEdit;
import fox.org.mc.backyardlib.network.school.PacketRequestRoomList;
import fox.org.mc.backyardlib.network.school.PacketRequestScheduleData;
import fox.org.mc.backyardlib.network.school.PacketSaveSchedule;
import fox.org.mc.backyardlib.teams.SafePacketHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class BackyardNetwork {
    private static final String PROTOCOL_VERSION = "1";
    public static SimpleChannel CHANNEL;
    private static int packetId;

    public static void register() {
        CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"main_channel"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        CHANNEL.registerMessage(packetId++, PacketRequestRoomList.class, PacketRequestRoomList::encode, PacketRequestRoomList::decode, PacketRequestRoomList::handle);
        CHANNEL.registerMessage(packetId++, PacketOpenRoomList.class, PacketOpenRoomList::encode, PacketOpenRoomList::decode, PacketOpenRoomList::handle);
        CHANNEL.registerMessage(packetId++, PacketCreateRoom.class, PacketCreateRoom::encode, PacketCreateRoom::decode, PacketCreateRoom::handle);
        CHANNEL.registerMessage(packetId++, PacketDeleteRoom.class, PacketDeleteRoom::toBytes, PacketDeleteRoom::new, PacketDeleteRoom::handle);
        CHANNEL.registerMessage(packetId++, PacketGiveScheduleItem.class, PacketGiveScheduleItem::toBytes, PacketGiveScheduleItem::new, PacketGiveScheduleItem::handle);
        CHANNEL.registerMessage(packetId++, PacketRequestScheduleData.class, PacketRequestScheduleData::encode, PacketRequestScheduleData::decode, PacketRequestScheduleData::handle);
        CHANNEL.registerMessage(packetId++, PacketOpenScheduleEdit.class, PacketOpenScheduleEdit::encode, PacketOpenScheduleEdit::decode, PacketOpenScheduleEdit::handle);
        CHANNEL.registerMessage(packetId++, PacketSaveSchedule.class, PacketSaveSchedule::encode, PacketSaveSchedule::decode, PacketSaveSchedule::handle);
        CHANNEL.registerMessage(packetId++, PacketOpenSchedule.class, PacketOpenSchedule::encode, PacketOpenSchedule::decode, PacketOpenSchedule::handle);
        CHANNEL.registerMessage(packetId++, ToastPacket.class, ToastPacket::encode, ToastPacket::decode, ToastPacket::handle);
        CHANNEL.registerMessage(packetId++, ScalePacket.class, ScalePacket::encode, ScalePacket::decode, ScalePacket::handle);
        CHANNEL.registerMessage(packetId++, PlayerPacket.class, PlayerPacket::toBytes, PlayerPacket::new, PlayerPacket::handle);
        CHANNEL.registerMessage(packetId++, AdminPacket.class, AdminPacket::toBytes, AdminPacket::new, AdminPacket::handle);
        CHANNEL.registerMessage(packetId++, AdminOpenInvPacket.class, AdminOpenInvPacket::toBytes, AdminOpenInvPacket::new, AdminOpenInvPacket::handle);
        CHANNEL.registerMessage(packetId++, ThirstSyncPacket.class, ThirstSyncPacket::toBytes, ThirstSyncPacket::new, ThirstSyncPacket::handle);
        CHANNEL.registerMessage(packetId++, GlobalSpawnPacket.class, GlobalSpawnPacket::toBytes, GlobalSpawnPacket::new, GlobalSpawnPacket::handle);
        CHANNEL.registerMessage(packetId++, RequestWhitelistPacket.class, RequestWhitelistPacket::encode, RequestWhitelistPacket::decode, RequestWhitelistPacket::handle);
        CHANNEL.registerMessage(packetId++, SyncWhitelistPacket.class, SyncWhitelistPacket::encode, SyncWhitelistPacket::decode, SyncWhitelistPacket::handle);
    }

    public static void sendToAll(Object msg) {
        CHANNEL.send(PacketDistributor.ALL.noArg(), msg);
    }

    public static void sendToServer(Object msg) {
        CHANNEL.sendToServer(msg);
    }

    public static void sendToPlayer(Object msg, ServerPlayer player) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), msg);
    }

    public static void sendToast(ServerPlayer player, String title, String msg) {
        if (player != null) {
            BackyardNetwork.sendToPlayer(new ToastPacket(title, msg), player);
        }
    }

    static {
        packetId = 0;
    }

    public static class RequestWhitelistPacket {
        public static void encode(RequestWhitelistPacket msg, FriendlyByteBuf buf) {
        }

        public static RequestWhitelistPacket decode(FriendlyByteBuf buf) {
            return new RequestWhitelistPacket();
        }

        public static void handle(RequestWhitelistPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null && player.m_20310_(2)) {
                    String[] whitelistNames = player.m_20194_().m_6846_().m_11306_();
                    ArrayList<String> names = new ArrayList<String>(Arrays.asList(whitelistNames));
                    BackyardNetwork.sendToPlayer(new SyncWhitelistPacket(names), player);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class SyncWhitelistPacket {
        private final List<String> names;

        public SyncWhitelistPacket(List<String> names) {
            this.names = names;
        }

        public static void encode(SyncWhitelistPacket msg, FriendlyByteBuf buf) {
            buf.writeInt(msg.names.size());
            for (String name : msg.names) {
                buf.m_130070_(name);
            }
        }

        public static SyncWhitelistPacket decode(FriendlyByteBuf buf) {
            int size = buf.readInt();
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < size; ++i) {
                names.add(buf.m_130277_());
            }
            return new SyncWhitelistPacket(names);
        }

        public static void handle(SyncWhitelistPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SafePacketHandler.handleWhitelist(msg.names)));
            ctx.get().setPacketHandled(true);
        }
    }
}

