/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ModConfiguration {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.BooleanValue ADMIN_MODE;
    public static final ForgeConfigSpec.BooleanValue LOCK_INVENTORY;
    public static final ForgeConfigSpec.BooleanValue ENABLE_TIME_SYNC;
    public static final ForgeConfigSpec.DoubleValue REAL_START;
    public static final ForgeConfigSpec.DoubleValue REAL_END;
    public static final ForgeConfigSpec.IntValue GAME_START;
    public static final ForgeConfigSpec.IntValue GAME_END;
    public static final ForgeConfigSpec.DoubleValue ZOOM_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue ZOOM_SMOOTHNESS;
    public static final ForgeConfigSpec.DoubleValue ROTATION_SMOOTHNESS;
    public static final ForgeConfigSpec.BooleanValue HIDE_HUD_ONLY;
    public static final ForgeConfigSpec.IntValue MAX_RENDER_COUNT;
    public static final ForgeConfigSpec.BooleanValue ENABLE_RENDER_DISTANCE;
    public static final ForgeConfigSpec.DoubleValue RENDER_DISTANCE;
    public static final ForgeConfigSpec.BooleanValue SHOW_SHADOW_NAMES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> PLAYER_OVERRIDES;
    public static final ForgeConfigSpec.BooleanValue IS_WHITELIST_MODE;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> SPAWN_LIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> BANNED_ITEMS;
    public static final ForgeConfigSpec.DoubleValue PLAYER_SCALE;
    public static final ForgeConfigSpec.BooleanValue ENABLE_THIRST;
    public static final ForgeConfigSpec.IntValue MAX_THIRST;
    public static final ForgeConfigSpec.DoubleValue THIRST_DECAY_RATE;

    static {
        BUILDER.push("Admin System Settings");
        ADMIN_MODE = BUILDER.comment("\u0e40\u0e1b\u0e34\u0e14\u0e43\u0e0a\u0e49\u0e07\u0e32\u0e19\u0e42\u0e2b\u0e21\u0e14\u0e41\u0e2d\u0e14\u0e21\u0e34\u0e19").define("adminMode", false);
        LOCK_INVENTORY = BUILDER.comment("\u0e40\u0e1b\u0e34\u0e14\u0e43\u0e0a\u0e49\u0e07\u0e32\u0e19\u0e01\u0e32\u0e23\u0e25\u0e47\u0e2d\u0e04\u0e01\u0e23\u0e30\u0e40\u0e1b\u0e4b\u0e32").define("lockInventory", false);
        BUILDER.pop();
        BUILDER.push("Time Sync Settings");
        ENABLE_TIME_SYNC = BUILDER.define("enableTimeSync", true);
        REAL_START = BUILDER.defineInRange("realStartHour", 19.5, 0.0, 24.0);
        REAL_END = BUILDER.defineInRange("realEndHour", 22.5, 0.0, 24.0);
        GAME_START = BUILDER.defineInRange("gameStartTime", 0, 0, 24000);
        GAME_END = BUILDER.defineInRange("gameEndTime", 14000, 0, 24000);
        BUILDER.pop();
        BUILDER.push("Zoom and HUD");
        ZOOM_MULTIPLIER = BUILDER.defineInRange("zoomMultiplier", 0.25, 0.1, 0.8);
        ZOOM_SMOOTHNESS = BUILDER.defineInRange("zoomSmoothness", 0.08, 0.01, 0.5);
        ROTATION_SMOOTHNESS = BUILDER.defineInRange("rotationSmoothness", 1.0, 0.0, 1.0);
        HIDE_HUD_ONLY = BUILDER.define("hideHudOnly", false);
        BUILDER.pop();
        BUILDER.push("Optimization");
        MAX_RENDER_COUNT = BUILDER.defineInRange("maxRenderCount", 5, 0, 1000);
        ENABLE_RENDER_DISTANCE = BUILDER.define("enableRenderDistance", true);
        RENDER_DISTANCE = BUILDER.defineInRange("playerRenderDistance", 32.0, 5.0, 128.0);
        SHOW_SHADOW_NAMES = BUILDER.define("showShadowNames", true);
        PLAYER_OVERRIDES = BUILDER.defineList("playerOverrides", new ArrayList(), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.push("Monster Management");
        IS_WHITELIST_MODE = BUILDER.define("isWhitelistMode", false);
        SPAWN_LIST = BUILDER.defineList("spawnList", new ArrayList(), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.push("Item Management");
        BANNED_ITEMS = BUILDER.defineList("bannedItems", new ArrayList(), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.push("Character Settings");
        PLAYER_SCALE = BUILDER.defineInRange("playerScale", 1.0, 0.8, 1.3);
        BUILDER.pop();
        BUILDER.push("Thirst System");
        ENABLE_THIRST = BUILDER.comment("\u0e40\u0e1b\u0e34\u0e14\u0e43\u0e0a\u0e49\u0e07\u0e32\u0e19\u0e23\u0e30\u0e1a\u0e1a\u0e2b\u0e34\u0e27\u0e19\u0e49\u0e33\u0e2b\u0e23\u0e37\u0e2d\u0e44\u0e21\u0e48").define("enable_thirst", true);
        MAX_THIRST = BUILDER.comment("\u0e04\u0e48\u0e32\u0e04\u0e27\u0e32\u0e21\u0e2b\u0e34\u0e27\u0e19\u0e49\u0e33\u0e2a\u0e39\u0e07\u0e2a\u0e38\u0e14").defineInRange("max_thirst", 100, 1, 1000);
        THIRST_DECAY_RATE = BUILDER.comment("\u0e04\u0e27\u0e32\u0e21\u0e40\u0e23\u0e47\u0e27\u0e43\u0e19\u0e01\u0e32\u0e23\u0e25\u0e14\u0e02\u0e2d\u0e07\u0e19\u0e49\u0e33 (\u0e22\u0e34\u0e48\u0e07\u0e40\u0e22\u0e2d\u0e30\u0e22\u0e34\u0e48\u0e07\u0e25\u0e14\u0e44\u0e27 \u0e41\u0e19\u0e30\u0e19\u0e33\u0e04\u0e48\u0e32\u0e1b\u0e23\u0e30\u0e21\u0e32\u0e13 0.001)").defineInRange("decay_rate", 0.001, 0.0, 10.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

