/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.client.render;

import fox.org.mc.backyardlib.config.ModConfiguration;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="backyardlib", value={Dist.CLIENT})
public class RenderStateManager {
    private static final Set<Integer> allowedEntityIds = new HashSet<Integer>();

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            RenderStateManager.updateRenderList();
        }
    }

    private static void updateRenderList() {
        if (!ModConfiguration.SPEC.isLoaded()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        allowedEntityIds.clear();
        int maxCount = (Integer)ModConfiguration.MAX_RENDER_COUNT.get();
        boolean enableDist = (Boolean)ModConfiguration.ENABLE_RENDER_DISTANCE.get();
        double renderDist = (Double)ModConfiguration.RENDER_DISTANCE.get();
        double renderDistSq = renderDist * renderDist;
        if (maxCount <= 0) {
            return;
        }
        if (maxCount > 50) {
            for (Player p2 : mc.f_91073_.m_6907_()) {
                if (p2 == mc.f_91074_ || enableDist && !(p2.m_20280_((Entity)mc.f_91074_) <= renderDistSq)) continue;
                allowedEntityIds.add(p2.m_19879_());
            }
            return;
        }
        List players = mc.f_91073_.m_6907_().stream().filter(p -> p != mc.f_91074_).filter(p -> !enableDist || p.m_20280_((Entity)mc.f_91074_) <= renderDistSq).sorted(Comparator.comparingDouble(p -> p.m_20280_((Entity)mc.f_91074_))).collect(Collectors.toList());
        for (int i = 0; i < Math.min(players.size(), maxCount); ++i) {
            allowedEntityIds.add(((Player)players.get(i)).m_19879_());
        }
    }

    public static boolean canRender3D(int entityId, int maxCount) {
        if (!ModConfiguration.SPEC.isLoaded()) {
            return false;
        }
        if (maxCount > 50) {
            return true;
        }
        return allowedEntityIds.contains(entityId);
    }
}

