/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import fox.org.mc.backyardlib.client.gui.BackyardSettingsScreen;
import fox.org.mc.backyardlib.client.render.PlayerRenderMode;
import fox.org.mc.backyardlib.client.render.RenderStateManager;
import fox.org.mc.backyardlib.config.ModConfiguration;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="backyardlib", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientRendererEvents {
    private static final ResourceLocation SHADOW_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/entity/player_shadow.png");

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        BackyardSettingsScreen screen;
        Screen screen2;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS && (screen2 = mc.f_91080_) instanceof BackyardSettingsScreen && (screen = (BackyardSettingsScreen)screen2).getCurrentTab() == 2 && screen.isTempRenderDistanceEnabled()) {
            ClientRendererEvents.renderDistanceCircle(event, mc, screen.getTempRenderDistance());
        }
    }

    private static void renderDistanceCircle(RenderLevelStageEvent event, Minecraft mc, double radius) {
        PoseStack poseStack = event.getPoseStack();
        poseStack.m_85836_();
        Vec3 camPos = event.getCamera().m_90583_();
        float pt = event.getPartialTick();
        double px = Mth.m_14139_((double)pt, (double)mc.f_91074_.f_19854_, (double)mc.f_91074_.m_20185_());
        double py = Mth.m_14139_((double)pt, (double)mc.f_91074_.f_19855_, (double)mc.f_91074_.m_20186_());
        double pz = Mth.m_14139_((double)pt, (double)mc.f_91074_.f_19856_, (double)mc.f_91074_.m_20189_());
        poseStack.m_85837_(px - camPos.f_82479_, py - camPos.f_82480_ + 0.1, pz - camPos.f_82481_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.lineWidth((float)4.0f);
        RenderSystem.disableDepthTest();
        buffer.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        for (int i = 0; i <= 64; ++i) {
            double angle = Math.PI * 2 * (double)i / 64.0;
            double x = Math.cos(angle) * radius;
            double z = Math.sin(angle) * radius;
            buffer.m_252986_(poseStack.m_85850_().m_252922_(), (float)x, 0.0f, (float)z).m_6122_(46, 204, 113, 255).m_5752_();
        }
        tesselator.m_85914_();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableDepthTest();
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void onRenderNameTag(RenderNameTagEvent event) {
        double maxDist;
        double distSq;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Minecraft mc = Minecraft.m_91087_();
        if (((Boolean)ModConfiguration.ADMIN_MODE.get()).booleanValue()) {
            if (player.equals((Object)mc.f_91074_)) {
                event.setResult(Event.Result.DENY);
                return;
            }
            event.setResult(Event.Result.ALLOW);
            return;
        }
        if (player == mc.f_91074_) {
            return;
        }
        UUID uuid = player.m_20148_();
        PlayerRenderMode mode = ClientRendererEvents.getPlayerMode(uuid);
        if (mode != PlayerRenderMode.FORCE_VISIBLE && ((Boolean)ModConfiguration.ENABLE_RENDER_DISTANCE.get()).booleanValue() && (distSq = player.m_20280_((Entity)mc.f_91074_)) > (maxDist = ((Double)ModConfiguration.RENDER_DISTANCE.get()).doubleValue()) * maxDist) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (((Boolean)ModConfiguration.SHOW_SHADOW_NAMES.get()).booleanValue() || mode != PlayerRenderMode.FORCE_VISIBLE) {
            // empty if block
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderPlayerPre(RenderPlayerEvent.Pre event) {
        double maxDist;
        double distSq;
        Player player = event.getEntity();
        Minecraft mc = Minecraft.m_91087_();
        if (((Boolean)ModConfiguration.ADMIN_MODE.get()).booleanValue()) {
            if (player.equals((Object)mc.f_91074_)) {
                event.setCanceled(true);
                return;
            }
            if (player.m_20145_()) {
                ClientRendererEvents.renderShadow((AbstractClientPlayer)player, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
                event.setCanceled(true);
                return;
            }
        }
        if (player.equals((Object)mc.f_91074_)) {
            return;
        }
        UUID uuid = player.m_20148_();
        PlayerRenderMode mode = ClientRendererEvents.getPlayerMode(uuid);
        if (!((Boolean)ModConfiguration.ADMIN_MODE.get()).booleanValue() && mode != PlayerRenderMode.FORCE_VISIBLE && ((Boolean)ModConfiguration.ENABLE_RENDER_DISTANCE.get()).booleanValue() && (distSq = player.m_20280_((Entity)mc.f_91074_)) > (maxDist = ((Double)ModConfiguration.RENDER_DISTANCE.get()).doubleValue()) * maxDist) {
            event.setCanceled(true);
            return;
        }
        boolean shouldRenderShadow = false;
        if (mode == PlayerRenderMode.FORCE_HIDDEN) {
            shouldRenderShadow = true;
        } else if (mode == PlayerRenderMode.FORCE_VISIBLE) {
            shouldRenderShadow = false;
        } else {
            int maxCount = (Integer)ModConfiguration.MAX_RENDER_COUNT.get();
            if (maxCount > 50) {
                shouldRenderShadow = false;
            } else if (maxCount <= 0) {
                shouldRenderShadow = true;
            } else if (!RenderStateManager.canRender3D(player.m_19879_(), maxCount)) {
                shouldRenderShadow = true;
            }
        }
        if (shouldRenderShadow) {
            event.setCanceled(true);
            ClientRendererEvents.renderShadow((AbstractClientPlayer)player, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
        }
    }

    private static PlayerRenderMode getPlayerMode(UUID uuid) {
        for (String entry : (List)ModConfiguration.PLAYER_OVERRIDES.get()) {
            if (!entry.startsWith(uuid.toString())) continue;
            try {
                String[] parts = entry.split(":");
                return PlayerRenderMode.valueOf(parts[1]);
            }
            catch (Exception exception) {
            }
        }
        return PlayerRenderMode.AUTO;
    }

    private static void renderShadow(AbstractClientPlayer player, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-Minecraft.m_91087_().f_91063_.m_109153_().m_90590_()));
        VertexConsumer vc = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)SHADOW_TEXTURE));
        Matrix4f posMatrix = poseStack.m_85850_().m_252922_();
        Matrix3f normMatrix = poseStack.m_85850_().m_252943_();
        float hw = player.m_20205_() * 0.6f;
        float h = player.m_20206_();
        ClientRendererEvents.vertex(vc, posMatrix, normMatrix, -hw, h, 0.0f, 0.0f, 0.0f, packedLight);
        ClientRendererEvents.vertex(vc, posMatrix, normMatrix, hw, h, 0.0f, 1.0f, 0.0f, packedLight);
        ClientRendererEvents.vertex(vc, posMatrix, normMatrix, hw, 0.0f, 0.0f, 1.0f, 1.0f, packedLight);
        ClientRendererEvents.vertex(vc, posMatrix, normMatrix, -hw, 0.0f, 0.0f, 0.0f, 1.0f, packedLight);
        poseStack.m_85849_();
    }

    private static void vertex(VertexConsumer consumer, Matrix4f pose, Matrix3f normal, float x, float y, float z, float u, float v, int light) {
        consumer.m_252986_(pose, x, y, z).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

