/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.client.gui;

import fox.org.mc.backyardlib.config.ModConfiguration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="backyardlib", value={Dist.CLIENT})
public class TimeHUDHandler {
    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91080_ != null || mc.f_91073_ == null || ((Boolean)ModConfiguration.HIDE_HUD_ONLY.get()).booleanValue()) {
            return;
        }
        long gameTime = mc.f_91073_.m_46468_();
        long totalSeconds = gameTime * 3600L / 1000L;
        long hours = (totalSeconds / 3600L + 6L) % 24L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        double currentTimeDecimal = (double)hours + (double)minutes / 60.0;
        double startTime = (Double)ModConfiguration.REAL_START.get();
        double endTime = (Double)ModConfiguration.REAL_END.get();
        double warningTime = startTime - 0.5;
        int color = 0xFFFFFF;
        boolean shouldShow = false;
        if (currentTimeDecimal >= startTime && currentTimeDecimal <= endTime) {
            color = 0xFFFFFF;
            shouldShow = true;
        } else if (currentTimeDecimal >= warningTime && currentTimeDecimal < startTime) {
            color = 0xFFFF55;
            shouldShow = true;
        }
        if (!shouldShow) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int screenWidth = event.getWindow().m_85445_();
        int screenHeight = event.getWindow().m_85446_();
        String timeStr = String.format("%02d:%02d:%02d", hours, minutes, seconds);
        float scale = 0.7f;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        int x = (int)(((float)screenWidth - (float)mc.f_91062_.m_92895_(timeStr) * scale - 5.0f) / scale);
        int y = (int)(((float)screenHeight - 9.0f * scale - 5.0f) / scale);
        guiGraphics.m_280056_(mc.f_91062_, timeStr, x, y, color, true);
        guiGraphics.m_280168_().m_85849_();
    }
}

