/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fox.org.mc.backyardlib.school.ScheduleData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class ScheduleScreen
extends Screen {
    private static final ResourceLocation STATIC_BG = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/bg.png");
    private static final ResourceLocation BG_0 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_0.png");
    private static final ResourceLocation BG_1 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_1.png");
    private static final ResourceLocation BG_2 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_2.png");
    private static final ResourceLocation SCHOOL_SEAL = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/school_seal.png");
    private static final Quaternionf TILT_ROTATION = new Quaternionf().rotateZ((float)Math.toRadians(-2.0));
    private static final ScheduleData.Entry EMPTY_ENTRY = new ScheduleData.Entry();
    private final Map<String, ResourceLocation> skinCache = new HashMap<String, ResourceLocation>();
    private final String roomId;
    private final ScheduleData data;
    private int pageOffset = 0;
    private float time = 0.0f;
    private float ticksOpen = 0.0f;
    private final int cardWidth = 420;
    private final int cardHeight = 260;

    public ScheduleScreen(String roomId, boolean isAdmin, ScheduleData data) {
        super((Component)Component.m_237113_((String)("\u0e15\u0e32\u0e23\u0e32\u0e07\u0e40\u0e23\u0e35\u0e22\u0e19: " + roomId)));
        this.roomId = roomId;
        this.data = data;
        if (data.activeDayIndex >= 0) {
            this.pageOffset = data.activeDayIndex;
        }
    }

    protected void m_7856_() {
        this.ticksOpen = 0.0f;
        this.skinCache.clear();
    }

    public void m_86600_() {
        this.time += 1.0f;
        if (this.ticksOpen < 20.0f) {
            this.ticksOpen += 1.0f;
        }
    }

    public void m_88315_(GuiGraphics g, int mx, int my, float pt) {
        this.m_280273_(g);
        this.renderStaticBackground(g);
        float anim = Mth.m_14036_((float)((this.ticksOpen + pt) / 15.0f), (float)0.0f, (float)1.0f);
        float scale = this.easeOutBack(anim);
        int cx = this.f_96543_ / 2;
        int cy = this.f_96544_ / 2;
        int left = cx - 210;
        int top = cy - 130;
        g.m_280168_().m_85836_();
        g.m_280168_().m_252880_((float)cx, (float)cy, 0.0f);
        g.m_280168_().m_85841_(scale, scale, 1.0f);
        g.m_280168_().m_252781_(TILT_ROTATION);
        g.m_280168_().m_252880_((float)(-cx), (float)(-cy), 0.0f);
        this.fillRoundedRect(g, left - 5, top - 5, 430, 270, 12, 0x60000000);
        this.renderCardAnimatedBG(g, left, top, 420, 260, pt);
        this.fillRoundedRect(g, left, top, 420, 260, 10, -435023342);
        g.m_280509_(left, top, left + 420, top + 1, 0x50FFFFFF);
        g.m_280509_(left, top + 260 - 1, left + 420, top + 260, 0x50000000);
        this.fillRoundedRect(g, left + 10, top + 10, 400, 30, 6, -14803426);
        g.m_280509_(left + 20, top + 18, left + 23, top + 32, -16718218);
        g.m_280488_(this.f_96547_, "\u0e15\u0e32\u0e23\u0e32\u0e07\u0e40\u0e23\u0e35\u0e22\u0e19", left + 30, top + 21, -5592406);
        String roomTxt = this.roomId;
        g.m_280056_(this.f_96547_, roomTxt, left + 420 - 30 - this.f_96547_.m_92895_(roomTxt), top + 21, -1, true);
        ScheduleData.Entry hovered = this.renderGridSystem(g, left + 15, top + 50, 390, 195, mx, my);
        this.renderSchoolSeal(g, left + 420 - 70, top + 260 - 80, 150);
        g.m_280168_().m_85849_();
        if (hovered != null) {
            this.renderEntryTooltip(g, hovered, mx, my);
        }
        super.m_88315_(g, mx, my, pt);
    }

    private void renderStaticBackground(GuiGraphics g) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)STATIC_BG);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        g.m_280163_(STATIC_BG, 0, 0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, this.f_96543_, this.f_96544_);
    }

    private void renderCardAnimatedBG(GuiGraphics g, int x, int y, int w, int h, float pt) {
        float scroll = (this.time + pt) * 0.5f;
        this.drawTiledTexture(g, BG_0, x, y, w, h, 0.8f, scroll * 0.2f);
        this.drawTiledTexture(g, BG_1, x, y, w, h, 0.7f, scroll * 0.5f);
        this.drawTiledTexture(g, BG_2, x, y, w, h, 0.9f, scroll * 0.8f);
    }

    private void renderSchoolSeal(GuiGraphics g, int centerX, int centerY, int size) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SCHOOL_SEAL);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)0.8f, (float)0.2f, (float)0.2f, (float)0.2f);
        g.m_280168_().m_85836_();
        g.m_280168_().m_252880_((float)centerX, (float)centerY, 0.0f);
        g.m_280168_().m_252781_(new Quaternionf().rotateZ((float)Math.toRadians(-15.0)));
        g.m_280168_().m_252880_((float)(-size) / 2.0f, (float)(-size) / 2.0f, 0.0f);
        g.m_280163_(SCHOOL_SEAL, 0, 0, 0.0f, 0.0f, size, size, size, size);
        g.m_280168_().m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private ScheduleData.Entry renderGridSystem(GuiGraphics g, int x, int y, int w, int h, int mx, int my) {
        ScheduleData.Entry hovered = null;
        int headerH = 20;
        int headerW = 35;
        int gap = 3;
        int cols = 9;
        int rows = 5;
        int cellW = (w - headerW) / cols - gap;
        int cellH = (h - headerH) / rows - gap;
        int refDay = Math.max(0, this.data.activeDayIndex);
        for (int c = 0; c < cols; ++c) {
            int tx = x + headerW + c * (cellW + gap) + gap;
            String t = this.data.getEntry((int)refDay, (int)c).time;
            if (t == null || t.isEmpty()) {
                t = String.valueOf(c + 1);
            }
            this.fillRoundedRect(g, tx, y, cellW, headerH, 3, 0x20FFFFFF);
            g.m_280137_(this.f_96547_, t, tx + cellW / 2, y + 6, -7829368);
        }
        int totalDays = this.data.getTotalDays();
        for (int r = 0; r < rows; ++r) {
            int span;
            int dayIndex = this.pageOffset + r;
            boolean valid = dayIndex < totalDays;
            boolean active = valid && dayIndex == this.data.activeDayIndex;
            int rowY = y + headerH + gap + r * (cellH + gap);
            this.fillRoundedRect(g, x, rowY, headerW, cellH, 4, active ? -16718218 : 0x30303030);
            String dTxt = "D" + (dayIndex + 1);
            g.m_280137_(this.f_96547_, dTxt, x + headerW / 2, rowY + cellH / 2 - 4, active ? -16777216 : -10066330);
            for (int c = 0; c < cols; c += span) {
                int cellX = x + headerW + c * (cellW + gap) + gap;
                ScheduleData.Entry cur = valid ? this.data.getEntry(dayIndex, c) : EMPTY_ENTRY;
                span = 1;
                if (!cur.subject.isEmpty()) {
                    for (int n = c + 1; n < cols; ++n) {
                        ScheduleData.Entry ne = this.data.getEntry(dayIndex, n);
                        if (!cur.subject.equals(ne.subject) || !cur.teacher.equals(ne.teacher)) break;
                        ++span;
                    }
                }
                int boxW = cellW * span + gap * (span - 1);
                if (!cur.subject.isEmpty()) {
                    boolean hasHead;
                    boolean hover = mx >= cellX && mx < cellX + boxW && my >= rowY && my < rowY + cellH;
                    this.fillRoundedRect(g, cellX, rowY, boxW, cellH, 4, hover ? -12285185 : -14064897);
                    boolean bl = hasHead = !cur.teacherIgn.isEmpty();
                    if (hasHead) {
                        ResourceLocation skin = this.skinCache.computeIfAbsent(cur.teacherIgn, this::resolveSkin);
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)skin);
                        RenderSystem.enableBlend();
                        float headX = span == 1 ? (float)cellX + (float)(boxW - 16) / 2.0f : (float)(cellX + 6);
                        float headY = (float)rowY + (float)(cellH - 16) / 2.0f;
                        g.m_280411_(skin, (int)headX, (int)headY, 16, 16, 8.0f, 8.0f, 8, 8, 64, 64);
                        g.m_280411_(skin, (int)headX, (int)headY, 16, 16, 40.0f, 8.0f, 8, 8, 64, 64);
                    }
                    if (span >= 2 || !hasHead) {
                        g.m_280168_().m_85836_();
                        int textOffset = hasHead && span >= 2 ? 24 : 0;
                        float padding = 4.0f;
                        float availableW = (float)(boxW - textOffset) - padding * 2.0f;
                        int strW = this.f_96547_.m_92895_(cur.subject);
                        float renderScale = Math.min(0.8f, availableW / (float)strW);
                        float txtX = (float)(cellX + textOffset) + ((float)(boxW - textOffset) - (float)strW * renderScale) / 2.0f;
                        float txtY = (float)rowY + (float)cellH / 2.0f - 8.0f * renderScale / 2.0f + 1.0f;
                        g.m_280168_().m_252880_(txtX, txtY, 0.0f);
                        g.m_280168_().m_85841_(renderScale, renderScale, 1.0f);
                        g.m_280056_(this.f_96547_, cur.subject, 0, 0, -1, true);
                        g.m_280168_().m_85849_();
                    }
                    if (!hover) continue;
                    hovered = cur;
                    continue;
                }
                this.fillRoundedRect(g, cellX, rowY, boxW, cellH, 4, 0x10FFFFFF);
            }
        }
        return hovered;
    }

    private ResourceLocation resolveSkin(String name) {
        if (this.f_96541_.m_91403_() == null) {
            return DefaultPlayerSkin.m_118626_();
        }
        PlayerInfo info = this.f_96541_.m_91403_().m_104938_(name);
        return info != null ? info.m_105337_() : DefaultPlayerSkin.m_118626_();
    }

    private void renderEntryTooltip(GuiGraphics g, ScheduleData.Entry e, int mx, int my) {
        ArrayList<MutableComponent> t = new ArrayList<MutableComponent>();
        t.add(Component.m_237113_((String)e.subject).m_130940_(ChatFormatting.GOLD));
        t.add(Component.m_237113_((String)"\u0e2d\u0e32\u0e08\u0e32\u0e23\u0e22\u0e4c: ").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)e.teacher).m_130940_(ChatFormatting.WHITE)));
        t.add(Component.m_237113_((String)"\u0e40\u0e27\u0e25\u0e32: ").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)e.time).m_130940_(ChatFormatting.WHITE)));
        if (!e.note.isEmpty()) {
            t.add(Component.m_237113_((String)"\u0e2b\u0e49\u0e2d\u0e07: ").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)e.note).m_130940_(ChatFormatting.YELLOW)));
        }
        g.m_280666_(this.f_96547_, t, mx, my);
    }

    private void fillRoundedRect(GuiGraphics g, int x, int y, int w, int h, int r, int color) {
        g.m_280509_(x + r, y, x + w - r, y + h, color);
        g.m_280509_(x, y + r, x + r, y + h - r, color);
        g.m_280509_(x + w - r, y + r, x + w, y + h - r, color);
        g.m_280509_(x + 1, y + 1, x + r, y + r, color);
        g.m_280509_(x + w - r, y + 1, x + w - 1, y + r, color);
        g.m_280509_(x + 1, y + h - r, x + r, y + h - 1, color);
        g.m_280509_(x + w - r, y + h - r, x + w - 1, y + h - 1, color);
    }

    private void drawTiledTexture(GuiGraphics g, ResourceLocation tex, int x, int y, int w, int h, float alpha, float offset) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tex);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        Matrix4f matrix = g.m_280168_().m_85850_().m_252922_();
        float u = (float)w / 256.0f;
        float v = (float)h / 256.0f;
        float off = offset / 200.0f;
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buf.m_252986_(matrix, (float)x, (float)(y + h), 0.0f).m_7421_(off, v + off).m_5752_();
        buf.m_252986_(matrix, (float)(x + w), (float)(y + h), 0.0f).m_7421_(u + off, v + off).m_5752_();
        buf.m_252986_(matrix, (float)(x + w), (float)y, 0.0f).m_7421_(u + off, off).m_5752_();
        buf.m_252986_(matrix, (float)x, (float)y, 0.0f).m_7421_(off, off).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private float easeOutBack(float t) {
        float s = 1.70158f;
        return (t - 1.0f) * (t - 1.0f) * ((s + 1.0f) * (t - 1.0f) + s) + 1.0f;
    }
}

