/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import fox.org.mc.backyardlib.network.BackyardNetwork;
import fox.org.mc.backyardlib.network.school.PacketCreateRoom;
import fox.org.mc.backyardlib.network.school.PacketDeleteRoom;
import fox.org.mc.backyardlib.network.school.PacketGiveScheduleItem;
import fox.org.mc.backyardlib.network.school.PacketRequestScheduleData;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ScheduleListScreen
extends Screen {
    private static final ResourceLocation BG_0 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_0.png");
    private static final ResourceLocation BG_1 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_1.png");
    private static final ResourceLocation BG_2 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_2.png");
    private final List<String> rooms;
    private EditBox newRoomInput;
    private RoomList roomListWidget;
    private int ticksOpen = 0;

    public ScheduleListScreen(List<String> rooms) {
        super((Component)Component.m_237113_((String)"\u0e08\u0e31\u0e14\u0e01\u0e32\u0e23\u0e2b\u0e49\u0e2d\u0e07\u0e40\u0e23\u0e35\u0e22\u0e19"));
        this.rooms = rooms;
    }

    public void updateRooms(List<String> newRooms) {
        this.rooms.clear();
        this.rooms.addAll(newRooms);
        if (this.roomListWidget != null) {
            this.roomListWidget.refreshList();
        }
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int panelY = 40;
        int panelH = this.f_96544_ - 80;
        this.newRoomInput = new EditBox(this.f_96547_, centerX - 130, panelY + 10, 150, 20, (Component)Component.m_237113_((String)""));
        this.newRoomInput.m_257771_((Component)Component.m_237113_((String)"\u0e15\u0e31\u0e49\u0e07\u0e0a\u0e37\u0e48\u0e2d\u0e2b\u0e49\u0e2d\u0e07\u0e40\u0e23\u0e35\u0e22\u0e19\u0e43\u0e2b\u0e21\u0e48..."));
        this.m_142416_((GuiEventListener)this.newRoomInput);
        this.m_142416_((GuiEventListener)new ColoredOutlineButton(centerX + 30, panelY + 10, 60, 20, (Component)Component.m_237113_((String)"\u0e2a\u0e23\u0e49\u0e32\u0e07"), 3066993, b -> {
            String name = this.newRoomInput.m_94155_();
            if (!name.isEmpty()) {
                BackyardNetwork.sendToServer(new PacketCreateRoom(name));
                this.newRoomInput.m_94144_("");
            }
        }));
        this.roomListWidget = new RoomList(this.f_96541_, 340, panelH - 50, panelY + 40, panelY + panelH - 10, centerX - 170);
        this.m_142416_((GuiEventListener)this.roomListWidget);
        this.roomListWidget.refreshList();
        this.m_142416_((GuiEventListener)new ColoredOutlineButton(centerX - 50, this.f_96544_ - 30, 100, 20, (Component)Component.m_237113_((String)"\u0e1b\u0e34\u0e14\u0e2b\u0e19\u0e49\u0e32\u0e15\u0e48\u0e32\u0e07"), 15158332, b -> this.m_7379_()));
    }

    public void m_88315_(GuiGraphics g, int mx, int my, float pt) {
        float renderTime = (float)this.ticksOpen + pt;
        this.drawAnimatedBG(g, BG_0, renderTime * 0.15f, 64);
        this.drawAnimatedBG(g, BG_1, renderTime * 0.35f, 64);
        this.drawAnimatedBG(g, BG_2, renderTime * 0.65f, 64);
        int centerX = this.f_96543_ / 2;
        g.m_280509_(centerX - 180, 30, centerX + 180, this.f_96544_ - 40, -872415232);
        g.m_280637_(centerX - 180, 30, 360, this.f_96544_ - 70, 0x44FFFFFF);
        g.m_280137_(this.f_96547_, "\u0e23\u0e30\u0e1a\u0e1a\u0e08\u0e31\u0e14\u0e01\u0e32\u0e23\u0e15\u0e32\u0e23\u0e32\u0e07\u0e40\u0e23\u0e35\u0e22\u0e19", centerX, 15, -1);
        super.m_88315_(g, mx, my, pt);
        if (this.roomListWidget.isEmpty()) {
            g.m_280137_(this.f_96547_, "\u0e22\u0e31\u0e07\u0e44\u0e21\u0e48\u0e21\u0e35\u0e2b\u0e49\u0e2d\u0e07\u0e40\u0e23\u0e35\u0e22\u0e19", centerX, this.f_96544_ / 2, -1996488705);
        }
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.ticksOpen;
    }

    private void drawAnimatedBG(GuiGraphics g, ResourceLocation tex, float offset, int size) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tex);
        RenderSystem.enableBlend();
        int xOff = (int)(offset % (float)size);
        int yOff = (int)(offset % (float)size);
        for (int x = -xOff; x < this.f_96543_; x += size) {
            for (int y = -yOff; y < this.f_96544_; y += size) {
                g.m_280163_(tex, x, y, 0.0f, 0.0f, size, size, size, size);
            }
        }
    }

    class RoomList
    extends ObjectSelectionList<RoomEntry> {
        public RoomList(Minecraft mc, int w, int h, int y0, int y1, int x) {
            super(mc, w, h, y0, y1, 24);
            this.m_93507_(x);
            this.m_93488_(false);
            this.m_93496_(false);
        }

        protected int m_5756_() {
            return this.f_93393_ + this.f_93388_ - 5;
        }

        public int m_5759_() {
            return this.f_93388_ - 15;
        }

        public boolean isEmpty() {
            return this.m_5773_() == 0;
        }

        public void refreshList() {
            this.m_93516_();
            for (String room : ScheduleListScreen.this.rooms) {
                this.m_7085_((AbstractSelectionList.Entry)new RoomEntry(room));
            }
        }

        class RoomEntry
        extends ObjectSelectionList.Entry<RoomEntry> {
            private final String name;
            private final Button btnEdit;
            private final Button btnGive;
            private final Button btnDel;

            public RoomEntry(String name) {
                this.name = name;
                this.btnEdit = new ColoredOutlineButton(0, 0, 50, 16, (Component)Component.m_237113_((String)"\u0e41\u0e01\u0e49\u0e44\u0e02"), 3447003, b -> BackyardNetwork.sendToServer(new PacketRequestScheduleData(name)));
                this.btnGive = new ColoredOutlineButton(0, 0, 40, 16, (Component)Component.m_237113_((String)"\u0e40\u0e2a\u0e01"), 15844367, b -> BackyardNetwork.sendToServer(new PacketGiveScheduleItem(name)));
                this.btnDel = new ColoredOutlineButton(0, 0, 30, 16, (Component)Component.m_237113_((String)"\u0e25\u0e1a"), 15158332, b -> BackyardNetwork.sendToServer(new PacketDeleteRoom(name)));
            }

            public void m_6311_(GuiGraphics g, int idx, int top, int left, int w, int h, int mx, int my, boolean hov, float pt) {
                g.m_280488_(ScheduleListScreen.this.f_96547_, this.name, left + 5, top + 6, 0xFFFFFF);
                this.btnDel.m_252865_(left + w - 35);
                this.btnDel.m_253211_(top + 2);
                this.btnDel.m_88315_(g, mx, my, pt);
                this.btnGive.m_252865_(left + w - 80);
                this.btnGive.m_253211_(top + 2);
                this.btnGive.m_88315_(g, mx, my, pt);
                this.btnEdit.m_252865_(left + w - 135);
                this.btnEdit.m_253211_(top + 2);
                this.btnEdit.m_88315_(g, mx, my, pt);
            }

            public boolean m_6375_(double x, double y, int b) {
                return this.btnEdit.m_6375_(x, y, b) || this.btnGive.m_6375_(x, y, b) || this.btnDel.m_6375_(x, y, b);
            }

            public Component m_142172_() {
                return Component.m_237119_();
            }
        }
    }

    private class ColoredOutlineButton
    extends Button {
        private final int borderColor;

        public ColoredOutlineButton(int x, int y, int w, int h, Component text, int color, Button.OnPress press) {
            super(x, y, w, h, text, press, Button.f_252438_);
            this.borderColor = color;
        }

        public void m_87963_(GuiGraphics g, int mx, int my, float pt) {
            RenderSystem.enableBlend();
            int finalColor = this.m_198029_() ? 0xFF000000 | this.borderColor : 0x44000000 | this.borderColor;
            g.m_280637_(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, finalColor);
            if (this.m_198029_()) {
                g.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, 0x22FFFFFF);
            }
            g.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, -1);
        }
    }
}

