/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import fox.org.mc.backyardlib.network.BackyardNetwork;
import fox.org.mc.backyardlib.network.school.PacketSaveSchedule;
import fox.org.mc.backyardlib.school.ScheduleData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ScheduleEditScreen
extends Screen {
    private static final ResourceLocation BG_0 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_0.png");
    private static final ResourceLocation BG_1 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_1.png");
    private static final ResourceLocation BG_2 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_2.png");
    private final String roomId;
    private final ScheduleData data;
    private int currentDay = 0;
    private int pageOffset = 0;
    private int ticksOpen = 0;
    private final EditBox[][] inputs = new EditBox[9][5];

    public ScheduleEditScreen(String roomId, ScheduleData data) {
        super((Component)Component.m_237113_((String)("\u0e41\u0e01\u0e49\u0e44\u0e02: " + roomId)));
        this.roomId = roomId;
        this.data = data;
    }

    protected void m_7856_() {
        int dayIndex;
        if (this.f_96541_ == null) {
            return;
        }
        int centerX = this.f_96543_ / 2;
        int left = centerX - 200;
        int top = 50;
        int maxTabs = 5;
        int totalDays = this.data.getTotalDays();
        while (this.currentDay >= this.pageOffset + maxTabs) {
            this.pageOffset += maxTabs;
        }
        while (this.currentDay < this.pageOffset) {
            this.pageOffset -= maxTabs;
        }
        if (this.pageOffset > 0) {
            this.m_142416_((GuiEventListener)new ColoredOutlineButton(left - 25, top - 25, 20, 20, (Component)Component.m_237113_((String)"<"), 0xFFFFFF, b -> {
                this.saveCurrentPage();
                this.pageOffset -= maxTabs;
                if (this.pageOffset < 0) {
                    this.pageOffset = 0;
                }
                this.currentDay = this.pageOffset;
                this.refresh();
            }));
        }
        for (int i = 0; i < maxTabs && (dayIndex = this.pageOffset + i) < totalDays; ++i) {
            boolean isSelected = dayIndex == this.currentDay;
            boolean isActive = dayIndex == this.data.activeDayIndex;
            String label = "Day " + (dayIndex + 1) + (isActive ? " \u2605" : "");
            int color = isSelected ? 3066993 : (isActive ? 15844367 : 0xAAAAAA);
            int d = dayIndex;
            ColoredOutlineButton btn = new ColoredOutlineButton(left + i * 70, top - 25, 65, 20, (Component)Component.m_237113_((String)label), color, b -> {
                this.saveCurrentPage();
                this.currentDay = d;
                this.refresh();
            });
            if (isSelected) {
                btn.f_93623_ = false;
            }
            this.m_142416_((GuiEventListener)btn);
        }
        if (this.pageOffset + maxTabs < totalDays) {
            this.m_142416_((GuiEventListener)new ColoredOutlineButton(left + maxTabs * 70 + 5, top - 25, 20, 20, (Component)Component.m_237113_((String)">"), 0xFFFFFF, b -> {
                this.saveCurrentPage();
                this.pageOffset += maxTabs;
                this.currentDay = this.pageOffset;
                this.refresh();
            }));
        }
        this.m_142416_((GuiEventListener)new ColoredOutlineButton(centerX + 160, top - 45, 40, 16, (Component)Component.m_237113_((String)"+ \u0e27\u0e31\u0e19"), 3447003, b -> {
            this.saveCurrentPage();
            this.data.addNewDay();
            this.currentDay = this.data.getTotalDays() - 1;
            this.refresh();
        }));
        if (this.currentDay != this.data.activeDayIndex) {
            this.m_142416_((GuiEventListener)new ColoredOutlineButton(centerX - 200, top - 45, 100, 16, (Component)Component.m_237113_((String)"\u0e43\u0e0a\u0e49\u0e27\u0e31\u0e19\u0e19\u0e35\u0e49\u0e41\u0e2a\u0e14\u0e07\u0e1c\u0e25"), 15844367, b -> {
                this.data.activeDayIndex = this.currentDay;
                this.refresh();
            }));
        }
        int startY = top + 20;
        int rowHeight = 22;
        for (int p = 0; p < 9; ++p) {
            ScheduleData.Entry entry = this.data.getEntry(this.currentDay, p);
            int x = left;
            this.inputs[p][0] = new EditBox(this.f_96547_, x, startY + p * rowHeight, 35, 18, (Component)Component.m_237119_());
            this.inputs[p][0].m_94144_(entry.time);
            this.inputs[p][1] = new EditBox(this.f_96547_, x += 38, startY + p * rowHeight, 90, 18, (Component)Component.m_237119_());
            this.inputs[p][1].m_94144_(entry.subject);
            this.inputs[p][1].m_257771_((Component)Component.m_237113_((String)"\u0e27\u0e34\u0e0a\u0e32"));
            this.inputs[p][2] = new EditBox(this.f_96547_, x += 93, startY + p * rowHeight, 60, 18, (Component)Component.m_237119_());
            this.inputs[p][2].m_94144_(entry.teacher);
            this.inputs[p][2].m_257771_((Component)Component.m_237113_((String)"\u0e0a\u0e37\u0e48\u0e2d\u0e04\u0e23\u0e39"));
            this.inputs[p][3] = new EditBox(this.f_96547_, x += 63, startY + p * rowHeight, 60, 18, (Component)Component.m_237119_());
            this.inputs[p][3].m_94144_(entry.teacherIgn);
            this.inputs[p][3].m_257771_((Component)Component.m_237113_((String)"\u0e0a\u0e37\u0e48\u0e2d\u0e43\u0e19\u0e40\u0e01\u0e21"));
            this.inputs[p][4] = new EditBox(this.f_96547_, x += 63, startY + p * rowHeight, 70, 18, (Component)Component.m_237119_());
            this.inputs[p][4].m_94144_(entry.note);
            this.inputs[p][4].m_257771_((Component)Component.m_237113_((String)"\u0e2a\u0e16\u0e32\u0e19\u0e17\u0e35\u0e48"));
            x += 73;
            for (int c = 0; c < 5; ++c) {
                this.m_142416_((GuiEventListener)this.inputs[p][c]);
            }
            if (p >= 8) continue;
            int currentP = p;
            this.m_142416_((GuiEventListener)new ColoredOutlineButton(x, startY + p * rowHeight, 15, 18, (Component)Component.m_237113_((String)"\u2193"), 15844367, b -> {
                for (int c = 1; c < 5; ++c) {
                    this.inputs[currentP + 1][c].m_94144_(this.inputs[currentP][c].m_94155_());
                }
            }));
        }
        this.m_142416_((GuiEventListener)new ColoredOutlineButton(centerX - 105, this.f_96544_ - 30, 100, 20, (Component)Component.m_237113_((String)"\u0e1a\u0e31\u0e19\u0e17\u0e36\u0e01"), 3066993, b -> {
            this.saveCurrentPage();
            BackyardNetwork.sendToServer(new PacketSaveSchedule(this.roomId, this.data));
            this.m_7379_();
        }));
        this.m_142416_((GuiEventListener)new ColoredOutlineButton(centerX + 5, this.f_96544_ - 30, 100, 20, (Component)Component.m_237113_((String)"\u0e22\u0e01\u0e40\u0e25\u0e34\u0e01"), 15158332, b -> this.m_7379_()));
    }

    private void refresh() {
        if (this.f_96541_ != null) {
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
    }

    private void saveCurrentPage() {
        for (int p = 0; p < 9; ++p) {
            if (this.inputs[p][0] == null) continue;
            this.data.setEntry(this.currentDay, p, this.inputs[p][0].m_94155_(), this.inputs[p][1].m_94155_(), this.inputs[p][2].m_94155_(), this.inputs[p][3].m_94155_(), this.inputs[p][4].m_94155_());
        }
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.ticksOpen;
    }

    public void m_88315_(GuiGraphics g, int mx, int my, float pt) {
        float renderTime = (float)this.ticksOpen + pt;
        this.drawAnimatedBG(g, BG_0, renderTime * 0.15f, 64);
        this.drawAnimatedBG(g, BG_1, renderTime * 0.35f, 64);
        this.drawAnimatedBG(g, BG_2, renderTime * 0.65f, 64);
        int centerX = this.f_96543_ / 2;
        int left = centerX - 200;
        int top = 50;
        g.m_280509_(centerX - 210, 20, centerX + 210, this.f_96544_ - 40, -872415232);
        g.m_280637_(centerX - 210, 20, 420, this.f_96544_ - 60, 0x44FFFFFF);
        g.m_280488_(this.f_96547_, "\u0e40\u0e27\u0e25\u0e32", left, top, 0xAAAAAA);
        g.m_280488_(this.f_96547_, "\u0e27\u0e34\u0e0a\u0e32", left + 40, top, 0xAAAAAA);
        g.m_280488_(this.f_96547_, "\u0e0a\u0e37\u0e48\u0e2d\u0e04\u0e23\u0e39", left + 135, top, 0xAAAAAA);
        g.m_280488_(this.f_96547_, "ID \u0e2a\u0e01\u0e34\u0e19", left + 198, top, 0xAAAAAA);
        g.m_280488_(this.f_96547_, "\u0e2a\u0e16\u0e32\u0e19\u0e17\u0e35\u0e48", left + 260, top, 0xAAAAAA);
        g.m_280137_(this.f_96547_, "\u0e41\u0e01\u0e49\u0e44\u0e02: " + this.roomId + " (Day " + (this.currentDay + 1) + ")", centerX, 10, 0xFFFFFF);
        super.m_88315_(g, mx, my, pt);
    }

    private void drawAnimatedBG(GuiGraphics g, ResourceLocation tex, float offset, int size) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tex);
        RenderSystem.enableBlend();
        int xOff = (int)(offset % (float)size);
        int yOff = (int)(offset % (float)size);
        for (int x = -xOff; x < this.f_96543_; x += size) {
            for (int y = -yOff; y < this.f_96544_; y += size) {
                g.m_280163_(tex, x, y, 0.0f, 0.0f, size, size, size, size);
            }
        }
    }

    private class ColoredOutlineButton
    extends Button {
        private final int borderColor;

        public ColoredOutlineButton(int x, int y, int w, int h, Component text, int color, Button.OnPress press) {
            super(x, y, w, h, text, press, Button.f_252438_);
            this.borderColor = color;
        }

        public void m_87963_(GuiGraphics g, int mx, int my, float pt) {
            RenderSystem.enableBlend();
            int finalColor = this.m_198029_() ? 0xFF000000 | this.borderColor : 0x44000000 | this.borderColor;
            g.m_280637_(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, finalColor);
            if (this.m_198029_()) {
                g.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, 0x22FFFFFF);
            }
            g.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, -1);
        }
    }
}

