/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import fox.org.mc.backyardlib.client.render.PlayerRenderMode;
import fox.org.mc.backyardlib.config.ModConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class PlayerListScreen
extends Screen {
    private final Screen parent;
    private PlayerSelectionList playerList;
    private EditBox searchBox;
    private int ticksOpen = 0;
    private final int LOADING_TIME = 20;
    private static final ResourceLocation BG_0 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_0.png");
    private static final ResourceLocation BG_1 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_1.png");
    private static final ResourceLocation BG_2 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_2.png");

    public PlayerListScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"\u0e08\u0e31\u0e14\u0e01\u0e32\u0e23\u0e23\u0e32\u0e22\u0e0a\u0e37\u0e48\u0e2d\u0e1c\u0e39\u0e49\u0e40\u0e25\u0e48\u0e19"));
        this.parent = parent;
    }

    protected void m_7856_() {
        this.m_169413_();
        if (this.ticksOpen < 20) {
            return;
        }
        int centerX = this.f_96543_ / 2;
        this.searchBox = new EditBox(this.f_96547_, centerX - 100, 35, 200, 20, (Component)Component.m_237113_((String)"\u0e04\u0e49\u0e19\u0e2b\u0e32\u0e0a\u0e37\u0e48\u0e2d..."));
        this.searchBox.m_94151_(text -> this.playerList.refreshList((String)text));
        this.searchBox.m_94202_(-1);
        this.searchBox.m_94182_(true);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.playerList = new PlayerSelectionList(this.f_96541_, this.f_96543_, this.f_96544_, 65, this.f_96544_ - 45, 30);
        this.m_7787_((GuiEventListener)this.playerList);
        this.m_142416_((GuiEventListener)new ModernWhiteButton(centerX - 100, this.f_96544_ - 35, 200, 20, (Component)Component.m_237113_((String)"\u0e40\u0e2a\u0e23\u0e47\u0e08\u0e2a\u0e34\u0e49\u0e19"), button -> this.m_7379_()));
        this.playerList.refreshList("");
    }

    public void m_86600_() {
        ++this.ticksOpen;
        if (this.ticksOpen == 20) {
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
    }

    public void m_88315_(GuiGraphics g, int mx, int my, float pt) {
        this.m_280273_(g);
        g.m_280509_(0, 0, this.f_96543_, this.f_96544_, -16777216);
        float renderTime = (float)this.ticksOpen + pt;
        RenderSystem.enableBlend();
        this.drawAnimatedBG(g, BG_0, renderTime * 0.15f, 64);
        this.drawAnimatedBG(g, BG_1, renderTime * 0.35f, 64);
        this.drawAnimatedBG(g, BG_2, renderTime * 0.65f, 64);
        if (this.ticksOpen < 20) {
            float progress = renderTime / 20.0f;
            float scale = Mth.m_14179_((float)progress, (float)0.0f, (float)1.0f);
            g.m_280168_().m_85836_();
            g.m_280168_().m_252880_((float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f, 0.0f);
            g.m_280168_().m_85841_(scale, scale, scale);
            g.m_280168_().m_252781_(Axis.f_252403_.m_252977_(renderTime * 18.0f));
            g.m_280168_().m_85849_();
            return;
        }
        int centerX = this.f_96543_ / 2;
        g.m_280509_(centerX - 150, 20, centerX + 150, this.f_96544_ - 20, -671088640);
        g.m_280637_(centerX - 150, 20, 300, this.f_96544_ - 40, 0x44FFFFFF);
        this.playerList.m_88315_(g, mx, my, pt);
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 22, -1);
        if (this.searchBox != null) {
            this.searchBox.m_88315_(g, mx, my, pt);
        }
        super.m_88315_(g, mx, my, pt);
    }

    private void drawAnimatedBG(GuiGraphics g, ResourceLocation tex, float offset, int size) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tex);
        int xOff = (int)(offset % (float)size);
        int yOff = (int)(offset % (float)size);
        for (int x = -xOff; x < this.f_96543_; x += size) {
            for (int y = -yOff; y < this.f_96544_; y += size) {
                g.m_280163_(tex, x, y, 0.0f, 0.0f, size, size, size, size);
            }
        }
    }

    public void m_7379_() {
        ModConfiguration.SPEC.save();
        this.f_96541_.m_91152_(this.parent);
    }

    class PlayerSelectionList
    extends ObjectSelectionList<PlayerEntry> {
        public PlayerSelectionList(Minecraft mc, int width, int height, int y0, int y1, int itemHeight) {
            super(mc, width, height, y0, y1, itemHeight);
            this.m_93488_(false);
            this.m_93496_(false);
        }

        public void refreshList(String filter) {
            this.m_93516_();
            if (this.f_93386_.m_91403_() == null || this.f_93386_.f_91074_ == null) {
                return;
            }
            UUID myUUID = this.f_93386_.f_91074_.m_20148_();
            for (PlayerInfo info : this.f_93386_.m_91403_().m_105142_()) {
                if (info.m_105312_().getId().equals(myUUID)) continue;
                String name = info.m_105312_().getName();
                if (!filter.isEmpty() && !name.toLowerCase(Locale.ROOT).contains(filter.toLowerCase(Locale.ROOT))) continue;
                this.m_7085_((AbstractSelectionList.Entry)new PlayerEntry(info));
            }
        }

        class PlayerEntry
        extends ObjectSelectionList.Entry<PlayerEntry> {
            private final PlayerInfo playerInfo;
            private final ModernWhiteButton modeButton;

            public PlayerEntry(PlayerInfo info) {
                this.playerInfo = info;
                UUID uuid = info.m_105312_().getId();
                this.modeButton = new ModernWhiteButton(0, 0, 110, 20, this.getButtonText(uuid), btn -> {
                    PlayerRenderMode nextMode = this.getCurrentMode(uuid).next();
                    this.setPlayerMode(uuid, nextMode);
                    btn.m_93666_(this.getButtonText(uuid));
                    this.updateTooltip(btn, nextMode);
                });
                this.updateTooltip(this.modeButton, this.getCurrentMode(uuid));
            }

            private PlayerRenderMode getCurrentMode(UUID uuid) {
                for (String entry : (List)ModConfiguration.PLAYER_OVERRIDES.get()) {
                    if (!entry.startsWith(uuid.toString())) continue;
                    try {
                        return PlayerRenderMode.valueOf(entry.split(":")[1]);
                    }
                    catch (Exception e) {
                        return PlayerRenderMode.AUTO;
                    }
                }
                return PlayerRenderMode.AUTO;
            }

            private void setPlayerMode(UUID uuid, PlayerRenderMode mode) {
                ArrayList<Object> list = new ArrayList<Object>((Collection)ModConfiguration.PLAYER_OVERRIDES.get());
                list.removeIf(s -> s.startsWith(uuid.toString()));
                if (mode != PlayerRenderMode.AUTO) {
                    list.add(uuid.toString() + ":" + mode.name());
                }
                ModConfiguration.PLAYER_OVERRIDES.set(list);
            }

            private Component getButtonText(UUID uuid) {
                PlayerRenderMode mode = this.getCurrentMode(uuid);
                return switch (mode) {
                    case PlayerRenderMode.FORCE_VISIBLE -> Component.m_237113_((String)"\u0e40\u0e2b\u0e47\u0e19\u0e15\u0e25\u0e2d\u0e14 (3D)").m_130940_(ChatFormatting.GREEN);
                    case PlayerRenderMode.FORCE_HIDDEN -> Component.m_237113_((String)"\u0e0b\u0e48\u0e2d\u0e19\u0e15\u0e25\u0e2d\u0e14 (\u0e40\u0e07\u0e32)").m_130940_(ChatFormatting.RED);
                    default -> Component.m_237113_((String)"\u0e2d\u0e31\u0e15\u0e42\u0e19\u0e21\u0e31\u0e15\u0e34 (AUTO)").m_130940_(ChatFormatting.GRAY);
                };
            }

            private void updateTooltip(Button btn, PlayerRenderMode mode) {
                String txt = switch (mode) {
                    case PlayerRenderMode.FORCE_VISIBLE -> "\u0e41\u0e2a\u0e14\u0e07\u0e15\u0e31\u0e27 3D \u0e40\u0e2a\u0e21\u0e2d \u0e41\u0e21\u0e49\u0e04\u0e19\u0e08\u0e30\u0e40\u0e22\u0e2d\u0e30";
                    case PlayerRenderMode.FORCE_HIDDEN -> "\u0e41\u0e2a\u0e14\u0e07\u0e15\u0e31\u0e27\u0e40\u0e1b\u0e47\u0e19\u0e23\u0e48\u0e32\u0e07\u0e40\u0e07\u0e32\u0e2a\u0e35\u0e14\u0e33\u0e40\u0e2a\u0e21\u0e2d";
                    default -> "\u0e41\u0e2a\u0e14\u0e07\u0e1c\u0e25\u0e15\u0e32\u0e21\u0e08\u0e33\u0e19\u0e27\u0e19\u0e08\u0e33\u0e01\u0e31\u0e14\u0e17\u0e35\u0e48\u0e15\u0e31\u0e49\u0e07\u0e44\u0e27\u0e49";
                };
                btn.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)txt)));
            }

            public void m_6311_(GuiGraphics gui, int index, int top, int left, int width, int height, int mx, int my, boolean h, float pt) {
                ResourceLocation skin = this.playerInfo.m_105337_();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)skin);
                gui.m_280411_(skin, left + 5, top + 5, 20, 20, 8.0f, 8.0f, 8, 8, 64, 64);
                gui.m_280411_(skin, left + 5, top + 5, 20, 20, 40.0f, 8.0f, 8, 8, 64, 64);
                gui.m_280488_(Minecraft.m_91087_().f_91062_, this.playerInfo.m_105312_().getName(), left + 30, top + 10, 0xFFFFFF);
                this.modeButton.m_252865_(left + width - 115);
                this.modeButton.m_253211_(top + 5);
                this.modeButton.m_88315_(gui, mx, my, pt);
            }

            public boolean m_6375_(double x, double y, int b) {
                return this.modeButton.m_6375_(x, y, b);
            }

            public Component m_142172_() {
                return Component.m_237113_((String)this.playerInfo.m_105312_().getName());
            }
        }
    }

    private class ModernWhiteButton
    extends Button {
        public ModernWhiteButton(int x, int y, int w, int h, Component text, Button.OnPress press) {
            super(x, y, w, h, text, press, f_252438_);
        }

        public void m_87963_(GuiGraphics g, int mx, int my, float pt) {
            RenderSystem.enableBlend();
            String txt = this.m_6035_().getString();
            int borderColor = -1426063361;
            if (txt.contains("\u0e0b\u0e48\u0e2d\u0e19") || txt.contains("\u0e41\u0e1a\u0e19")) {
                borderColor = this.m_198029_() ? -1618884 : -1427682244;
            } else if (txt.contains("\u0e40\u0e2b\u0e47\u0e19\u0e15\u0e25\u0e2d\u0e14")) {
                borderColor = this.m_198029_() ? -13710223 : -1439773583;
            } else if (txt.contains("\u0e2d\u0e31\u0e15\u0e42\u0e19\u0e21\u0e31\u0e15\u0e34") || txt.equals("\u0e40\u0e2a\u0e23\u0e47\u0e08\u0e2a\u0e34\u0e49\u0e19")) {
                borderColor = this.m_198029_() ? -13330213 : -1439393573;
            } else if (this.m_198029_()) {
                borderColor = -1;
            }
            g.m_280637_(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, borderColor);
            g.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, -1);
        }
    }
}

