/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import fox.org.mc.backyardlib.client.gui.AdminDashboardScreen;
import fox.org.mc.backyardlib.client.gui.BackyardSettingsScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="backyardlib", value={Dist.CLIENT})
public class InventoryButtonHandler {
    private static final ResourceLocation SETTINGS_ICON = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/setting.png");
    private static final ResourceLocation ADMIN_ICON = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/setting_admin.png");

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91072_ == null) {
            return;
        }
        boolean isInv = event.getScreen() instanceof InventoryScreen;
        boolean isCreative = event.getScreen() instanceof CreativeModeInventoryScreen;
        if (isInv || isCreative) {
            boolean canAccessAdmin = mc.f_91074_.m_20310_(2) || mc.f_91072_.m_105295_() == GameType.CREATIVE || mc.f_91072_.m_105295_() == GameType.SPECTATOR;
            int screenWidth = event.getScreen().f_96543_;
            int screenHeight = event.getScreen().f_96544_;
            int btnSize = 22;
            int margin = 5;
            int x = screenWidth - btnSize - margin;
            int y = screenHeight - btnSize - margin;
            event.addListener((GuiEventListener)new AnimatedLogoButton(x, y, btnSize, btnSize, SETTINGS_ICON, b -> mc.m_91152_((Screen)new BackyardSettingsScreen()), (Component)Component.m_237113_((String)"\u0e15\u0e31\u0e49\u0e07\u0e04\u0e48\u0e32\u0e21\u0e47\u0e2d\u0e14 Backyard")));
            if (canAccessAdmin) {
                event.addListener((GuiEventListener)new AnimatedLogoButton(x, y - btnSize - 2, btnSize, btnSize, ADMIN_ICON, b -> {
                    Screen patt4833$temp = event.getScreen();
                    if (patt4833$temp instanceof CreativeModeInventoryScreen) {
                        CreativeModeInventoryScreen creative = (CreativeModeInventoryScreen)patt4833$temp;
                        mc.m_91152_((Screen)new AdminDashboardScreen((Screen)creative));
                    } else {
                        Screen patt5021$temp = event.getScreen();
                        if (patt5021$temp instanceof InventoryScreen) {
                            InventoryScreen survival = (InventoryScreen)patt5021$temp;
                            mc.m_91152_((Screen)new AdminDashboardScreen((Screen)survival));
                        }
                    }
                }, (Component)Component.m_237113_((String)"\u0e23\u0e30\u0e1a\u0e1a\u0e08\u0e31\u0e14\u0e01\u0e32\u0e23\u0e41\u0e2d\u0e14\u0e21\u0e34\u0e19")));
            }
        }
    }

    private static class AnimatedLogoButton
    extends Button {
        private final ResourceLocation icon;
        private float hoverScale = 0.0f;

        public AnimatedLogoButton(int x, int y, int w, int h, ResourceLocation icon, Button.OnPress press, Component tooltipMsg) {
            super(x, y, w, h, (Component)Component.m_237119_(), press, f_252438_);
            this.icon = icon;
            this.m_257544_(Tooltip.m_257550_((Component)tooltipMsg));
        }

        public void m_87963_(GuiGraphics g, int mx, int my, float pt) {
            Minecraft mc = Minecraft.m_91087_();
            float delta = mc.m_91297_();
            this.hoverScale = this.m_198029_() ? Math.min(1.0f, this.hoverScale + delta * 0.2f) : Math.max(0.0f, this.hoverScale - delta * 0.2f);
            float scale = 1.0f + this.hoverScale * 0.3f;
            float rotation = mc.f_91073_ != null ? ((float)mc.f_91073_.m_46467_() + pt) * 2.5f : 0.0f;
            int centerX = this.m_252754_() + this.f_93618_ / 2;
            int centerY = this.m_252907_() + this.f_93619_ / 2;
            int bgColor = this.m_198029_() ? -1724986255 : 0x55000000;
            g.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, bgColor);
            g.m_280637_(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, -1);
            g.m_280168_().m_85836_();
            g.m_280168_().m_252880_((float)centerX, (float)centerY, 0.0f);
            g.m_280168_().m_85841_(scale, scale, 1.0f);
            g.m_280168_().m_252781_(Axis.f_252403_.m_252977_(rotation));
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            g.m_280163_(this.icon, -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
            RenderSystem.disableBlend();
            g.m_280168_().m_85849_();
        }
    }
}

