/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import fox.org.mc.backyardlib.client.ModKeyBindings;
import fox.org.mc.backyardlib.config.ModConfiguration;
import fox.org.mc.backyardlib.teams.BackyardToast;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.gui.widget.ForgeSlider;

public class BackyardSettingsScreen
extends Screen {
    public static KeyMapping ZOOM_KEY = ModKeyBindings.ZOOM_KEY;
    private static final ResourceLocation LOGO_URL = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/server_logo.png");
    private static final ResourceLocation BG_0 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_0.png");
    private static final ResourceLocation BG_1 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_1.png");
    private static final ResourceLocation BG_2 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_2.png");
    private int currentTab = 0;
    private int ticksOpen = 0;
    private final int LOADING_TIME = 20;
    private double tempZoomDist;
    private double tempSmooth;
    private double tempRotationSmooth;
    private int tempMaxRender;
    private boolean tempEnableRenderDistance;
    private double tempRenderDistance;
    private boolean tempHideHud;
    private boolean tempShowNames;
    private Button activeKeyButton = null;

    public BackyardSettingsScreen() {
        super((Component)Component.m_237113_((String)"BACKYARD SETTINGS"));
        this.refreshTempValues();
    }

    private void refreshTempValues() {
        this.tempZoomDist = (Double)ModConfiguration.ZOOM_MULTIPLIER.get();
        this.tempSmooth = (Double)ModConfiguration.ZOOM_SMOOTHNESS.get();
        this.tempRotationSmooth = (Double)ModConfiguration.ROTATION_SMOOTHNESS.get();
        this.tempMaxRender = (Integer)ModConfiguration.MAX_RENDER_COUNT.get();
        this.tempEnableRenderDistance = (Boolean)ModConfiguration.ENABLE_RENDER_DISTANCE.get();
        this.tempRenderDistance = (Double)ModConfiguration.RENDER_DISTANCE.get();
        this.tempHideHud = (Boolean)ModConfiguration.HIDE_HUD_ONLY.get();
        this.tempShowNames = (Boolean)ModConfiguration.SHOW_SHADOW_NAMES.get();
    }

    public int getCurrentTab() {
        return this.currentTab;
    }

    public boolean isTempRenderDistanceEnabled() {
        return this.tempEnableRenderDistance;
    }

    public double getTempRenderDistance() {
        return this.tempRenderDistance;
    }

    private void popup(String title, String message) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new BackyardToast((Component)Component.m_237113_((String)title), (Component)Component.m_237113_((String)message)));
    }

    protected void m_7856_() {
        this.m_169413_();
        if (this.activeKeyButton != null) {
            this.activeKeyButton.m_93666_((Component)Component.m_237113_((String)("\u0e1b\u0e38\u0e48\u0e21\u0e01\u0e14\u0e0b\u0e39\u0e21: " + ZOOM_KEY.m_90863_().getString())).m_130940_(ChatFormatting.GOLD));
            this.activeKeyButton = null;
        }
        if (this.ticksOpen < 20) {
            return;
        }
        int centerX = this.f_96543_ / 2;
        int panelX = centerX - 120;
        int startY = 80;
        int saveY = this.f_96544_ - 75;
        this.addTabBtnFixed(centerX - 75, 15, "\u0e01\u0e32\u0e23\u0e0b\u0e39\u0e21", 0);
        this.addTabBtnFixed(centerX - 25, 15, "\u0e2b\u0e19\u0e49\u0e32\u0e08\u0e2d", 1);
        this.addTabBtnFixed(centerX + 25, 15, "\u0e25\u0e14\u0e41\u0e25\u0e04", 2);
        if (this.currentTab == 0) {
            this.m_142416_((GuiEventListener)new WhiteSlider(panelX, startY, 240, 18, (Component)Component.m_237113_((String)"\u0e23\u0e30\u0e22\u0e30\u0e0b\u0e39\u0e21: "), 0.1, 0.8, this.tempZoomDist, 0.05){

                protected void m_5697_() {
                    BackyardSettingsScreen.this.tempZoomDist = this.getValue();
                }
            });
            this.m_142416_((GuiEventListener)new WhiteSlider(panelX, startY + 22, 240, 18, (Component)Component.m_237113_((String)"\u0e04\u0e27\u0e32\u0e21\u0e19\u0e38\u0e48\u0e21\u0e19\u0e27\u0e25: "), 0.01, 0.3, this.tempSmooth, 0.01){

                protected void m_5697_() {
                    BackyardSettingsScreen.this.tempSmooth = this.getValue();
                }
            });
            this.m_142416_((GuiEventListener)new WhiteSlider(panelX, startY + 44, 240, 18, (Component)Component.m_237113_((String)"\u0e04\u0e27\u0e32\u0e21\u0e2b\u0e19\u0e48\u0e27\u0e07\u0e40\u0e21\u0e32\u0e2a\u0e4c: "), 0.0, 1.0, this.tempRotationSmooth, 0.1){

                protected void m_5697_() {
                    BackyardSettingsScreen.this.tempRotationSmooth = this.getValue();
                }
            });
            String keyName = ZOOM_KEY != null ? ZOOM_KEY.m_90863_().getString() : "Unknown";
            this.m_142416_((GuiEventListener)new ModernWhiteButton(panelX, startY + 66, 240, 20, (Component)Component.m_237113_((String)("\u0e1b\u0e38\u0e48\u0e21\u0e01\u0e14\u0e0b\u0e39\u0e21: " + keyName)).m_130940_(ChatFormatting.GOLD), b -> {
                this.activeKeyButton = b;
                b.m_93666_((Component)Component.m_237113_((String)"> \u0e01\u0e14\u0e1b\u0e38\u0e48\u0e21\u0e17\u0e35\u0e48\u0e15\u0e49\u0e2d\u0e07\u0e01\u0e32\u0e23 <").m_130940_(ChatFormatting.YELLOW));
            }));
            this.m_142416_((GuiEventListener)new ModernWhiteButton(panelX + 70, saveY, 100, 20, (Component)Component.m_237113_((String)"\u0e1a\u0e31\u0e19\u0e17\u0e36\u0e01\u0e01\u0e32\u0e23\u0e0b\u0e39\u0e21"), b -> this.saveZoomTab()));
        } else if (this.currentTab == 1) {
            MutableComponent hudTxt = Component.m_237113_((String)"\u0e42\u0e2b\u0e21\u0e14\u0e0b\u0e48\u0e2d\u0e19 HUD: ").m_7220_((Component)(this.tempHideHud ? Component.m_237113_((String)"\u0e40\u0e1b\u0e34\u0e14").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"\u0e1b\u0e34\u0e14").m_130940_(ChatFormatting.RED)));
            this.m_142416_((GuiEventListener)new ModernWhiteButton(panelX, startY, 240, 20, (Component)hudTxt, b -> {
                this.tempHideHud = !this.tempHideHud;
                this.m_7856_();
            }));
            this.m_142416_((GuiEventListener)new ModernWhiteButton(panelX + 70, saveY, 100, 20, (Component)Component.m_237113_((String)"\u0e1a\u0e31\u0e19\u0e17\u0e36\u0e01\u0e2b\u0e19\u0e49\u0e32\u0e08\u0e2d"), b -> this.saveHudTab()));
        } else if (this.currentTab == 2) {
            this.m_142416_((GuiEventListener)new WhiteSlider(panelX, startY, 240, 18, (Component)Component.m_237113_((String)"\u0e08\u0e33\u0e01\u0e31\u0e14\u0e04\u0e19 3D: "), 0.0, 60.0, this.tempMaxRender, 1.0){

                protected void m_5697_() {
                    BackyardSettingsScreen.this.tempMaxRender = this.getValueInt();
                }
            });
            MutableComponent distTxt = Component.m_237113_((String)"\u0e08\u0e33\u0e01\u0e31\u0e14\u0e23\u0e30\u0e22\u0e30\u0e21\u0e2d\u0e07\u0e40\u0e2b\u0e47\u0e19: ").m_7220_((Component)(this.tempEnableRenderDistance ? Component.m_237113_((String)"\u0e40\u0e1b\u0e34\u0e14").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"\u0e1b\u0e34\u0e14").m_130940_(ChatFormatting.RED)));
            this.m_142416_((GuiEventListener)new ModernWhiteButton(panelX, startY + 22, 240, 20, (Component)distTxt, b -> {
                this.tempEnableRenderDistance = !this.tempEnableRenderDistance;
                this.m_7856_();
            }));
            if (this.tempEnableRenderDistance) {
                this.m_142416_((GuiEventListener)new WhiteSlider(panelX, startY + 44, 240, 18, (Component)Component.m_237113_((String)"\u0e23\u0e30\u0e22\u0e30\u0e42\u0e2b\u0e25\u0e14\u0e1c\u0e39\u0e49\u0e40\u0e25\u0e48\u0e19: "), 5.0, 128.0, this.tempRenderDistance, 1.0){

                    protected void m_5697_() {
                        BackyardSettingsScreen.this.tempRenderDistance = this.getValue();
                    }
                });
            }
            this.m_142416_((GuiEventListener)new ModernWhiteButton(panelX + 70, saveY, 100, 20, (Component)Component.m_237113_((String)"\u0e1a\u0e31\u0e19\u0e17\u0e36\u0e01\u0e01\u0e32\u0e23\u0e25\u0e14\u0e41\u0e25\u0e04"), b -> this.saveOptiTab()));
        }
        this.m_142416_((GuiEventListener)new ModernWhiteButton(centerX - 50, this.f_96544_ - 35, 100, 20, (Component)Component.m_237113_((String)"\u0e1b\u0e34\u0e14\u0e2b\u0e19\u0e49\u0e32\u0e15\u0e48\u0e32\u0e07"), b -> this.m_7379_()));
    }

    private void saveZoomTab() {
        ModConfiguration.ZOOM_MULTIPLIER.set((Object)this.tempZoomDist);
        ModConfiguration.ZOOM_SMOOTHNESS.set((Object)this.tempSmooth);
        ModConfiguration.ROTATION_SMOOTHNESS.set((Object)this.tempRotationSmooth);
        this.finishSave("\u0e01\u0e32\u0e23\u0e0b\u0e39\u0e21");
        Minecraft.m_91087_().f_91066_.m_92169_();
    }

    private void saveHudTab() {
        ModConfiguration.HIDE_HUD_ONLY.set((Object)this.tempHideHud);
        this.finishSave("\u0e2b\u0e19\u0e49\u0e32\u0e08\u0e2d");
    }

    private void saveOptiTab() {
        ModConfiguration.MAX_RENDER_COUNT.set((Object)this.tempMaxRender);
        ModConfiguration.ENABLE_RENDER_DISTANCE.set((Object)this.tempEnableRenderDistance);
        ModConfiguration.RENDER_DISTANCE.set((Object)this.tempRenderDistance);
        this.finishSave("\u0e01\u0e32\u0e23\u0e25\u0e14\u0e41\u0e25\u0e04");
    }

    private void finishSave(String tabName) {
        ModConfiguration.SPEC.save();
        this.popup("\u0e1a\u0e31\u0e19\u0e17\u0e36\u0e01\u0e2a\u0e33\u0e40\u0e23\u0e47\u0e08", "\u0e15\u0e31\u0e49\u0e07\u0e04\u0e48\u0e32 " + tabName + " \u0e40\u0e23\u0e35\u0e22\u0e1a\u0e23\u0e49\u0e2d\u0e22\u0e41\u0e25\u0e49\u0e27");
    }

    public void m_88315_(GuiGraphics g, int mx, int my, float pt) {
        this.m_280273_(g);
        g.m_280509_(0, 0, this.f_96543_, this.f_96544_, -16777216);
        float renderTime = (float)this.ticksOpen + pt;
        RenderSystem.enableBlend();
        this.drawAnimatedBG(g, BG_0, renderTime * 0.15f, 64);
        this.drawAnimatedBG(g, BG_1, renderTime * 0.35f, 64);
        this.drawAnimatedBG(g, BG_2, renderTime * 0.65f, 64);
        if (this.ticksOpen < 20) {
            float progress = renderTime / 20.0f;
            float scale = Mth.m_14179_((float)progress, (float)0.0f, (float)1.0f);
            g.m_280168_().m_85836_();
            g.m_280168_().m_252880_((float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f, 0.0f);
            g.m_280168_().m_85841_(scale, scale, scale);
            g.m_280168_().m_252781_(Axis.f_252403_.m_252977_(renderTime * 18.0f));
            g.m_280163_(LOGO_URL, -50, -50, 0.0f, 0.0f, 100, 100, 100, 100);
            g.m_280168_().m_85849_();
            return;
        }
        int centerX = this.f_96543_ / 2;
        g.m_280509_(centerX - 135, 40, centerX + 135, this.f_96544_ - 50, -671088640);
        g.m_280637_(centerX - 135, 40, 270, this.f_96544_ - 90, 0x44FFFFFF);
        g.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)"\u0e15\u0e31\u0e49\u0e07\u0e04\u0e48\u0e32\u0e1c\u0e39\u0e49\u0e43\u0e0a\u0e49\u0e07\u0e32\u0e19"), centerX, 48, -1);
        super.m_88315_(g, mx, my, pt);
    }

    private void addTabBtnFixed(int x, int y, String label, int id) {
        this.m_142416_((GuiEventListener)new CustomTabButton(x, y, 48, 20, (Component)Component.m_237113_((String)label), id));
    }

    private void drawAnimatedBG(GuiGraphics g, ResourceLocation tex, float offset, int size) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tex);
        int xOff = (int)(offset % (float)size);
        int yOff = (int)(offset % (float)size);
        for (int x = -xOff; x < this.f_96543_; x += size) {
            for (int y = -yOff; y < this.f_96544_; y += size) {
                g.m_280163_(tex, x, y, 0.0f, 0.0f, size, size, size, size);
            }
        }
    }

    public void m_86600_() {
        ++this.ticksOpen;
        if (this.ticksOpen == 20) {
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.activeKeyButton != null && ZOOM_KEY != null) {
            if (keyCode == 256) {
                this.activeKeyButton = null;
                this.m_7856_();
                return true;
            }
            ZOOM_KEY.m_90848_(InputConstants.m_84827_((int)keyCode, (int)scanCode));
            KeyMapping.m_90854_();
            this.activeKeyButton = null;
            this.m_7856_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mx, double my, int btn) {
        if (this.activeKeyButton != null && ZOOM_KEY != null) {
            ZOOM_KEY.m_90848_(InputConstants.Type.MOUSE.m_84895_(btn));
            KeyMapping.m_90854_();
            this.activeKeyButton = null;
            this.m_7856_();
            return true;
        }
        return super.m_6375_(mx, my, btn);
    }

    private class ModernWhiteButton
    extends Button {
        public ModernWhiteButton(int x, int y, int w, int h, Component text, Button.OnPress press) {
            super(x, y, w, h, text, press, Button.f_252438_);
        }

        public void m_87963_(GuiGraphics g, int mx, int my, float pt) {
            RenderSystem.enableBlend();
            String label = this.m_6035_().getString();
            int borderColor = 0x44FFFFFF;
            if (label.contains("\u0e40\u0e1b\u0e34\u0e14") || label.contains("ON") || label.contains("\u0e1a\u0e31\u0e19\u0e17\u0e36\u0e01")) {
                borderColor = this.m_198029_() ? -13710223 : -1439773583;
            } else if (label.contains("\u0e1b\u0e34\u0e14") || label.contains("OFF")) {
                borderColor = this.m_198029_() ? -1618884 : -1427682244;
            } else if (this.m_198029_()) {
                borderColor = -855638017;
            }
            if (this == BackyardSettingsScreen.this.activeKeyButton) {
                borderColor = -932849;
            }
            g.m_280637_(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, borderColor);
            int textColor = this == BackyardSettingsScreen.this.activeKeyButton ? -932849 : -1;
            g.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, textColor);
        }
    }

    private class CustomTabButton
    extends Button {
        private final int tabId;

        public CustomTabButton(int x, int y, int w, int h, Component text, int id) {
            super(x, y, w, h, text, b -> {
                BackyardSettingsScreen screen = (BackyardSettingsScreen)Minecraft.m_91087_().f_91080_;
                if (screen != null) {
                    screen.currentTab = id;
                    screen.m_6575_(screen.f_96541_, screen.f_96543_, screen.f_96544_);
                }
            }, Button.f_252438_);
            this.tabId = id;
        }

        public void m_87963_(GuiGraphics g, int mx, int my, float pt) {
            int textColor;
            boolean active;
            boolean bl = active = BackyardSettingsScreen.this.currentTab == this.tabId;
            int n = active ? -1 : (textColor = this.f_93622_ ? -570425345 : -1996488705);
            if (active) {
                g.m_280509_(this.m_252754_() + 4, this.m_252907_() + this.f_93619_ - 2, this.m_252754_() + this.f_93618_ - 4, this.m_252907_() + this.f_93619_, -13710223);
            }
            g.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, textColor);
        }
    }

    private class WhiteSlider
    extends ForgeSlider {
        public WhiteSlider(int x, int y, int w, int h, Component prefix, double min, double max, double current, double step) {
            super(x, y, w, h, prefix, (Component)Component.m_237119_(), min, max, current, step, 2, true);
        }

        public void m_87963_(GuiGraphics g, int mx, int my, float pt) {
            g.m_280637_(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, 0x44FFFFFF);
            int handleX = (int)(this.f_93577_ * (double)(this.f_93618_ - 8));
            g.m_280509_(this.m_252754_() + handleX, this.m_252907_(), this.m_252754_() + handleX + 8, this.m_252907_() + this.f_93619_, -1);
            g.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, -1);
        }
    }
}

