/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import fox.org.mc.backyardlib.config.ModConfiguration;
import fox.org.mc.backyardlib.item.ModItems;
import fox.org.mc.backyardlib.network.BackyardNetwork;
import fox.org.mc.backyardlib.network.player.PlayerPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.gui.widget.ForgeSlider;

public class BackyardScaleScreen
extends Screen {
    private static final ResourceLocation LOGO_URL = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/server_logo.png");
    private static final ResourceLocation BG_0 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_0.png");
    private static final ResourceLocation BG_1 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_1.png");
    private static final ResourceLocation BG_2 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_2.png");
    private double tempScale = (Double)ModConfiguration.PLAYER_SCALE.get();
    private int ticksOpen = 0;
    private final int LOADING_TIME = 20;

    public BackyardScaleScreen() {
        super((Component)Component.m_237113_((String)"\u0e23\u0e30\u0e1a\u0e1a\u0e1b\u0e23\u0e31\u0e1a\u0e2a\u0e48\u0e27\u0e19\u0e2a\u0e39\u0e07\u0e15\u0e31\u0e27\u0e25\u0e30\u0e04\u0e23"));
    }

    protected void m_7856_() {
        this.m_169413_();
        if (this.ticksOpen < 20) {
            return;
        }
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.m_142416_((GuiEventListener)new WhiteSlider(centerX - 100, centerY - 10, 200, 20, (Component)Component.m_237113_((String)"\u0e02\u0e19\u0e32\u0e14\u0e15\u0e31\u0e27: "), 0.8, 1.3, this.tempScale, 0.05){

            protected void m_5697_() {
                BackyardScaleScreen.this.tempScale = this.getValue();
            }
        });
        this.m_142416_((GuiEventListener)new ModernWhiteButton(centerX - 100, centerY + 20, 200, 20, (Component)Component.m_237113_((String)"\u0e1a\u0e31\u0e19\u0e17\u0e36\u0e01\u0e41\u0e25\u0e30\u0e43\u0e0a\u0e49\u0e1a\u0e31\u0e15\u0e23"), b -> this.handleSave()));
        this.m_142416_((GuiEventListener)new ModernWhiteButton(centerX - 100, centerY + 45, 200, 20, (Component)Component.m_237113_((String)"\u0e22\u0e01\u0e40\u0e25\u0e34\u0e01"), b -> this.m_7379_()));
    }

    private void handleSave() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        boolean hasItem = mc.f_91074_.m_20310_(2);
        if (!hasItem) {
            for (int i = 0; i < mc.f_91074_.m_150109_().m_6643_(); ++i) {
                if (mc.f_91074_.m_150109_().m_8020_(i).m_41720_() != ModItems.HEIGHT_CHANGER.get()) continue;
                hasItem = true;
                break;
            }
        }
        if (!hasItem) {
            mc.f_91074_.m_5661_((Component)Component.m_237113_((String)"\u00a7c[!] \u0e04\u0e38\u0e13\u0e44\u0e21\u0e48\u0e21\u0e35\u0e1a\u0e31\u0e15\u0e23\u0e40\u0e1b\u0e25\u0e35\u0e48\u0e22\u0e19\u0e2a\u0e48\u0e27\u0e19\u0e2a\u0e39\u0e07"), true);
            this.m_7379_();
            return;
        }
        BackyardNetwork.sendToServer(new PlayerPacket(this.tempScale));
        ModConfiguration.PLAYER_SCALE.set((Object)this.tempScale);
        ModConfiguration.SPEC.save();
        this.m_7379_();
    }

    public void m_88315_(GuiGraphics g, int mx, int my, float pt) {
        this.m_280273_(g);
        g.m_280509_(0, 0, this.f_96543_, this.f_96544_, -16777216);
        float renderTime = (float)this.ticksOpen + pt;
        RenderSystem.enableBlend();
        this.drawAnimatedBG(g, BG_0, renderTime * 0.15f, 64);
        this.drawAnimatedBG(g, BG_1, renderTime * 0.35f, 64);
        this.drawAnimatedBG(g, BG_2, renderTime * 0.65f, 64);
        if (this.ticksOpen < 20) {
            float progress = renderTime / 20.0f;
            float scale = Mth.m_14179_((float)progress, (float)0.0f, (float)1.0f);
            g.m_280168_().m_85836_();
            g.m_280168_().m_252880_((float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f, 0.0f);
            g.m_280168_().m_85841_(scale, scale, scale);
            g.m_280168_().m_252781_(Axis.f_252403_.m_252977_(renderTime * 18.0f));
            g.m_280163_(LOGO_URL, -50, -50, 0.0f, 0.0f, 100, 100, 100, 100);
            g.m_280168_().m_85849_();
            return;
        }
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        g.m_280509_(centerX - 120, centerY - 80, centerX + 120, centerY + 80, -671088640);
        g.m_280637_(centerX - 120, centerY - 80, 240, 160, 0x44FFFFFF);
        g.m_280653_(this.f_96547_, this.f_96539_, centerX, centerY - 70, -1);
        g.m_280203_(new ItemStack((ItemLike)ModItems.HEIGHT_CHANGER.get()), centerX - 8, centerY - 50);
        g.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)"\u0e15\u0e49\u0e2d\u0e07\u0e43\u0e0a\u0e49\u0e1a\u0e31\u0e15\u0e23 1 \u0e43\u0e1a").m_130940_(ChatFormatting.GRAY), centerX, centerY - 30, 0xAAAAAA);
        super.m_88315_(g, mx, my, pt);
    }

    private void drawAnimatedBG(GuiGraphics g, ResourceLocation tex, float offset, int size) {
        int xOff = (int)(offset % (float)size);
        int yOff = (int)(offset % (float)size);
        for (int x = -xOff; x < this.f_96543_; x += size) {
            for (int y = -yOff; y < this.f_96544_; y += size) {
                g.m_280163_(tex, x, y, 0.0f, 0.0f, size, size, size, size);
            }
        }
    }

    public void m_86600_() {
        ++this.ticksOpen;
        if (this.ticksOpen == 20) {
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
    }

    private class ModernWhiteButton
    extends Button {
        public ModernWhiteButton(int x, int y, int w, int h, Component text, Button.OnPress press) {
            super(x, y, w, h, text, press, Button.f_252438_);
        }

        public void m_87963_(GuiGraphics g, int mx, int my, float pt) {
            int borderColor;
            int n = borderColor = this.m_198029_() ? -13710223 : -1426063361;
            if (this.m_6035_().getString().contains("\u0e22\u0e01\u0e40\u0e25\u0e34\u0e01")) {
                borderColor = this.m_198029_() ? -1618884 : -1426063361;
            }
            g.m_280637_(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, borderColor);
            g.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, -1);
        }
    }

    private class WhiteSlider
    extends ForgeSlider {
        public WhiteSlider(int x, int y, int w, int h, Component prefix, double min, double max, double current, double step) {
            super(x, y, w, h, prefix, (Component)Component.m_237119_(), min, max, current, step, 2, true);
        }

        public void m_87963_(GuiGraphics g, int mx, int my, float pt) {
            g.m_280637_(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, 0x44FFFFFF);
            int handleX = (int)(this.f_93577_ * (double)(this.f_93618_ - 8));
            g.m_280509_(this.m_252754_() + handleX, this.m_252907_(), this.m_252754_() + handleX + 8, this.m_252907_() + this.f_93619_, -1);
            g.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, -1);
        }
    }
}

