/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import fox.org.mc.backyardlib.config.ModConfiguration;
import fox.org.mc.backyardlib.network.BackyardNetwork;
import fox.org.mc.backyardlib.network.admin.AdminOpenInvPacket;
import fox.org.mc.backyardlib.network.admin.AdminPacket;
import fox.org.mc.backyardlib.network.admin.GlobalSpawnPacket;
import fox.org.mc.backyardlib.teams.BackyardToast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class AdminDashboardScreen
extends Screen {
    private final Screen lastScreen;
    private int currentTab = 0;
    private static final ResourceLocation LOGO_URL = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/server_logo.png");
    private static final ResourceLocation BG_0 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_0.png");
    private static final ResourceLocation BG_1 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_1.png");
    private static final ResourceLocation BG_2 = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/background_2.png");
    private int ticksOpen = 0;
    private final int LOADING_TIME = 20;
    private EditBox realStartBox;
    private EditBox realEndBox;
    private EditBox searchBox;
    private EditBox whitelistAddBox;
    private boolean tempAdminMode;
    private boolean tempLockInventory;
    private boolean tempEnableTime;
    private boolean tempIsWhitelistMode;
    private boolean tempEnableThirst;
    private double tempRealStart;
    private double tempRealEnd;
    private List<String> tempSpawnList;
    private List<String> tempBannedItems;
    private List<String> serverWhitelist = new ArrayList<String>();
    private EntitySelectionList entityList;
    private PlayerList playerListWidget;
    private ItemSelectionList itemListWidget;
    private WhitelistList whitelistWidget;
    private int currentPage = 0;
    private int totalPages = 1;
    private final int ITEMS_PER_PAGE = 10;
    private String lastSearchText = "";

    public AdminDashboardScreen(Screen lastScreen) {
        super((Component)Component.m_237113_((String)"\u0e23\u0e30\u0e1a\u0e1a\u0e08\u0e31\u0e14\u0e01\u0e32\u0e23\u0e2b\u0e25\u0e31\u0e07\u0e1a\u0e49\u0e32\u0e19 (Admin Dashboard)"));
        this.lastScreen = lastScreen;
        this.tempAdminMode = (Boolean)ModConfiguration.ADMIN_MODE.get();
        this.tempLockInventory = (Boolean)ModConfiguration.LOCK_INVENTORY.get();
        this.tempEnableTime = (Boolean)ModConfiguration.ENABLE_TIME_SYNC.get();
        this.tempIsWhitelistMode = (Boolean)ModConfiguration.IS_WHITELIST_MODE.get();
        this.tempEnableThirst = (Boolean)ModConfiguration.ENABLE_THIRST.get();
        this.tempRealStart = (Double)ModConfiguration.REAL_START.get();
        this.tempRealEnd = (Double)ModConfiguration.REAL_END.get();
        this.tempSpawnList = new ArrayList<String>((Collection)ModConfiguration.SPAWN_LIST.get());
        this.tempBannedItems = new ArrayList<String>((Collection)ModConfiguration.BANNED_ITEMS.get());
    }

    private boolean hasAdminAccess() {
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null || this.f_96541_.f_91072_ == null) {
            return false;
        }
        return this.f_96541_.f_91074_.m_20310_(2) || this.f_96541_.f_91072_.m_105295_() == GameType.CREATIVE;
    }

    public void refreshScreen(int tabId) {
        this.currentTab = tabId;
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    public void updateWhitelistData(List<String> names) {
        this.serverWhitelist = names;
        if (this.whitelistWidget != null) {
            this.whitelistWidget.refreshList();
        }
    }

    private void popup(String title, String message) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new BackyardToast((Component)Component.m_237113_((String)title), (Component)Component.m_237113_((String)message)));
    }

    protected void m_7856_() {
        if (!this.hasAdminAccess()) {
            this.m_7379_();
            return;
        }
        this.m_169413_();
        if (this.ticksOpen < 20) {
            return;
        }
        int centerX = this.f_96543_ / 2;
        int panelX = centerX - 130;
        int panelY = 45;
        int panelH = this.f_96544_ - 95;
        this.addTab(centerX - 145, "\u0e2b\u0e19\u0e49\u0e32\u0e2b\u0e25\u0e31\u0e01", 0, "\u0e15\u0e31\u0e49\u0e07\u0e04\u0e48\u0e32\u0e42\u0e2b\u0e21\u0e14\u0e41\u0e2d\u0e14\u0e21\u0e34\u0e19\u0e40\u0e1a\u0e37\u0e49\u0e2d\u0e07\u0e15\u0e49\u0e19");
        this.addTab(centerX - 100, "\u0e40\u0e27\u0e25\u0e32", 1, "\u0e0b\u0e34\u0e07\u0e04\u0e4c\u0e40\u0e27\u0e25\u0e32\u0e08\u0e23\u0e34\u0e07\u0e41\u0e25\u0e30\u0e15\u0e31\u0e49\u0e07\u0e04\u0e48\u0e32\u0e0a\u0e48\u0e27\u0e07\u0e40\u0e27\u0e25\u0e32\u0e40\u0e0b\u0e34\u0e23\u0e4c\u0e1f\u0e40\u0e27\u0e2d\u0e23\u0e4c");
        this.addTab(centerX - 55, "\u0e21\u0e2d\u0e19\u0e2a\u0e40\u0e15\u0e2d\u0e23\u0e4c", 2, "\u0e08\u0e31\u0e14\u0e01\u0e32\u0e23\u0e23\u0e32\u0e22\u0e01\u0e32\u0e23\u0e41\u0e1a\u0e19/\u0e2d\u0e19\u0e38\u0e0d\u0e32\u0e15 \u0e01\u0e32\u0e23\u0e40\u0e01\u0e34\u0e14\u0e02\u0e2d\u0e07\u0e2a\u0e34\u0e48\u0e07\u0e21\u0e35\u0e0a\u0e35\u0e27\u0e34\u0e15");
        this.addTab(centerX - 10, "\u0e01\u0e23\u0e30\u0e40\u0e1b\u0e4b\u0e32", 3, "\u0e2a\u0e48\u0e2d\u0e07\u0e41\u0e25\u0e30\u0e08\u0e31\u0e14\u0e01\u0e32\u0e23\u0e44\u0e2d\u0e40\u0e17\u0e21\u0e43\u0e19\u0e01\u0e23\u0e30\u0e40\u0e1b\u0e4b\u0e32\u0e1c\u0e39\u0e49\u0e40\u0e25\u0e48\u0e19\u0e2d\u0e2d\u0e19\u0e44\u0e25\u0e19\u0e4c");
        this.addTab(centerX + 35, "\u0e41\u0e1a\u0e19\u0e44\u0e2d\u0e40\u0e17\u0e21", 4, "\u0e40\u0e25\u0e37\u0e2d\u0e01\u0e44\u0e2d\u0e40\u0e17\u0e21\u0e17\u0e35\u0e48\u0e44\u0e21\u0e48\u0e15\u0e49\u0e2d\u0e07\u0e01\u0e32\u0e23\u0e43\u0e2b\u0e49\u0e43\u0e0a\u0e49\u0e07\u0e32\u0e19\u0e43\u0e19\u0e40\u0e0b\u0e34\u0e23\u0e4c\u0e1f\u0e40\u0e27\u0e2d\u0e23\u0e4c");
        this.addTab(centerX + 80, "\u0e44\u0e27\u0e25\u0e34\u0e2a\u0e15\u0e4c", 5, "\u0e08\u0e31\u0e14\u0e01\u0e32\u0e23\u0e23\u0e32\u0e22\u0e0a\u0e37\u0e48\u0e2d\u0e1c\u0e39\u0e49\u0e40\u0e25\u0e48\u0e19\u0e17\u0e35\u0e48\u0e44\u0e14\u0e49\u0e23\u0e31\u0e1a\u0e2d\u0e19\u0e38\u0e0d\u0e32\u0e15\u0e40\u0e02\u0e49\u0e32\u0e40\u0e0b\u0e34\u0e23\u0e4c\u0e1f\u0e40\u0e27\u0e2d\u0e23\u0e4c");
        switch (this.currentTab) {
            case 0: {
                this.initMainTab(panelX + 20, panelY + 30);
                break;
            }
            case 1: {
                this.initTimeTab(panelX + 20, panelY + 30);
                break;
            }
            case 2: {
                this.initEntityTab(panelX, panelY, panelH);
                break;
            }
            case 3: {
                this.initPlayerTab(panelX, panelY, panelH);
                break;
            }
            case 4: {
                this.initItemTab(panelX, panelY, panelH);
                break;
            }
            case 5: {
                this.initWhitelistTab(panelX, panelY, panelH);
            }
        }
        int actionY = this.f_96544_ - 28;
        this.m_142416_((GuiEventListener)new ColoredOutlineButton(centerX - 100, actionY, 95, 20, (Component)Component.m_237113_((String)"\u0e1a\u0e31\u0e19\u0e17\u0e36\u0e01\u0e02\u0e49\u0e2d\u0e21\u0e39\u0e25"), 3066993, b -> this.saveSettings()));
        this.m_142416_((GuiEventListener)new ColoredOutlineButton(centerX + 5, actionY, 95, 20, (Component)Component.m_237113_((String)"\u0e1b\u0e34\u0e14\u0e2b\u0e19\u0e49\u0e32\u0e15\u0e48\u0e32\u0e07"), 15158332, b -> this.m_7379_()));
    }

    private void addTab(int x, String label, int id, String desc) {
        TabButton btn = new TabButton(x, 15, 42, 20, (Component)Component.m_237113_((String)label), id);
        btn.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)desc)));
        this.m_142416_((GuiEventListener)btn);
    }

    private void initMainTab(int x, int y) {
        int adminColor = this.tempAdminMode ? 3066993 : 15158332;
        this.m_142416_((GuiEventListener)new ColoredOutlineButton(x, y, 200, 20, (Component)Component.m_237113_((String)("ADMIN MODE: " + (this.tempAdminMode ? "\u0e40\u0e1b\u0e34\u0e14" : "\u0e1b\u0e34\u0e14"))), adminColor, b -> {
            this.tempAdminMode = !this.tempAdminMode;
            this.m_7856_();
        }));
        int lockColor = this.tempLockInventory ? 3066993 : 15158332;
        this.m_142416_((GuiEventListener)new ColoredOutlineButton(x, y + 25, 200, 20, (Component)Component.m_237113_((String)("LOCK INVENTORY: " + (this.tempLockInventory ? "\u0e40\u0e1b\u0e34\u0e14" : "\u0e1b\u0e34\u0e14"))), lockColor, b -> {
            this.tempLockInventory = !this.tempLockInventory;
            this.m_7856_();
        }));
        int thirstColor = this.tempEnableThirst ? 3066993 : 15158332;
        this.m_142416_((GuiEventListener)new ColoredOutlineButton(x, y + 50, 200, 20, (Component)Component.m_237113_((String)("\u0e23\u0e30\u0e1a\u0e1a\u0e2b\u0e34\u0e27\u0e19\u0e49\u0e33: " + (this.tempEnableThirst ? "\u0e40\u0e1b\u0e34\u0e14" : "\u0e1b\u0e34\u0e14"))), thirstColor, b -> {
            this.tempEnableThirst = !this.tempEnableThirst;
            this.m_7856_();
        }));
        this.m_142416_((GuiEventListener)new ColoredOutlineButton(x, y + 75, 200, 20, (Component)Component.m_237113_((String)"\u0e15\u0e31\u0e49\u0e07\u0e08\u0e38\u0e14\u0e40\u0e01\u0e34\u0e14\u0e42\u0e25\u0e01\u0e17\u0e35\u0e48\u0e19\u0e35\u0e48"), 15844367, b -> {
            if (this.f_96541_.f_91074_ != null) {
                BackyardNetwork.sendToServer(new GlobalSpawnPacket(this.f_96541_.f_91074_.m_20183_()));
            }
        }));
    }

    private void initTimeTab(int x, int y) {
        int color = this.tempEnableTime ? 3066993 : 15158332;
        this.m_142416_((GuiEventListener)new ColoredOutlineButton(x, y, 200, 20, (Component)(this.tempEnableTime ? Component.m_237113_((String)"\u0e2a\u0e16\u0e32\u0e19\u0e30: \u0e40\u0e1b\u0e34\u0e14\u0e43\u0e0a\u0e49\u0e07\u0e32\u0e19\u0e0b\u0e34\u0e07\u0e04\u0e4c") : Component.m_237113_((String)"\u0e2a\u0e16\u0e32\u0e19\u0e30: \u0e1b\u0e34\u0e14\u0e43\u0e0a\u0e49\u0e07\u0e32\u0e19\u0e0b\u0e34\u0e07\u0e04\u0e4c")), color, b -> {
            this.tempEnableTime = !this.tempEnableTime;
            this.m_7856_();
        }));
        this.realStartBox = new EditBox(this.f_96547_, x, y + 45, 90, 16, (Component)Component.m_237113_((String)""));
        this.realStartBox.m_94144_(String.valueOf(this.tempRealStart));
        this.realStartBox.m_94151_(s -> {
            try {
                this.tempRealStart = Double.parseDouble(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.m_142416_((GuiEventListener)this.realStartBox);
        this.realEndBox = new EditBox(this.f_96547_, x + 110, y + 45, 90, 16, (Component)Component.m_237113_((String)""));
        this.realEndBox.m_94144_(String.valueOf(this.tempRealEnd));
        this.realEndBox.m_94151_(s -> {
            try {
                this.tempRealEnd = Double.parseDouble(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.m_142416_((GuiEventListener)this.realEndBox);
    }

    private void initEntityTab(int px, int py, int ph) {
        this.setupSearchBox(px, py);
        String modeTxt = this.tempIsWhitelistMode ? "\u0e1a\u0e25\u0e47\u0e2d\u0e01\u0e2b\u0e21\u0e14" : "\u0e1b\u0e01\u0e15\u0e34";
        this.m_142416_((GuiEventListener)new ColoredOutlineButton(px + 115, py + 11, 55, 16, (Component)Component.m_237113_((String)modeTxt), 3447003, b -> {
            this.tempIsWhitelistMode = !this.tempIsWhitelistMode;
            this.m_7856_();
        }));
        this.entityList = new EntitySelectionList(this.f_96541_, 240, ph - 40, py + 35, py + ph - 5, px + 10);
        this.m_142416_((GuiEventListener)this.entityList);
        this.updateEntityList();
        this.setupPagination(px, py);
    }

    private void initPlayerTab(int px, int py, int ph) {
        this.setupSearchBox(px, py);
        this.playerListWidget = new PlayerList(this.f_96541_, 240, ph - 40, py + 35, py + ph - 5, px + 10);
        this.m_142416_((GuiEventListener)this.playerListWidget);
        this.playerListWidget.refreshList();
    }

    private void initItemTab(int px, int py, int ph) {
        this.setupSearchBox(px, py);
        this.itemListWidget = new ItemSelectionList(this.f_96541_, 240, ph - 40, py + 35, py + ph - 5, px + 10);
        this.m_142416_((GuiEventListener)this.itemListWidget);
        this.updateItemList();
        this.setupPagination(px, py);
    }

    private void initWhitelistTab(int px, int py, int ph) {
        BackyardNetwork.sendToServer(new BackyardNetwork.RequestWhitelistPacket());
        this.setupSearchBox(px, py);
        this.whitelistAddBox = new EditBox(this.f_96547_, px + 12, py + ph - 25, 170, 14, (Component)Component.m_237113_((String)""));
        this.whitelistAddBox.m_257771_((Component)Component.m_237113_((String)"\u0e1e\u0e34\u0e21\u0e1e\u0e4c\u0e0a\u0e37\u0e48\u0e2d\u0e1c\u0e39\u0e49\u0e40\u0e25\u0e48\u0e19..."));
        this.m_142416_((GuiEventListener)this.whitelistAddBox);
        this.m_142416_((GuiEventListener)new ColoredOutlineButton(px + 185, py + ph - 25, 45, 14, (Component)Component.m_237113_((String)"\u0e40\u0e1e\u0e34\u0e48\u0e21"), 3066993, b -> {
            String name = this.whitelistAddBox.m_94155_();
            if (!name.isEmpty() && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.f_108617_.m_246979_("whitelist add " + name);
                this.popup("\u0e2a\u0e33\u0e40\u0e23\u0e47\u0e08", "\u0e40\u0e1e\u0e34\u0e48\u0e21 " + name + " \u0e40\u0e02\u0e49\u0e32\u0e44\u0e27\u0e25\u0e34\u0e2a\u0e15\u0e4c");
                this.whitelistAddBox.m_94144_("");
                BackyardNetwork.sendToServer(new BackyardNetwork.RequestWhitelistPacket());
            }
        }));
        this.whitelistWidget = new WhitelistList(this.f_96541_, 240, ph - 65, py + 35, py + ph - 35, px + 10);
        this.m_142416_((GuiEventListener)this.whitelistWidget);
        this.whitelistWidget.refreshList();
    }

    private void setupSearchBox(int px, int py) {
        this.searchBox = new EditBox(this.f_96547_, px + 12, py + 12, 100, 14, (Component)Component.m_237113_((String)""));
        this.searchBox.m_257771_((Component)Component.m_237113_((String)"\u0e04\u0e49\u0e19\u0e2b\u0e32\u0e0a\u0e37\u0e48\u0e2d...").m_130940_(ChatFormatting.GRAY));
        this.searchBox.m_94144_(this.lastSearchText);
        this.searchBox.m_94151_(text -> {
            this.lastSearchText = text;
            this.currentPage = 0;
            if (this.currentTab == 2) {
                this.updateEntityList();
            } else if (this.currentTab == 4) {
                this.updateItemList();
            } else if (this.currentTab == 3) {
                this.playerListWidget.refreshList();
            } else if (this.currentTab == 5) {
                this.whitelistWidget.refreshList();
            }
        });
        this.m_142416_((GuiEventListener)this.searchBox);
    }

    private void setupPagination(int px, int py) {
        if (this.totalPages > 1) {
            this.m_142416_((GuiEventListener)new ColoredOutlineButton(px + 175, py + 11, 15, 16, (Component)Component.m_237113_((String)"<"), 0xFFFFFF, b -> {
                if (this.currentPage > 0) {
                    --this.currentPage;
                    this.m_7856_();
                }
            }));
            this.m_142416_((GuiEventListener)new ColoredOutlineButton(px + 195, py + 11, 35, 16, (Component)Component.m_237113_((String)(this.currentPage + 1 + "/" + this.totalPages)), 0xFFFFFF, b -> {}));
            this.m_142416_((GuiEventListener)new ColoredOutlineButton(px + 235, py + 11, 15, 16, (Component)Component.m_237113_((String)">"), 0xFFFFFF, b -> {
                if (this.currentPage < this.totalPages - 1) {
                    ++this.currentPage;
                    this.m_7856_();
                }
            }));
        }
    }

    private void updateEntityList() {
        String filter = this.lastSearchText.toLowerCase(Locale.ROOT);
        List<EntityType<?>> list = ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(t -> t.m_20674_() != MobCategory.MISC).filter(t -> t.m_20676_().getString().toLowerCase().contains(filter)).collect(Collectors.toList());
        this.totalPages = Math.max(1, (int)Math.ceil((double)list.size() / 10.0));
        if (this.entityList != null) {
            this.entityList.updateEntries(list, this.currentPage * 10, Math.min((this.currentPage + 1) * 10, list.size()));
        }
    }

    private void updateItemList() {
        String filter = this.lastSearchText.toLowerCase(Locale.ROOT);
        List<Item> list = ForgeRegistries.ITEMS.getValues().stream().filter(i -> i.m_41466_().getString().toLowerCase().contains(filter) || ForgeRegistries.ITEMS.getKey(i).toString().contains(filter)).sorted(Comparator.comparing(i -> i.m_41466_().getString())).collect(Collectors.toList());
        this.totalPages = Math.max(1, (int)Math.ceil((double)list.size() / 10.0));
        if (this.itemListWidget != null) {
            this.itemListWidget.updateEntries(list, this.currentPage * 10, Math.min((this.currentPage + 1) * 10, list.size()));
        }
    }

    public void m_88315_(GuiGraphics g, int mx, int my, float pt) {
        float renderTime = (float)this.ticksOpen + pt;
        RenderSystem.enableBlend();
        this.drawAnimatedBG(g, BG_0, renderTime * 0.15f, 64);
        this.drawAnimatedBG(g, BG_1, renderTime * 0.35f, 64);
        this.drawAnimatedBG(g, BG_2, renderTime * 0.65f, 64);
        if (this.ticksOpen < 20) {
            float progress = renderTime / 20.0f;
            float scale = Mth.m_14179_((float)progress, (float)0.0f, (float)1.0f);
            g.m_280168_().m_85836_();
            g.m_280168_().m_252880_((float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f, 0.0f);
            g.m_280168_().m_85841_(scale, scale, scale);
            g.m_280168_().m_252781_(Axis.f_252403_.m_252977_(renderTime * 18.0f));
            g.m_280163_(LOGO_URL, -50, -50, 0.0f, 0.0f, 100, 100, 100, 100);
            g.m_280168_().m_85849_();
            return;
        }
        int centerX = this.f_96543_ / 2;
        g.m_280509_(centerX - 140, 40, centerX + 140, this.f_96544_ - 40, -872415232);
        g.m_280637_(centerX - 140, 40, 280, this.f_96544_ - 80, 0x44FFFFFF);
        super.m_88315_(g, mx, my, pt);
        if (this.currentTab == 3 && this.playerListWidget != null && this.playerListWidget.isEmpty()) {
            g.m_280137_(this.f_96547_, "\u0e44\u0e21\u0e48\u0e1e\u0e1a\u0e1c\u0e39\u0e49\u0e40\u0e25\u0e48\u0e19\u0e2d\u0e2d\u0e19\u0e44\u0e25\u0e19\u0e4c", centerX, this.f_96544_ / 2, 0xFFFFFF);
        } else if (this.currentTab == 5 && this.whitelistWidget != null && this.whitelistWidget.isEmpty()) {
            g.m_280137_(this.f_96547_, "\u0e22\u0e31\u0e07\u0e44\u0e21\u0e48\u0e21\u0e35\u0e1c\u0e39\u0e49\u0e40\u0e25\u0e48\u0e19\u0e43\u0e19\u0e23\u0e32\u0e22\u0e01\u0e32\u0e23", centerX, this.f_96544_ / 2, 0xFFFFFF);
        }
        if (this.searchBox != null && this.currentTab >= 2) {
            this.searchBox.m_88315_(g, mx, my, pt);
        }
    }

    private void drawAnimatedBG(GuiGraphics g, ResourceLocation tex, float offset, int size) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tex);
        int xOff = (int)(offset % (float)size);
        int yOff = (int)(offset % (float)size);
        for (int x = -xOff; x < this.f_96543_; x += size) {
            for (int y = -yOff; y < this.f_96544_; y += size) {
                g.m_280163_(tex, x, y, 0.0f, 0.0f, size, size, size, size);
            }
        }
    }

    private void saveSettings() {
        block3: {
            if (!this.hasAdminAccess()) {
                return;
            }
            try {
                ModConfiguration.LOCK_INVENTORY.set((Object)this.tempLockInventory);
                BackyardNetwork.sendToServer(new AdminPacket(this.tempAdminMode, this.tempLockInventory, this.tempEnableTime, this.tempRealStart, this.tempRealEnd, this.tempIsWhitelistMode, this.tempSpawnList, this.tempBannedItems, this.tempEnableThirst));
                this.popup("\u0e23\u0e30\u0e1a\u0e1a\u0e08\u0e31\u0e14\u0e01\u0e32\u0e23\u0e41\u0e2d\u0e14\u0e21\u0e34\u0e19", "\u0e1a\u0e31\u0e19\u0e17\u0e36\u0e01\u0e02\u0e49\u0e2d\u0e21\u0e39\u0e25\u0e40\u0e23\u0e35\u0e22\u0e1a\u0e23\u0e49\u0e2d\u0e22\u0e41\u0e25\u0e49\u0e27");
                this.m_7379_();
            }
            catch (Exception e) {
                if (this.f_96541_.f_91074_ == null) break block3;
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u0e40\u0e01\u0e34\u0e14\u0e02\u0e49\u0e2d\u0e1c\u0e34\u0e14\u0e1e\u0e25\u0e32\u0e14: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            }
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }

    public void m_86600_() {
        if (!this.hasAdminAccess()) {
            this.m_7379_();
            return;
        }
        ++this.ticksOpen;
        if (this.ticksOpen == 20) {
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
    }

    class WhitelistList
    extends ModernList<WhitelistEntry> {
        public WhitelistList(Minecraft mc, int w, int h, int y0, int y1, int x) {
            super(mc, w, h, y0, y1, x);
        }

        public void refreshList() {
            this.m_93516_();
            String filter = AdminDashboardScreen.this.lastSearchText.toLowerCase(Locale.ROOT);
            for (String name : AdminDashboardScreen.this.serverWhitelist) {
                if (!filter.isEmpty() && !name.toLowerCase(Locale.ROOT).contains(filter)) continue;
                this.m_7085_((AbstractSelectionList.Entry)new WhitelistEntry(name));
            }
        }

        class WhitelistEntry
        extends ObjectSelectionList.Entry<WhitelistEntry> {
            private final String name;
            private final Button btn;

            public WhitelistEntry(String name) {
                this.name = name;
                this.btn = new ColoredOutlineButton(0, 0, 30, 16, (Component)Component.m_237113_((String)"\u0e25\u0e1a"), 15158332, b -> {
                    if (((WhitelistList)WhitelistList.this).f_93386_.f_91074_ != null) {
                        ((WhitelistList)WhitelistList.this).f_93386_.f_91074_.f_108617_.m_246979_("whitelist remove " + name);
                    }
                    if (AdminDashboardScreen.this.serverWhitelist.contains(name)) {
                        AdminDashboardScreen.this.serverWhitelist.remove(name);
                        WhitelistList.this.refreshList();
                    }
                    BackyardNetwork.sendToServer(new BackyardNetwork.RequestWhitelistPacket());
                });
            }

            public void m_6311_(GuiGraphics g, int idx, int top, int left, int w, int h, int mx, int my, boolean hov, float pt) {
                g.m_280488_(AdminDashboardScreen.this.f_96547_, this.name, left + 5, top + 6, 0xFFFFFF);
                this.btn.m_252865_(left + w - 35);
                this.btn.m_253211_(top + 2);
                this.btn.m_88315_(g, mx, my, pt);
            }

            public boolean m_6375_(double x, double y, int b) {
                return this.btn.m_6375_(x, y, b);
            }

            public Component m_142172_() {
                return Component.m_237119_();
            }
        }
    }

    private class ColoredOutlineButton
    extends Button {
        private final int borderColor;

        public ColoredOutlineButton(int x, int y, int w, int h, Component text, int color, Button.OnPress press) {
            super(x, y, w, h, text, press, Button.f_252438_);
            this.borderColor = color;
        }

        public void m_87963_(GuiGraphics g, int mx, int my, float pt) {
            RenderSystem.enableBlend();
            int finalColor = this.m_198029_() ? 0xFF000000 | this.borderColor : 0x44000000 | this.borderColor;
            g.m_280637_(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, finalColor);
            if (this.m_198029_()) {
                g.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, 0x22FFFFFF);
            }
            g.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, -1);
        }
    }

    private class TabButton
    extends Button {
        private final int id;

        public TabButton(int x, int y, int w, int h, Component text, int tabId) {
            super(x, y, w, h, text, b -> ((AdminDashboardScreen)Minecraft.m_91087_().f_91080_).refreshScreen(tabId), Button.f_252438_);
            this.id = tabId;
        }

        public void m_87963_(GuiGraphics g, int mx, int my, float pt) {
            int textColor;
            boolean active;
            boolean bl = active = AdminDashboardScreen.this.currentTab == this.id;
            int n = active ? -1 : (textColor = this.f_93622_ ? -570425345 : -1996488705);
            if (active) {
                g.m_280509_(this.m_252754_() + 2, this.m_252907_() + this.f_93619_ - 2, this.m_252754_() + this.f_93618_ - 4, this.m_252907_() + this.f_93619_, -13710223);
            }
            g.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, textColor);
        }
    }

    class EntitySelectionList
    extends ModernList<EntityEntry> {
        public EntitySelectionList(Minecraft mc, int w, int h, int y0, int y1, int x) {
            super(mc, w, h, y0, y1, x);
        }

        public void updateEntries(List<EntityType<?>> list, int start, int end) {
            double scrollAmount = this.m_93517_();
            this.m_93516_();
            for (int i = start; i < end; ++i) {
                if (i >= list.size()) continue;
                this.m_7085_((AbstractSelectionList.Entry)new EntityEntry(list.get(i)));
            }
            this.m_93410_(scrollAmount);
        }

        class EntityEntry
        extends ObjectSelectionList.Entry<EntityEntry> {
            private final EntityType<?> type;
            private final Button btn;

            public EntityEntry(EntityType<?> t) {
                int color;
                String label;
                this.type = t;
                String id = ForgeRegistries.ENTITY_TYPES.getKey(t).toString();
                boolean isBlocked = AdminDashboardScreen.this.tempSpawnList.contains(id);
                if (AdminDashboardScreen.this.tempIsWhitelistMode) {
                    label = isBlocked ? "\u0e2d\u0e19\u0e38\u0e0d\u0e32\u0e15" : "\u0e1a\u0e25\u0e47\u0e2d\u0e01";
                    color = isBlocked ? 3066993 : 15158332;
                } else {
                    label = isBlocked ? "\u0e41\u0e1a\u0e19" : "\u0e1b\u0e01\u0e15\u0e34";
                    color = isBlocked ? 15158332 : 3066993;
                }
                this.btn = new ColoredOutlineButton(0, 0, 40, 16, (Component)Component.m_237113_((String)label), color, b -> {
                    if (AdminDashboardScreen.this.tempSpawnList.contains(id)) {
                        AdminDashboardScreen.this.tempSpawnList.remove(id);
                    } else {
                        AdminDashboardScreen.this.tempSpawnList.add(id);
                    }
                    AdminDashboardScreen.this.updateEntityList();
                });
            }

            public void m_6311_(GuiGraphics g, int idx, int top, int left, int w, int h, int mx, int my, boolean hov, float pt) {
                g.m_280203_(new ItemStack((ItemLike)(SpawnEggItem.m_43213_(this.type) != null ? SpawnEggItem.m_43213_(this.type) : Items.f_42521_)), left + 2, top + 2);
                g.m_280488_(AdminDashboardScreen.this.f_96547_, this.type.m_20676_().getString(), left + 22, top + 6, 0xFFFFFF);
                this.btn.m_252865_(left + w - 45);
                this.btn.m_253211_(top + 2);
                this.btn.m_88315_(g, mx, my, pt);
            }

            public boolean m_6375_(double x, double y, int b) {
                return this.btn.m_6375_(x, y, b);
            }

            public Component m_142172_() {
                return Component.m_237119_();
            }
        }
    }

    class PlayerList
    extends ModernList<PlayerEntry> {
        public PlayerList(Minecraft mc, int w, int h, int y0, int y1, int x) {
            super(mc, w, h, y0, y1, x);
        }

        public void refreshList() {
            double scrollAmount = this.m_93517_();
            this.m_93516_();
            if (this.f_93386_.m_91403_() == null) {
                return;
            }
            String filter = AdminDashboardScreen.this.lastSearchText.toLowerCase(Locale.ROOT);
            for (PlayerInfo info : this.f_93386_.m_91403_().m_105142_()) {
                if (info.m_105312_().getId().equals(this.f_93386_.f_91074_.m_20148_()) || !filter.isEmpty() && !info.m_105312_().getName().toLowerCase(Locale.ROOT).contains(filter)) continue;
                this.m_7085_((AbstractSelectionList.Entry)new PlayerEntry(info));
            }
            this.m_93410_(scrollAmount);
        }

        class PlayerEntry
        extends ObjectSelectionList.Entry<PlayerEntry> {
            private final PlayerInfo info;
            private final Button btn;

            public PlayerEntry(PlayerInfo info) {
                this.info = info;
                this.btn = new ColoredOutlineButton(0, 0, 45, 16, (Component)Component.m_237113_((String)"\u0e08\u0e31\u0e14\u0e01\u0e32\u0e23"), 3447003, b -> BackyardNetwork.sendToServer(new AdminOpenInvPacket(info.m_105312_().getId())));
            }

            public void m_6311_(GuiGraphics g, int idx, int top, int left, int w, int h, int mx, int my, boolean hov, float pt) {
                g.m_280411_(this.info.m_105337_(), left + 4, top + 4, 12, 12, 8.0f, 8.0f, 8, 8, 64, 64);
                g.m_280488_(AdminDashboardScreen.this.f_96547_, this.info.m_105312_().getName(), left + 20, top + 6, 3066993);
                this.btn.m_252865_(left + w - 50);
                this.btn.m_253211_(top + 2);
                this.btn.m_88315_(g, mx, my, pt);
            }

            public boolean m_6375_(double x, double y, int b) {
                return this.btn.m_6375_(x, y, b);
            }

            public Component m_142172_() {
                return Component.m_237119_();
            }
        }
    }

    class ItemSelectionList
    extends ModernList<ItemEntry> {
        public ItemSelectionList(Minecraft mc, int w, int h, int y0, int y1, int x) {
            super(mc, w, h, y0, y1, x);
        }

        public void updateEntries(List<Item> list, int start, int end) {
            double scrollAmount = this.m_93517_();
            this.m_93516_();
            for (int i = start; i < end; ++i) {
                if (i >= list.size()) continue;
                this.m_7085_((AbstractSelectionList.Entry)new ItemEntry(list.get(i)));
            }
            this.m_93410_(scrollAmount);
        }

        class ItemEntry
        extends ObjectSelectionList.Entry<ItemEntry> {
            private final Item item;
            private final Button btn;

            public ItemEntry(Item it) {
                this.item = it;
                String id = ForgeRegistries.ITEMS.getKey((Object)it).toString();
                boolean isBanned = AdminDashboardScreen.this.tempBannedItems.contains(id);
                this.btn = new ColoredOutlineButton(0, 0, 40, 16, (Component)Component.m_237113_((String)(isBanned ? "\u0e41\u0e1a\u0e19" : "\u0e1b\u0e01\u0e15\u0e34")), isBanned ? 15158332 : 3066993, b -> {
                    if (AdminDashboardScreen.this.tempBannedItems.contains(id)) {
                        AdminDashboardScreen.this.tempBannedItems.remove(id);
                    } else {
                        AdminDashboardScreen.this.tempBannedItems.add(id);
                    }
                    AdminDashboardScreen.this.updateItemList();
                });
            }

            public void m_6311_(GuiGraphics g, int idx, int top, int left, int w, int h, int mx, int my, boolean hov, float pt) {
                g.m_280203_(new ItemStack((ItemLike)this.item), left + 2, top + 2);
                String n = this.item.m_41466_().getString();
                g.m_280488_(AdminDashboardScreen.this.f_96547_, (String)(n.length() > 15 ? n.substring(0, 13) + ".." : n), left + 22, top + 6, 0xFFFFFF);
                this.btn.m_252865_(left + w - 45);
                this.btn.m_253211_(top + 2);
                this.btn.m_88315_(g, mx, my, pt);
            }

            public boolean m_6375_(double x, double y, int b) {
                return this.btn.m_6375_(x, y, b);
            }

            public Component m_142172_() {
                return Component.m_237119_();
            }
        }
    }

    abstract class ModernList<T extends ObjectSelectionList.Entry<T>>
    extends ObjectSelectionList<T> {
        public ModernList(Minecraft mc, int w, int h, int y0, int y1, int x) {
            super(mc, w, h, y0, y1, 24);
            this.m_93507_(x);
            this.m_93488_(false);
            this.m_93496_(false);
        }

        protected int m_5756_() {
            return this.f_93393_ + this.f_93388_ - 5;
        }

        public int m_5759_() {
            return this.f_93388_ - 15;
        }

        public boolean isEmpty() {
            return this.m_5773_() == 0;
        }
    }
}

