/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.client.chat;

import fox.org.mc.backyardlib.client.chat.ChatManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="backyardlib", value={Dist.CLIENT})
public class ChatScreenUI {
    private static final int BTN_W = 45;
    private static final int BTN_H = 15;
    private static int btnY = 0;
    private static int startX = 4;

    @SubscribeEvent
    public static void onRenderScreen(ScreenEvent.Render.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof ChatScreen) {
            ChatScreen chatScreen = (ChatScreen)screen;
            btnY = chatScreen.f_96544_ - 35;
            GuiGraphics g = event.getGuiGraphics();
            ChatScreenUI.drawModernTab(g, startX, btnY, "\u0e17\u0e31\u0e48\u0e27\u0e44\u0e1b", ChatManager.currentTab == 0, ChatManager.playerUnread);
            ChatScreenUI.drawModernTab(g, startX + 45 + 5, btnY, "\u0e23\u0e30\u0e1a\u0e1a", ChatManager.currentTab == 1, ChatManager.systemUnread);
        }
    }

    private static void drawModernTab(GuiGraphics g, int x, int y, String text, boolean isActive, int unread) {
        int bgColor = isActive ? -1439773583 : 0x66000000;
        g.m_280509_(x, y, x + 45, y + 15, bgColor);
        int borderColor = unread > 0 ? -46020 : 0x44FFFFFF;
        g.m_280637_(x, y, 45, 15, borderColor);
        int textColor = isActive ? -1 : -855638017;
        g.m_280137_(Minecraft.m_91087_().f_91062_, text, x + 22, y + 3, textColor);
        if (unread > 0) {
            ChatScreenUI.drawNotificationCircle(g, x + 45 - 2, y + 2, unread);
        }
    }

    private static void drawNotificationCircle(GuiGraphics g, int x, int y, int count) {
        String label = count > 9 ? "9+" : String.valueOf(count);
        int radius = 5;
        int color = -1618884;
        g.m_280168_().m_85836_();
        g.m_280168_().m_252880_(0.0f, 0.0f, 600.0f);
        g.m_280509_(x - radius, y - radius + 1, x + radius, y + radius - 1, color);
        g.m_280509_(x - radius + 1, y - radius, x + radius - 1, y + radius, color);
        g.m_280168_().m_85836_();
        float scale = 0.6f;
        g.m_280168_().m_252880_((float)x - (float)Minecraft.m_91087_().f_91062_.m_92895_(label) * scale / 2.0f, (float)y - 3.0f * scale, 0.0f);
        g.m_280168_().m_85841_(scale, scale, 1.0f);
        g.m_280056_(Minecraft.m_91087_().f_91062_, label, 0, 0, -1, false);
        g.m_280168_().m_85849_();
        g.m_280168_().m_85849_();
    }

    @SubscribeEvent
    public static void onMouseClick(ScreenEvent.MouseButtonPressed.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof ChatScreen) {
            double my;
            ChatScreen chatScreen = (ChatScreen)screen;
            double mx = event.getMouseX();
            if (ChatScreenUI.isMouseInBound(mx, my = event.getMouseY(), startX, btnY)) {
                ChatManager.switchTab(0);
                event.setCanceled(true);
            } else if (ChatScreenUI.isMouseInBound(mx, my, startX + 45 + 5, btnY)) {
                ChatManager.switchTab(1);
                event.setCanceled(true);
            }
        }
    }

    private static boolean isMouseInBound(double mx, double my, int x, int y) {
        return mx >= (double)x && mx <= (double)(x + 45) && my >= (double)y && my <= (double)(y + 15);
    }
}

