/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.client;

import fox.org.mc.backyardlib.client.ModKeyBindings;
import fox.org.mc.backyardlib.config.ModConfiguration;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="backyardlib", value={Dist.CLIENT})
public class ZoomHandler {
    private static boolean isZooming = false;
    private static float currentFovMultiplier = 1.0f;
    private static boolean originalSmoothCamera = false;
    private static boolean activatedSmoothCamera = false;
    private static float dynamicZoomValue = 1.0f;

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(ModKeyBindings.ZOOM_KEY);
    }

    @SubscribeEvent
    public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        if (isZooming) {
            double scrollAmount = event.getScrollDelta();
            if ((dynamicZoomValue -= (float)(scrollAmount * (double)0.05f)) < 0.01f) {
                dynamicZoomValue = 0.01f;
            }
            if (dynamicZoomValue > 1.2f) {
                dynamicZoomValue = 1.2f;
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null || mc.f_91080_ != null) {
                if (mc.f_91080_ != null) {
                    dynamicZoomValue = ((Double)ModConfiguration.ZOOM_MULTIPLIER.get()).floatValue();
                }
                return;
            }
            boolean isKeyDown = ModKeyBindings.ZOOM_KEY.m_90857_();
            double rotationSmooth = (Double)ModConfiguration.ROTATION_SMOOTHNESS.get();
            if (isKeyDown && !isZooming) {
                isZooming = true;
                dynamicZoomValue = ((Double)ModConfiguration.ZOOM_MULTIPLIER.get()).floatValue();
                if (rotationSmooth > 0.0) {
                    originalSmoothCamera = mc.f_91066_.f_92067_;
                    mc.f_91066_.f_92067_ = true;
                    activatedSmoothCamera = true;
                }
            } else if (!isKeyDown && isZooming) {
                isZooming = false;
                if (activatedSmoothCamera) {
                    mc.f_91066_.f_92067_ = originalSmoothCamera;
                    activatedSmoothCamera = false;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onComputeFov(ComputeFovModifierEvent event) {
        float target = isZooming ? dynamicZoomValue : 1.0f;
        float smoothness = ((Double)ModConfiguration.ZOOM_SMOOTHNESS.get()).floatValue();
        currentFovMultiplier += (target - currentFovMultiplier) * smoothness;
        event.setNewFovModifier(event.getNewFovModifier() * currentFovMultiplier);
    }
}

