/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyardlib.client;

import com.mojang.blaze3d.systems.RenderSystem;
import fox.org.mc.backyardlib.api.BackyardThirstAPI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class CustomHudOverlay
implements IGuiOverlay {
    private static final ResourceLocation HUD_ATLAS = ResourceLocation.fromNamespaceAndPath((String)"backyardlib", (String)"textures/gui/hud_atlas.png");
    private static final float SCALE = 0.5f;
    private static final int GAP = 20;
    private static final int BAR_W = 172;
    private static final int BAR_H = 8;
    private static final int MINI_BAR_W = 152;
    private static final int HP_V = 8;
    private static final int FOOD_V = 24;
    private static final int THIRST_V = 40;
    private static final float HOTBAR_SCALE = 1.0f;
    private static final int SLOT_SIZE = 20;
    private static final int SELECTION_SIZE = 20;
    private static final int SLOT_GAP = 1;
    private static final int HOTBAR_Y_OFFSET = -3;
    private static final int ITEM_Y_OFFSET = 1;
    private static final int CROSSHAIR_SIZE = 20;
    public static int hitTicker = 0;
    private static float dispHp = -1.0f;
    private static float delayHp = -1.0f;
    private static float dispFood = -1.0f;
    private static float delayFood = -1.0f;
    private static float dispThirst = -1.0f;
    private static float delayThirst = -1.0f;
    private static long lastTime = System.currentTimeMillis();

    public void render(ForgeGui gui, GuiGraphics g, float pt, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer p = mc.f_91074_;
        if (p == null || mc.f_91066_.f_92062_) {
            return;
        }
        if (hitTicker > 0) {
            --hitTicker;
        }
        long now = System.currentTimeMillis();
        float delta = Math.min(0.1f, (float)(now - lastTime) / 1000.0f);
        lastTime = now;
        int guiW = mc.m_91268_().m_85445_();
        int guiH = mc.m_91268_().m_85446_();
        this.renderCustomHotbar(g, mc, (Player)p, guiW, guiH);
        if (!p.m_5833_() && !p.m_7500_()) {
            int startX;
            float hp = p.m_21223_();
            float maxHp = p.m_21233_();
            float food = p.m_36324_() != null ? (float)p.m_36324_().m_38702_() : 20.0f;
            float thirst = 0.0f;
            float maxThirst = 0.0f;
            try {
                thirst = BackyardThirstAPI.getClientThirst();
                maxThirst = BackyardThirstAPI.getMaxThirst();
            }
            catch (Exception exception) {
                // empty catch block
            }
            float riseSpeed = delta * 5.0f;
            float dropSpeed = delta * 15.0f;
            dispHp = CustomHudOverlay.smartSmooth(dispHp, hp, riseSpeed, dropSpeed);
            dispFood = CustomHudOverlay.smartSmooth(dispFood, food, riseSpeed, dropSpeed);
            dispThirst = CustomHudOverlay.smartSmooth(dispThirst, thirst, riseSpeed, dropSpeed);
            float delaySpeed = delta * 6.0f;
            delayHp = CustomHudOverlay.updateDelayBar(delayHp, dispHp, delaySpeed);
            delayFood = CustomHudOverlay.updateDelayBar(delayFood, dispFood, delaySpeed);
            delayThirst = CustomHudOverlay.updateDelayBar(delayThirst, dispThirst, delaySpeed);
            int bottomReserve = 30;
            int baseY = (int)((float)(guiH - bottomReserve) / 0.5f);
            int healthX = startX = (int)((float)guiW / 0.5f / 2.0f - 182.0f);
            int foodX = startX + 172 + 20;
            RenderSystem.enableBlend();
            g.m_280168_().m_85836_();
            g.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            g.m_280163_(HUD_ATLAS, healthX, baseY, 0.0f, 0.0f, 172, 8, 256, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.65f);
            CustomHudOverlay.drawFromLeft(g, healthX, baseY, (int)Math.ceil(delayHp / Math.max(1.0f, maxHp) * 172.0f), 0, 8);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            CustomHudOverlay.drawFromLeft(g, healthX, baseY, (int)Math.ceil(dispHp / Math.max(1.0f, maxHp) * 172.0f), 0, 8);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            g.m_280163_(HUD_ATLAS, foodX, baseY, 0.0f, 16.0f, 172, 8, 256, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.65f);
            CustomHudOverlay.drawFromRight(g, foodX, baseY, 172, (int)Math.ceil(delayFood / 20.0f * 172.0f), 0, 24);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            CustomHudOverlay.drawFromRight(g, foodX, baseY, 172, (int)Math.ceil(dispFood / 20.0f * 172.0f), 0, 24);
            if (maxThirst > 0.0f) {
                int y = baseY - 12;
                int x = healthX + 20 - 1;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                g.m_280163_(HUD_ATLAS, x, y, 0.0f, 32.0f, 152, 8, 256, 256);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.65f);
                CustomHudOverlay.drawFromLeft(g, x, y, (int)Math.ceil(delayThirst / maxThirst * 152.0f), 0, 40);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                CustomHudOverlay.drawFromLeft(g, x, y, (int)Math.ceil(dispThirst / maxThirst * 152.0f), 0, 40);
            }
            g.m_280168_().m_85849_();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderCustomCrosshair(g, mc, (Player)p, guiW, guiH);
        RenderSystem.disableBlend();
        gui.rightHeight += 5;
        gui.leftHeight += 5;
    }

    private static float smartSmooth(float cur, float tar, float riseSpeed, float dropSpeed) {
        if (cur < 0.0f) {
            return tar;
        }
        return cur < tar ? cur + (tar - cur) * Math.min(1.0f, riseSpeed) : cur + (tar - cur) * Math.min(1.0f, dropSpeed);
    }

    private static float updateDelayBar(float dly, float mainVal, float speed) {
        if (dly < 0.0f) {
            return mainVal;
        }
        return mainVal > dly ? mainVal : Math.max(mainVal, dly - speed);
    }

    private void renderCustomCrosshair(GuiGraphics g, Minecraft mc, Player p, int w, int h) {
        int centerX = (w - 20) / 2;
        int centerY = (h - 20) / 2;
        int u = 40;
        int v = 48;
        if (hitTicker > 0) {
            u = 60;
        } else if (p.m_6117_() && p.m_21211_().m_41720_() instanceof ShieldItem) {
            u = 80;
        }
        RenderSystem.enableBlend();
        g.m_280163_(HUD_ATLAS, centerX, centerY, (float)u, (float)v, 20, 20, 256, 256);
    }

    private void renderCustomHotbar(GuiGraphics g, Minecraft mc, Player p, int w, int h) {
        g.m_280168_().m_85836_();
        int centerX = w / 2;
        int bottomY = h;
        g.m_280168_().m_252880_((float)centerX, (float)bottomY, -90.0f);
        g.m_280168_().m_85841_(1.0f, 1.0f, 1.0f);
        int totalWidth = 188;
        int startX = Math.round((float)(-totalWidth) / 2.0f);
        int bgY = -23;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack;
            int x = startX + i * 21;
            g.m_280163_(HUD_ATLAS, x, bgY, 0.0f, 48.0f, 20, 20, 256, 256);
            if (i == p.m_150109_().f_35977_) {
                g.m_280163_(HUD_ATLAS, x, bgY, 20.0f, 48.0f, 20, 20, 256, 256);
            }
            if ((stack = (ItemStack)p.m_150109_().f_35974_.get(i)).m_41619_()) continue;
            int itemX = x + 2;
            int itemY = bgY + 2 + 1;
            g.m_280480_(stack, itemX, itemY);
            g.m_280370_(mc.f_91062_, stack, itemX, itemY);
        }
        g.m_280168_().m_85849_();
    }

    private static void drawFromLeft(GuiGraphics g, int x, int y, int w, int u, int v) {
        if (w > 0) {
            g.m_280163_(HUD_ATLAS, x, y, (float)u, (float)v, w, 8, 256, 256);
        }
    }

    private static void drawFromRight(GuiGraphics g, int x, int y, int fullW, int w, int u, int v) {
        if (w > 0) {
            g.m_280163_(HUD_ATLAS, x + fullW - w, y, (float)(u + fullW - w), (float)v, w, 8, 256, 256);
        }
    }
}

