/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyard;

import com.mojang.blaze3d.systems.RenderSystem;
import fox.org.mc.backyard.CustomMainMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="backyard", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LoadingScreenHandler {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("backyard", "textures/gui/background2.png");
    private static final ResourceLocation LOGO = new ResourceLocation("backyard", "textures/gui/logo.png");
    private static final ResourceLocation FONT = new ResourceLocation("backyard", "notosans");
    private static final ResourceLocation SOUND_PLAYGAME = new ResourceLocation("backyard", "playgame");
    private static float progress = 0.0f;
    private static long lastTime = 0L;
    private static boolean isConnecting = false;
    public static boolean shouldPlayIntro = false;

    public static void reset() {
        progress = 0.0f;
        lastTime = 0L;
        isConnecting = false;
    }

    @SubscribeEvent
    public static void onInitScreenPre(ScreenEvent.Init.Pre event) {
        if (event.getScreen() instanceof ConnectScreen) {
            if (shouldPlayIntro) {
                shouldPlayIntro = false;
                LoadingScreenHandler.playSoundReallyHard(SOUND_PLAYGAME);
            }
            if (!isConnecting) {
                progress = 0.0f;
                lastTime = System.currentTimeMillis();
                isConnecting = true;
            }
        } else if (event.getScreen() instanceof CustomMainMenu) {
            LoadingScreenHandler.reset();
        }
    }

    private static void playSoundReallyHard(ResourceLocation sound) {
        SimpleSoundInstance instance = new SimpleSoundInstance(sound, SoundSource.RECORDS, 1.0f, 1.0f, RandomSource.m_216327_(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)instance);
    }

    @SubscribeEvent
    public static void onInitScreenPost(ScreenEvent.Init.Post event) {
        boolean isLoading;
        Screen screen = event.getScreen();
        Minecraft mc = Minecraft.m_91087_();
        boolean isError = screen instanceof DisconnectedScreen;
        boolean bl = isLoading = screen instanceof ConnectScreen || screen instanceof ReceivingLevelScreen;
        if (isError || isLoading) {
            for (GuiEventListener listener : event.getListenersList()) {
                if (!(listener instanceof Button)) continue;
                ((Button)listener).f_93624_ = false;
                ((Button)listener).f_93623_ = false;
            }
            if (isError) {
                Button backButton = LoadingScreenHandler.createAnimatedButton(0, 0, 150, 24, (Component)Component.m_237113_((String)"Back to Main Menu"), btn -> mc.m_91152_((Screen)new CustomMainMenu()));
                event.addListener((GuiEventListener)backButton);
            } else if (screen instanceof ConnectScreen) {
                Button cancelButton = LoadingScreenHandler.createAnimatedButton(0, 0, 100, 24, (Component)Component.m_237113_((String)"Cancel"), btn -> {
                    if (mc.m_91403_() != null && mc.m_91403_().m_104910_() != null) {
                        mc.m_91403_().m_104910_().m_129507_((Component)Component.m_237113_((String)"Aborted by user"));
                    }
                    mc.m_91399_();
                    mc.m_91152_((Screen)new CustomMainMenu());
                });
                event.addListener((GuiEventListener)cancelButton);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderScreen(ScreenEvent.Render.Pre event) {
        Screen screen = event.getScreen();
        GuiGraphics g = event.getGuiGraphics();
        int w = screen.f_96543_;
        int h = screen.f_96544_;
        Minecraft mc = Minecraft.m_91087_();
        boolean isConnectingScreen = screen instanceof ConnectScreen;
        boolean isLoadWorldScreen = screen instanceof ReceivingLevelScreen;
        boolean isError = screen instanceof DisconnectedScreen;
        if (isConnectingScreen || isLoadWorldScreen || isError) {
            event.setCanceled(true);
            float brightness = isError ? 0.4f : 1.0f;
            LoadingScreenHandler.renderBackground(g, w, h, brightness);
            if (isLoadWorldScreen) {
                return;
            }
            if (isError) {
                int logoW = 200;
                int logoH = 80;
                int logoX = (w - logoW) / 2;
                int logoY = 30;
                RenderSystem.enableBlend();
                g.m_280163_(LOGO, logoX, logoY, 0.0f, 0.0f, logoW, logoH, logoW, logoH);
                RenderSystem.disableBlend();
            }
            if (isConnectingScreen) {
                LoadingScreenHandler.updateProgress();
                int barWidth = 300;
                int barHeight = 6;
                int barX = (w - barWidth) / 2;
                int barY = h / 2 + 40;
                g.m_280509_(barX, barY, barX + barWidth, barY + barHeight, Integer.MIN_VALUE);
                int fillWidth = (int)((float)barWidth * progress);
                g.m_280509_(barX, barY, barX + fillWidth, barY + barHeight, -334081);
                String status = "Connecting...";
                int percent = (int)(progress * 100.0f);
                MutableComponent txt = Component.m_237113_((String)(status + " " + percent + "%")).m_130938_(s -> s.m_131150_(FONT));
                g.m_280653_(mc.f_91062_, (Component)txt, w / 2, barY - 15, 0xFFFFFF);
            }
            if (isError) {
                Component title = screen.m_96636_();
                int titleY = 120;
                g.m_280653_(mc.f_91062_, title, w / 2, titleY, -43691);
                int contentStartY = titleY + 25;
                for (GuiEventListener child : screen.m_6702_()) {
                    if (!(child instanceof AbstractWidget)) continue;
                    AbstractWidget widget = (AbstractWidget)child;
                    if (!widget.f_93624_) continue;
                    if (widget instanceof Button) {
                        widget.m_252865_((w - widget.m_5711_()) / 2);
                        widget.m_253211_(h - 50);
                    } else {
                        widget.m_252865_((w - widget.m_5711_()) / 2);
                        widget.m_253211_(contentStartY);
                        contentStartY += widget.m_93694_() + 5;
                    }
                    ((Renderable)child).m_88315_(g, event.getMouseX(), event.getMouseY(), event.getPartialTick());
                }
            }
        }
    }

    private static void renderBackground(GuiGraphics g, int w, int h, float brightness) {
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        g.m_280411_(BACKGROUND, 0, 0, w, h, 0.0f, 0.0f, w, h, w, h);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void updateProgress() {
        long now = System.currentTimeMillis();
        if (lastTime == 0L) {
            lastTime = now;
        }
        float deltaTime = (float)(now - lastTime) / 1000.0f;
        lastTime = now;
        if (progress < 0.8f) {
            progress += deltaTime * 0.3f;
        } else if ((progress += deltaTime * 0.05f) > 0.95f) {
            progress = 0.95f;
        }
    }

    private static Button createAnimatedButton(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
        return new Button(x, y, width, height, message, onPress, supplier -> (MutableComponent)supplier.get()){
            private float hoverProgress = 0.0f;

            public void m_87963_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
                Minecraft mc = Minecraft.m_91087_();
                Font font = mc.f_91062_;
                float target = this.m_198029_() ? 1.0f : 0.0f;
                this.hoverProgress = Mth.m_14179_((float)(0.2f * partialTick), (float)this.hoverProgress, (float)target);
                if (this.hoverProgress > 0.01f) {
                    int lineWidth = (int)((float)this.f_93618_ * this.hoverProgress);
                    int lineX = this.m_252754_() + (this.f_93618_ - lineWidth) / 2;
                    int lineY = this.m_252907_() + this.f_93619_ - 2;
                    g.m_280509_(lineX, lineY, lineX + lineWidth, lineY + 2, -334081);
                }
                int textColor = this.m_198029_() ? 0xFFFFFF : 0xE0E0E0;
                g.m_280614_(font, this.m_6035_(), this.m_252754_() + (this.f_93618_ - font.m_92852_((FormattedText)this.m_6035_())) / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, textColor, true);
            }
        };
    }
}

