/*
 * Decompiled with CFR 0.152.
 */
package fox.org.mc.backyard;

import com.mojang.blaze3d.systems.RenderSystem;
import fox.org.mc.backyard.LoadingScreenHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;

public class CustomMainMenu
extends Screen {
    private static final String SERVER_IP = "p.serfox.online:25598";
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("backyard", "textures/gui/background.png");
    private static final ResourceLocation CUSTOM_FONT = new ResourceLocation("backyard", "notosans");
    private boolean isTransitioning = false;
    private long transitionStartTime = 0L;
    private static final long TRANSITION_DURATION = 1000L;
    private boolean hasConnected = false;

    public CustomMainMenu() {
        super((Component)Component.m_237113_((String)"Backyard Main Menu"));
    }

    protected void m_7856_() {
        LoadingScreenHandler.reset();
        Minecraft mc = Minecraft.m_91087_();
        mc.f_91066_.m_246669_(SoundSource.MUSIC).m_231514_((Object)0.0);
        mc.m_91397_().m_120186_();
        mc.f_91066_.m_92169_();
        int btnHeight = 30;
        int logoHeight = 0;
        int gapBetweenLogoAndBtn = 0;
        int gapBetweenBtn = 1;
        int totalContentHeight = logoHeight + gapBetweenLogoAndBtn + 3 * btnHeight + 2 * gapBetweenBtn;
        int shiftDown = 30;
        int startY = (this.f_96544_ - totalContentHeight) / 2 + shiftDown;
        int buttonsStartY = startY + logoHeight + gapBetweenLogoAndBtn;
        int playX = 120;
        int playY = buttonsStartY;
        int playWidth = 50;
        int optX = 120;
        int optY = playY + btnHeight + gapBetweenBtn;
        int optWidth = 50;
        int quitX = 120;
        int quitY = optY + btnHeight + gapBetweenBtn;
        int quitWidth = 50;
        MutableComponent playText = Component.m_237115_((String)"backyard.play").m_130938_(style -> style.m_131150_(CUSTOM_FONT));
        this.m_142416_((GuiEventListener)this.createAnimatedButton(playX, playY, playWidth, btnHeight, (Component)playText, btn -> this.startPlayGame()));
        MutableComponent optionText = Component.m_237115_((String)"backyard.options").m_130938_(style -> style.m_131150_(CUSTOM_FONT));
        this.m_142416_((GuiEventListener)this.createAnimatedButton(optX, optY, optWidth, btnHeight, (Component)optionText, btn -> this.f_96541_.m_91152_((Screen)new OptionsScreen((Screen)this, this.f_96541_.f_91066_))));
        MutableComponent quitText = Component.m_237115_((String)"backyard.quit").m_130938_(style -> style.m_131150_(CUSTOM_FONT));
        this.m_142416_((GuiEventListener)this.createAnimatedButton(quitX, quitY, quitWidth, btnHeight, (Component)quitText, btn -> this.f_96541_.m_91395_()));
    }

    private void startPlayGame() {
        if (this.isTransitioning || this.hasConnected) {
            return;
        }
        this.isTransitioning = true;
        this.transitionStartTime = System.currentTimeMillis();
        LoadingScreenHandler.shouldPlayIntro = true;
    }

    private Button createAnimatedButton(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
        return new Button(x, y, width, height, message, onPress, supplier -> (MutableComponent)supplier.get()){
            private float hoverProgress;
            private final float fontSize = 1.2f;
            {
                this.hoverProgress = 0.0f;
                this.fontSize = 1.2f;
            }

            public void m_87963_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
                if (CustomMainMenu.this.isTransitioning) {
                    return;
                }
                float target = this.m_198029_() ? 1.0f : 0.0f;
                this.hoverProgress = Mth.m_14179_((float)(0.2f * partialTick), (float)this.hoverProgress, (float)target);
                if (this.hoverProgress > 0.01f) {
                    int lineWidth = (int)((float)this.f_93618_ * this.hoverProgress);
                    int lineX = this.m_252754_() + (this.f_93618_ - lineWidth) / 2;
                    int lineY = this.m_252907_() + this.f_93619_ - 2;
                    g.m_280509_(lineX, lineY, lineX + lineWidth, lineY + 2, -334081);
                }
                int textColor = this.m_198029_() ? 0xFFFFFF : 0xE0E0E0;
                g.m_280168_().m_85836_();
                float centerX = (float)this.m_252754_() + (float)this.f_93618_ / 2.0f;
                float centerY = (float)this.m_252907_() + (float)this.f_93619_ / 2.0f;
                g.m_280168_().m_252880_(centerX, centerY, 0.0f);
                g.m_280168_().m_85841_(1.2f, 1.2f, 1.0f);
                int textWidth = CustomMainMenu.this.f_96547_.m_92852_((FormattedText)this.m_6035_());
                g.m_280614_(CustomMainMenu.this.f_96547_, this.m_6035_(), -textWidth / 2, -4, textColor, true);
                g.m_280168_().m_85849_();
            }
        };
    }

    private void connect() {
        if (this.hasConnected) {
            return;
        }
        this.hasConnected = true;
        Minecraft mc = Minecraft.m_91087_();
        ServerData serverData = new ServerData("Backyard Server", SERVER_IP, false);
        ConnectScreen.m_278792_((Screen)this, (Minecraft)mc, (ServerAddress)ServerAddress.m_171864_((String)SERVER_IP), (ServerData)serverData, (boolean)false);
    }

    public void m_88315_(GuiGraphics g, int mx, int my, float pt) {
        if (this.hasConnected) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
        g.m_280411_(BACKGROUND_TEXTURE, 0, 0, this.f_96543_, this.f_96544_, 0.0f, 0.0f, this.f_96543_, this.f_96544_, this.f_96543_, this.f_96544_);
        if (!this.isTransitioning) {
            MutableComponent credit = Component.m_237113_((String)"Mod by Serfox").m_130938_(s -> s.m_131150_(CUSTOM_FONT));
            g.m_280430_(this.f_96547_, (Component)credit, this.f_96543_ - this.f_96547_.m_92852_((FormattedText)credit) - 5, this.f_96544_ - 15, 0xFFFFFF);
        }
        super.m_88315_(g, mx, my, pt);
        if (this.isTransitioning) {
            long elapsed = System.currentTimeMillis() - this.transitionStartTime;
            float fadeProgress = (float)elapsed / 1000.0f;
            if (fadeProgress >= 1.0f) {
                this.connect();
            } else {
                int alpha = (int)(fadeProgress * 255.0f);
                int blackOverlay = alpha << 24 | 0;
                g.m_280509_(0, 0, this.f_96543_, this.f_96544_, blackOverlay);
            }
        }
    }
}

