/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.util.codec;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class AzListStreamCodec<T> {
    private final Function<FriendlyByteBuf, T> decoder;
    private final BiConsumer<FriendlyByteBuf, T> encoder;

    public AzListStreamCodec(Function<FriendlyByteBuf, T> decoder, BiConsumer<FriendlyByteBuf, T> encoder) {
        this.decoder = decoder;
        this.encoder = encoder;
    }

    @NotNull
    public List<T> decode(FriendlyByteBuf buf) {
        int size = buf.readByte();
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.decoder.apply(buf));
        }
        return list;
    }

    public void encode(FriendlyByteBuf buf, List<T> elements) {
        buf.writeByte(elements.size());
        elements.forEach(element -> this.encoder.accept(buf, (FriendlyByteBuf)element));
    }
}

